/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.velocity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.BossBarInfo;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.proxy.velocity.LSChannelIdentifier;
import com.loohp.lotterysix.proxy.velocity.LotterySixVelocity;
import com.loohp.lotterysix.utils.ArrayUtils;
import com.loohp.lotterysix.utils.DataTypeIO;
import com.loohp.lotterysix.utils.SyncUtils;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class PluginMessageVelocity {
    private static final Gson GSON = new Gson();
    private static final byte[] EMPTY_DATA_ARRAY = new byte[0];
    private LotterySix instance;
    private final Map<Integer, ByteArrayOutputStream> incomingMessages;
    private final Random random;
    private final Map<RegisteredServer, AtomicInteger> sequenceCounter;
    private final AtomicInteger lastReceivedSequence;
    private final Executor executor;
    private final Map<Integer, CompletableFuture<Boolean>> takeMoneyRequests;
    private final Map<Integer, CompletableFuture<Boolean>> inventoryOpenedCompletion;

    public PluginMessageVelocity(LotterySix instance) {
        this.instance = instance;
        this.incomingMessages = new ConcurrentHashMap<Integer, ByteArrayOutputStream>();
        this.random = new Random();
        this.sequenceCounter = new ConcurrentHashMap<RegisteredServer, AtomicInteger>();
        this.lastReceivedSequence = new AtomicInteger();
        Cache takeMoneyRequestsCache = CacheBuilder.newBuilder().weakValues().build();
        this.takeMoneyRequests = takeMoneyRequestsCache.asMap();
        Cache inventoryOpenedCompletionCache = CacheBuilder.newBuilder().weakValues().build();
        this.inventoryOpenedCompletion = inventoryOpenedCompletionCache.asMap();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void setInstance(LotterySix instance) {
        this.instance = instance;
    }

    @Subscribe
    public void onMessageReceive(PluginMessageEvent event) {
        try {
            int nRead;
            if (!event.getIdentifier().getId().equals("lotterysix:main")) {
                return;
            }
            event.setResult(PluginMessageEvent.ForwardResult.handled());
            ChannelMessageSource source = event.getSource();
            if (!(source instanceof ServerConnection)) {
                return;
            }
            RegisteredServer senderServer = ((ServerConnection)source).getServer();
            byte[] packet = Arrays.copyOf(event.getData(), event.getData().length);
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet));
            int sequenceId = inputStream.readInt();
            short packetId = inputStream.readShort();
            boolean end = inputStream.readBoolean();
            ByteArrayOutputStream buffer = this.incomingMessages.get(sequenceId);
            if (buffer == null) {
                buffer = new ByteArrayOutputStream();
                this.incomingMessages.putIfAbsent(sequenceId, buffer);
            }
            byte[] b = new byte[1024];
            while ((nRead = inputStream.read(b, 0, b.length)) != -1) {
                buffer.write(b, 0, nRead);
            }
            if (!end) {
                return;
            }
            this.incomingMessages.remove(sequenceId);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            LotterySixVelocity.proxyServer.getScheduler().buildTask((Object)LotterySixVelocity.plugin, () -> {
                try {
                    SyncUtils.blockUntilTrue(() -> sequenceId <= this.lastReceivedSequence.get() + 1, 250L);
                    switch (packetId) {
                        case 0: {
                            PlayableLotterySixGame game = this.instance.getCurrentGame();
                            if (game == null) break;
                            String name = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            UUID player = DataTypeIO.readUUID(in);
                            long bet = in.readLong();
                            BetUnitType type = BetUnitType.values()[in.readInt()];
                            int size = in.readInt();
                            ArrayList<BetNumbers> betNumbers = new ArrayList<BetNumbers>(size);
                            for (int i2 = 0; i2 < size; ++i2) {
                                betNumbers.add(GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), BetNumbers.class));
                            }
                            int multipleDraw = in.readInt();
                            game.addBet(name, player, bet, type, betNumbers, multipleDraw);
                            break;
                        }
                        case 1: {
                            int id = in.readInt();
                            CompletableFuture<Boolean> future = this.takeMoneyRequests.remove(id);
                            if (future == null) break;
                            future.complete(in.readBoolean());
                            break;
                        }
                        case 2: {
                            int size = in.readInt();
                            HashSet<UUID> gameIds = new HashSet<UUID>(size);
                            for (int i3 = 0; i3 < size; ++i3) {
                                gameIds.add(DataTypeIO.readUUID(in));
                            }
                            this.respondPastGameSyncCheckResult(senderServer, gameIds);
                            break;
                        }
                        case 3: {
                            UUID player = DataTypeIO.readUUID(in);
                            PlayerPreferenceKey key = PlayerPreferenceKey.values()[in.readInt()];
                            Object value = key.getReader(DataTypeIO.readString(in, StandardCharsets.UTF_8));
                            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player);
                            lotteryPlayer.setPreference(key, value);
                            this.syncPlayerData(lotteryPlayer);
                            break;
                        }
                        case 4: {
                            UUID player = DataTypeIO.readUUID(in);
                            PlayerPreferenceKey key = PlayerPreferenceKey.values()[in.readInt()];
                            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player);
                            lotteryPlayer.resetPreference(key);
                            this.syncPlayerData(lotteryPlayer);
                            break;
                        }
                        case 5: {
                            UUID player = DataTypeIO.readUUID(in);
                            PlayerStatsKey key = PlayerStatsKey.values()[in.readInt()];
                            Object value = GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), key.getValueTypeClass());
                            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(player);
                            lotteryPlayer.setStats(key, value);
                            this.syncPlayerData(lotteryPlayer);
                            break;
                        }
                        case 6: {
                            UUID gameId = DataTypeIO.readUUID(in);
                            PlayableLotterySixGame game = this.instance.getCurrentGame();
                            if (game == null || !game.getGameId().equals(gameId)) break;
                            int size = in.readInt();
                            ArrayList<PlayerBets> bets = new ArrayList<PlayerBets>(size);
                            for (int i4 = 0; i4 < size; ++i4) {
                                UUID betId = DataTypeIO.readUUID(in);
                                PlayerBets bet = game.getBet(betId);
                                if (bet == null) continue;
                                bets.add(bet);
                            }
                            this.respondCurrentGameBets(senderServer, game.getGameId(), bets);
                            break;
                        }
                        case 7: {
                            int interactionId = in.readInt();
                            CompletableFuture<Boolean> future = this.inventoryOpenedCompletion.remove(interactionId);
                            if (future == null) break;
                            future.complete(true);
                            break;
                        }
                    }
                    this.lastReceivedSequence.updateAndGet(i -> Math.max(i, sequenceId));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).schedule();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendData(RegisteredServer info, int packetId, byte[] data) {
        this.executor.execute(() -> {
            int sequenceId = this.sequenceCounter.computeIfAbsent(info, e -> new AtomicInteger()).getAndIncrement();
            try {
                byte[][] dataArray = ArrayUtils.divideArray(data, 32700);
                for (int i = 0; i < dataArray.length; ++i) {
                    byte[] chunk = dataArray[i];
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(outputStream);
                    out.writeInt(sequenceId);
                    out.writeShort(packetId);
                    out.writeBoolean(i == dataArray.length - 1);
                    out.write(chunk);
                    info.sendPluginMessage((ChannelIdentifier)LSChannelIdentifier.INSTANCE, outputStream.toByteArray());
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        });
    }

    public void updateCurrentGameData() {
        PlayableLotterySixGame game = this.instance.getCurrentGame();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            if (game == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeUUID(out, game.getGameId());
                out.writeLong(game.getDatetime());
                DataTypeIO.writeGameNumber(out, game.getGameNumber());
                if (game.hasSpecialName()) {
                    out.writeBoolean(true);
                    DataTypeIO.writeString(out, game.getSpecialName(), StandardCharsets.UTF_8);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(game.getNumberStatistics().size());
                for (Map.Entry entry : game.getNumberStatistics().entrySet()) {
                    out.writeByte((Integer)entry.getKey());
                    DataTypeIO.writeNumberStatistics(out, (NumberStatistics)entry.getValue());
                }
                out.writeLong(game.getCarryOverFund());
                out.writeLong(game.getLowestTopPlacesPrize());
                out.writeBoolean(game.isValid());
                Set<UUID> betIds = game.getBetIds();
                out.writeInt(betIds.size());
                for (UUID betId : betIds) {
                    DataTypeIO.writeUUID(out, betId);
                }
            }
            for (RegisteredServer registeredServer : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(registeredServer, 0, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentGameData(RegisteredServer target) {
        PlayableLotterySixGame game = this.instance.getCurrentGame();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            if (game == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeUUID(out, game.getGameId());
                out.writeLong(game.getDatetime());
                DataTypeIO.writeGameNumber(out, game.getGameNumber());
                if (game.hasSpecialName()) {
                    out.writeBoolean(true);
                    DataTypeIO.writeString(out, game.getSpecialName(), StandardCharsets.UTF_8);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(game.getNumberStatistics().size());
                for (Map.Entry<Integer, NumberStatistics> entry : game.getNumberStatistics().entrySet()) {
                    out.writeByte(entry.getKey());
                    DataTypeIO.writeNumberStatistics(out, entry.getValue());
                }
                out.writeLong(game.getCarryOverFund());
                out.writeLong(game.getLowestTopPlacesPrize());
                out.writeBoolean(game.isValid());
                Set<UUID> betIds = game.getBetIds();
                out.writeInt(betIds.size());
                for (UUID betId : betIds) {
                    DataTypeIO.writeUUID(out, betId);
                }
            }
            this.sendData(target, 0, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateLastResultData() {
        if (this.instance.getCompletedGames().isEmpty()) {
            return;
        }
        CompletedLotterySixGame game = this.instance.getCompletedGames().get(0);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, game.getGameId());
            DataTypeIO.writeString(out, GSON.toJson(game), StandardCharsets.UTF_8);
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 1, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendFormattedTitle(Player player, ILotterySixGame game, String title, int fadeIn, int stay, int fadeOut) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            if (game == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeUUID(out, game.getGameId());
            }
            DataTypeIO.writeUUID(out, player.getUniqueId());
            DataTypeIO.writeString(out, title, StandardCharsets.UTF_8);
            out.writeInt(fadeIn);
            out.writeInt(stay);
            out.writeInt(fadeOut);
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 2, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendFormattedMessage(Player player, ILotterySixGame game, String message, String hover) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            if (game == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeUUID(out, game.getGameId());
            }
            DataTypeIO.writeUUID(out, player.getUniqueId());
            DataTypeIO.writeString(out, message, StandardCharsets.UTF_8);
            DataTypeIO.writeString(out, hover, StandardCharsets.UTF_8);
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 3, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void giveMoney(Player player, long amount) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getUniqueId());
            out.writeLong(amount);
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 4, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<Boolean> takeMoney(Player player, long amount) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            int id = this.random.nextInt();
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            out.writeInt(id);
            DataTypeIO.writeUUID(out, player.getUniqueId());
            out.writeLong(amount);
            this.takeMoneyRequests.put(id, future);
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 5, outputStream.toByteArray()));
            return future;
        }
        catch (IOException e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(false);
        }
    }

    public void forceCloseAllGui() {
        for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
            this.sendData(info, 6, EMPTY_DATA_ARRAY);
        }
    }

    public void callLotterySixEvent(LotterySixAction action) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeInt(action.ordinal());
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 7, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void callPlayerBetEvent(UUID uuid, BetNumbers numbers, long price, AddBetResult result) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, uuid);
            out.writeLong(price);
            out.writeInt(result.ordinal());
            DataTypeIO.writeString(out, GSON.toJson(numbers), StandardCharsets.UTF_8);
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 8, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateLockState(boolean locked) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeBoolean(locked);
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 9, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
            this.sendData(info, 10, EMPTY_DATA_ARRAY);
        }
    }

    public void requestPastGameSyncCheck(RegisteredServer target) {
        this.sendData(target, 11, EMPTY_DATA_ARRAY);
    }

    public void respondPastGameSyncCheckResult(RegisteredServer target, Set<UUID> gameIds) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            ArrayList<CompletedLotterySixGameIndex> games = new ArrayList<CompletedLotterySixGameIndex>();
            HashSet<UUID> notExist = new HashSet<UUID>(gameIds);
            for (CompletedLotterySixGameIndex gameIndex : this.instance.getCompletedGames().indexIterable()) {
                notExist.remove(gameIndex.getGameId());
                if (gameIds.contains(gameIndex.getGameId())) continue;
                games.add(gameIndex);
            }
            out.writeInt(games.size());
            for (CompletedLotterySixGameIndex gameIndex : games) {
                DataTypeIO.writeUUID(out, gameIndex.getGameId());
                DataTypeIO.writeString(out, GSON.toJson(this.instance.getCompletedGames().get(gameIndex)), StandardCharsets.UTF_8);
            }
            out.writeInt(notExist.size());
            for (UUID id : notExist) {
                DataTypeIO.writeUUID(out, id);
            }
            this.sendData(target, 12, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<Boolean> openPlayMenu(Player player) {
        return this.openPlayMenu(player, null);
    }

    public CompletableFuture<Boolean> openPlayMenu(Player player, String input) {
        int interactionId = this.random.nextInt();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.inventoryOpenedCompletion.put(interactionId, future);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getUniqueId());
            out.writeInt(interactionId);
            if (input == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeString(out, input, StandardCharsets.UTF_8);
            }
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 13, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return future;
    }

    public void addBetResult(Player player, AddBetResult result, long price) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getUniqueId());
            out.writeInt(result.ordinal());
            out.writeLong(price);
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 14, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void syncPlayerData(LotteryPlayer player) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getPlayer());
            DataTypeIO.writeString(out, GSON.toJson(player), StandardCharsets.UTF_8);
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 15, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updater(Player player) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getUniqueId());
            player.getCurrentServer().ifPresent(s -> this.sendData(s.getServer(), 16, outputStream.toByteArray()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updateBossBar(BossBarInfo bossBarInfo, ILotterySixGame game) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            if (bossBarInfo.getMessage() == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeString(out, bossBarInfo.getMessage(), StandardCharsets.UTF_8);
            }
            DataTypeIO.writeString(out, bossBarInfo.getColor(), StandardCharsets.UTF_8);
            DataTypeIO.writeString(out, bossBarInfo.getStyle(), StandardCharsets.UTF_8);
            out.writeDouble(bossBarInfo.getProgress());
            if (game == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                DataTypeIO.writeUUID(out, game.getGameId());
            }
            for (RegisteredServer info : LotterySixVelocity.proxyServer.getAllServers()) {
                this.sendData(info, 17, outputStream.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void respondCurrentGameBets(RegisteredServer target, UUID gameId, List<PlayerBets> bets) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, gameId);
            out.writeInt(bets.size());
            for (PlayerBets bet : bets) {
                DataTypeIO.writeString(out, GSON.toJson(bet), StandardCharsets.UTF_8);
            }
            this.sendData(target, 18, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

