/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import com.loohp.lotterysix.libs.com.cronutils.descriptor.CronDescriptor;
import com.loohp.lotterysix.libs.com.cronutils.model.Cron;
import com.loohp.lotterysix.libs.com.cronutils.model.CronType;
import com.loohp.lotterysix.libs.com.cronutils.model.definition.CronDefinition;
import com.loohp.lotterysix.libs.com.cronutils.model.definition.CronDefinitionBuilder;
import com.loohp.lotterysix.libs.com.cronutils.model.time.ExecutionTime;
import com.loohp.lotterysix.libs.com.cronutils.parser.CronParser;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.TimeZone;

public class CronUtils {
    public static final CronDefinition CRON_DEFINITION = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX);
    public static final CronParser PARSER = new CronParser(CRON_DEFINITION);

    public static CronDescriptor getDescriptor(Locale locale) {
        return CronDescriptor.instance(locale);
    }

    public static ZonedDateTime getNow(TimeZone timeZone) {
        return ZonedDateTime.now(timeZone.toZoneId());
    }

    public static ZonedDateTime getTime(long timestamp, TimeZone timeZone) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), timeZone.toZoneId());
    }

    public static ZonedDateTime getLastExecution(Cron cron, ZonedDateTime dateTime) {
        ExecutionTime executionTime = ExecutionTime.forCron(cron);
        return executionTime.lastExecution(dateTime).orElse(null);
    }

    public static ZonedDateTime getNextExecution(Cron cron, ZonedDateTime dateTime) {
        ExecutionTime executionTime = ExecutionTime.forCron(cron);
        return executionTime.nextExecution(dateTime).orElse(null);
    }

    public static boolean satisfyByCurrentMinute(Cron cron, TimeZone timeZone) {
        ZonedDateTime execution = CronUtils.getNextExecution(cron, CronUtils.getTime(System.currentTimeMillis() - 60000L, timeZone));
        ZonedDateTime now = CronUtils.getNow(timeZone);
        if (execution == null) {
            return false;
        }
        return execution.withNano(0).equals(now.withNano(0));
    }
}

