/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.config;

import com.loohp.lotterysix.libs.org.simpleyaml.configuration.comments.CommentType;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.file.YamlFile;
import com.loohp.lotterysix.libs.org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlImplementation;
import com.loohp.lotterysix.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Config {
    private static final Map<String, Config> CONFIGS = new HashMap<String, Config>();
    private File file;
    private YamlFile defConfig;
    private YamlFile config;

    public static Config getConfig(String id) {
        return CONFIGS.get(id);
    }

    public static void reloadConfigs() throws IOException {
        for (Config config : CONFIGS.values()) {
            config.reload();
        }
    }

    public static void saveConfigs() {
        for (Config config : CONFIGS.values()) {
            config.save();
        }
    }

    public static Config loadConfig(String id, File file, InputStream ifNotFound, InputStream def, boolean refreshComments, Consumer<Config> dataFixer, Predicate<String> copyDefaultFilter) throws IOException {
        if (CONFIGS.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate config id");
        }
        if (!file.exists()) {
            FileUtils.copy(ifNotFound, file);
        }
        Config config = new Config(file, def, refreshComments, dataFixer, copyDefaultFilter);
        CONFIGS.put(id, config);
        return config;
    }

    public static Config loadConfig(String id, File file, InputStream ifNotFound, InputStream def, boolean refreshComments) throws IOException {
        return Config.loadConfig(id, file, ifNotFound, def, refreshComments, null, path -> true);
    }

    public static Config loadConfig(String id, File file) throws IOException {
        if (Config.getConfig(id) != null) {
            throw new IllegalArgumentException("Duplicate config id");
        }
        if (!file.exists()) {
            try (PrintWriter pw = new PrintWriter(file);){
                pw.println();
                pw.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        Config config = new Config(file);
        CONFIGS.put(id, config);
        return config;
    }

    public static boolean unloadConfig(String id, boolean save) {
        Config config = CONFIGS.remove(id);
        if (config != null) {
            if (save) {
                config.save();
            }
            return true;
        }
        return false;
    }

    private Config(File file, InputStream def, boolean refreshComments, Consumer<Config> dataFixer, Predicate<String> copyDefaultFilter) throws IOException {
        this.file = file;
        this.defConfig = new YamlFile();
        this.defConfig.options().useComments(true);
        this.defConfig.options().charset(StandardCharsets.UTF_8);
        ((SnakeYamlImplementation)this.defConfig.getImplementation()).getDumperOptions().setSplitLines(false);
        this.defConfig.load(def);
        this.config = new YamlFile();
        this.config.options().useComments(true);
        this.config.options().charset(StandardCharsets.UTF_8);
        ((SnakeYamlImplementation)this.config.getImplementation()).getDumperOptions().setSplitLines(false);
        this.config.load(file);
        if (dataFixer != null) {
            dataFixer.accept(this);
            this.reload();
        }
        for (String path : this.defConfig.getValues(true).keySet()) {
            if (this.config.contains(path)) {
                if (!refreshComments) continue;
                this.config.setComment(path, this.defConfig.getComment(path, CommentType.BLOCK), CommentType.BLOCK);
                continue;
            }
            if (!copyDefaultFilter.test(path) || this.defConfig.isConfigurationSection(path)) continue;
            this.config.set(path, this.defConfig.get(path));
            this.config.setComment(path, this.defConfig.getComment(path, CommentType.BLOCK), CommentType.BLOCK);
        }
        this.save();
    }

    private Config(File file) throws IOException {
        this.config = new YamlFile();
        this.config.options().useComments(true);
        this.config.load(file);
        this.save();
    }

    public File getFile() {
        return this.file;
    }

    public void save() {
        this.save(this.file);
    }

    public void save(File file) {
        try {
            this.config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        try {
            this.config.load(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public YamlFile getConfiguration() {
        return this.config;
    }
}

