/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PlayerWinnings;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningNumbers;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.game.player.LotteryPlayerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class CompletedLotterySixGame
implements ILotterySixGame {
    public static final Comparator<PlayerWinnings> PLAYER_WINNINGS_COMPARATOR = Comparator.comparing(playerWinnings -> playerWinnings.getTier());
    private transient Map<PrizeTier, List<PlayerWinnings>> winnersByTierCache;
    private transient Map<PrizeTier, Double> winnerCountForTierCache;
    private transient Map<UUID, Map<PrizeTier, List<PlayerWinnings>>> winnersByBetCache;
    private transient List<PlayerBets> orderedBetCache;
    private final UUID gameId;
    private final long datetime;
    private final GameNumber gameNumber;
    private final String specialName;
    private final WinningNumbers drawResult;
    private final Map<Integer, NumberStatistics> numberStatistics;
    private final long pricePerBet;
    private final Map<PrizeTier, Long> prizeForTier;
    private final List<PlayerWinnings> winners;
    private final Map<UUID, PlayerBets> bets;
    private final long totalPrizes;
    private final long remainingFunds;
    private final long lotteriesFunds;

    public CompletedLotterySixGame(UUID gameId, long datetime, GameNumber gameNumber, String specialName, WinningNumbers drawResult, Map<Integer, NumberStatistics> numberStatistics, long pricePerBet, Map<PrizeTier, Long> prizeForTier, List<PlayerWinnings> winners, Map<UUID, PlayerBets> bets, long totalPrizes, long remainingFunds, long lotteriesFunds) {
        this.gameId = gameId;
        this.datetime = datetime;
        this.gameNumber = gameNumber;
        this.specialName = specialName;
        this.drawResult = drawResult;
        this.numberStatistics = numberStatistics;
        this.pricePerBet = pricePerBet;
        this.prizeForTier = prizeForTier;
        this.winners = Collections.unmodifiableList(winners);
        this.bets = Collections.unmodifiableMap(bets);
        this.totalPrizes = totalPrizes;
        this.remainingFunds = remainingFunds;
        this.lotteriesFunds = lotteriesFunds;
    }

    private synchronized void cacheWinnersByTier() {
        if (this.winnersByTierCache == null) {
            this.winnersByTierCache = new HashMap<PrizeTier, List<PlayerWinnings>>();
            for (PlayerWinnings winnings : this.winners) {
                this.winnersByTierCache.computeIfAbsent(winnings.getTier(), k -> new ArrayList()).add(winnings);
            }
        }
    }

    private synchronized void cacheWinnerCountForTier() {
        if (this.winnerCountForTierCache == null) {
            this.winnerCountForTierCache = new HashMap<PrizeTier, Double>();
            for (PrizeTier prizeTier : PrizeTier.values()) {
                this.winnerCountForTierCache.put(prizeTier, this.getWinnings(prizeTier).stream().mapToDouble(each -> each.getWinningBet(this).getType().getUnit()).sum());
            }
        }
    }

    private synchronized void cacheWinnersByBet() {
        if (this.winnersByBetCache == null) {
            this.winnersByBetCache = new HashMap<UUID, Map<PrizeTier, List<PlayerWinnings>>>();
            for (PlayerWinnings winnings : this.winners) {
                this.winnersByBetCache.computeIfAbsent(winnings.getWinningBetId(), k -> new HashMap()).computeIfAbsent(winnings.getTier(), k -> new ArrayList()).add(winnings);
            }
        }
    }

    private synchronized void cacheOrderedBets() {
        if (this.orderedBetCache == null) {
            this.orderedBetCache = this.bets.values().stream().sorted().collect(Collectors.toList());
        }
    }

    @Override
    public UUID getGameId() {
        return this.gameId;
    }

    @Override
    public GameNumber getGameNumber() {
        return this.gameNumber;
    }

    @Override
    public String getDataFileName(String extension) {
        return (this.gameNumber == null ? GameNumber.UNKNOWN : this.gameNumber).toString().replace("/", "_") + "_" + this.datetime + "." + extension;
    }

    public CompletedLotterySixGameIndex toGameIndex() {
        return new CompletedLotterySixGameIndex(this.gameId, this.datetime, this.gameNumber, this.drawResult, this.specialName);
    }

    @Override
    public long getDatetime() {
        return this.datetime;
    }

    @Override
    public boolean hasSpecialName() {
        return this.specialName != null && !this.specialName.isEmpty();
    }

    @Override
    public String getSpecialName() {
        return this.specialName;
    }

    public WinningNumbers getDrawResult() {
        return this.drawResult;
    }

    public NumberStatistics getNumberStatistics(int number) {
        if (this.numberStatistics == null) {
            return NumberStatistics.NOT_EVER_DRAWN;
        }
        return this.numberStatistics.getOrDefault(number, NumberStatistics.NOT_EVER_DRAWN);
    }

    public Map<Integer, NumberStatistics> getNumberStatistics() {
        return this.numberStatistics == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.numberStatistics);
    }

    public long getPricePerBet(BetUnitType type) {
        return this.pricePerBet / (long)type.getDivisor();
    }

    public List<PlayerWinnings> getWinnings() {
        return this.winners;
    }

    public List<PlayerWinnings> getWinnings(PrizeTier prizeTier) {
        this.cacheWinnersByTier();
        return Collections.unmodifiableList(this.winnersByTierCache.getOrDefault((Object)prizeTier, Collections.emptyList()));
    }

    public List<PlayerBets> getBets() {
        this.cacheOrderedBets();
        return this.orderedBetCache;
    }

    public PlayerBets getBet(UUID betId) {
        return this.bets.get(betId);
    }

    public long getTotalBets() {
        return this.bets.values().stream().mapToLong(each -> each.getBet()).sum();
    }

    public boolean hasPlayerWinnings(UUID player) {
        return this.winners.stream().anyMatch(each -> each.getPlayer().equals(player));
    }

    public List<PlayerWinnings> getPlayerWinnings(UUID player) {
        return Collections.unmodifiableList(this.winners.stream().filter(each -> each.getPlayer().equals(player)).collect(Collectors.toList()));
    }

    public List<PlayerWinnings> getSortedPlayerWinnings(UUID player) {
        return Collections.unmodifiableList(this.winners.stream().filter(each -> each.getPlayer().equals(player)).sorted(PLAYER_WINNINGS_COMPARATOR).collect(Collectors.toList()));
    }

    public List<PlayerBets> getPlayerBets(UUID player) {
        return Collections.unmodifiableList(this.bets.values().stream().filter(each -> each.getPlayer().equals(player)).sorted().collect(Collectors.toList()));
    }

    public Map<PrizeTier, List<PlayerWinnings>> getPlayerWinningsByBet(PlayerBets bet) {
        return this.getPlayerWinningsByBet(bet.getBetId());
    }

    public Map<PrizeTier, List<PlayerWinnings>> getPlayerWinningsByBet(UUID betId) {
        this.cacheWinnersByBet();
        return Collections.unmodifiableMap(this.winnersByBetCache.getOrDefault(betId, Collections.emptyMap()));
    }

    public long getTotalPrizes() {
        return this.totalPrizes;
    }

    public long getPrizeForTier(PrizeTier prizeTier) {
        return this.prizeForTier.getOrDefault((Object)prizeTier, 0L);
    }

    public double getWinnerCountForTier(PrizeTier prizeTier) {
        this.cacheWinnerCountForTier();
        return this.winnerCountForTierCache.get((Object)prizeTier);
    }

    public long getRemainingFunds() {
        return this.remainingFunds;
    }

    public long getLotteriesFunds() {
        return this.lotteriesFunds;
    }

    public void givePrizesAndUpdateStats(LotterySix instance, Runnable onCompletion) {
        new Thread(() -> {
            LotteryPlayer lotteryPlayer;
            LotteryPlayerManager lotteryPlayerManager = instance.getLotteryPlayerManager();
            HashMap<UUID, Long> transactions = new HashMap<UUID, Long>();
            HashMap<UUID, PrizeTier> prizeTiers = new HashMap<UUID, PrizeTier>();
            HashMap<UUID, List> multipleDrawBets = new HashMap<UUID, List>();
            for (PlayerWinnings playerWinnings : this.winners) {
                transactions.merge(playerWinnings.getPlayer(), playerWinnings.getWinnings(), (a, b) -> a + b);
                prizeTiers.merge(playerWinnings.getPlayer(), playerWinnings.getTier(), (a, b) -> a.ordinal() < b.ordinal() ? a : b);
            }
            for (PlayerBets playerBets : this.bets.values()) {
                PlayerBets decremented;
                List playerBets2 = multipleDrawBets.computeIfAbsent(playerBets.getPlayer(), k -> new ArrayList());
                if (!playerBets.isMultipleDraw() || (decremented = playerBets.decrementDrawsRemaining()).getDrawsRemaining() <= 0) continue;
                playerBets2.add(decremented);
            }
            HashMap<LotteryPlayer, Boolean> affected = new HashMap<LotteryPlayer, Boolean>();
            for (Map.Entry entry : multipleDrawBets.entrySet()) {
                lotteryPlayer = instance.getLotteryPlayerManager().getLotteryPlayer((UUID)entry.getKey());
                lotteryPlayer.setMultipleDrawPlayerBets((List)entry.getValue(), false);
                affected.put(lotteryPlayer, false);
            }
            for (Map.Entry entry : transactions.entrySet()) {
                lotteryPlayer = instance.getLotteryPlayerManager().getLotteryPlayer((UUID)entry.getKey());
                PrizeTier prizeTier = (PrizeTier)((Object)((Object)prizeTiers.get(entry.getKey())));
                long total = (Long)entry.getValue();
                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + total, false);
                lotteryPlayer.updateStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE, i -> i + total, false);
                lotteryPlayer.updateStats(PlayerStatsKey.TOTAL_WINNINGS, Long.TYPE, i -> i + total, false);
                lotteryPlayer.updateStats(PlayerStatsKey.HIGHEST_WON_TIER, PrizeTier.class, t -> t == null || prizeTier.ordinal() < t.ordinal(), prizeTier, false);
                affected.put(lotteryPlayer, true);
            }
            if (instance.lotteriesFundAccount != null) {
                LotteryPlayer lotteryPlayer2 = lotteryPlayerManager.getLotteryPlayer(instance.lotteriesFundAccount);
                lotteryPlayer2.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + this.lotteriesFunds, false);
                lotteryPlayer2.updateStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE, i -> i + this.lotteriesFunds, false);
                affected.put(lotteryPlayer2, true);
            }
            for (Map.Entry entry : affected.entrySet()) {
                lotteryPlayer = (LotteryPlayer)entry.getKey();
                lotteryPlayer.save();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                instance.notifyBalanceChangeConsumer(lotteryPlayer.getPlayer());
            }
            onCompletion.run();
        }, "LotterySix Win Prize Distribution Thread - " + this.gameNumber).start();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedLotterySixGame that = (CompletedLotterySixGame)o;
        return this.datetime == that.datetime && this.pricePerBet == that.pricePerBet && this.totalPrizes == that.totalPrizes && this.remainingFunds == that.remainingFunds && Objects.equals(this.gameId, that.gameId) && Objects.equals(this.gameNumber, that.gameNumber) && Objects.equals(this.specialName, that.specialName) && Objects.equals(this.drawResult, that.drawResult) && Objects.equals(this.numberStatistics, that.numberStatistics) && Objects.equals(this.prizeForTier, that.prizeForTier) && Objects.equals(this.winners, that.winners) && Objects.equals(this.bets, that.bets);
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.datetime, this.gameNumber, this.specialName, this.drawResult, this.numberStatistics, this.pricePerBet, this.prizeForTier, this.winners, this.bets, this.totalPrizes, this.remainingFunds);
    }
}

