/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.objects.WinningNumbers;
import java.util.Objects;
import java.util.UUID;

public class CompletedLotterySixGameIndex
implements ILotterySixGame {
    private transient WinningNumbers drawResultCache;
    private final UUID gameId;
    private final long datetime;
    private final GameNumber gameNumber;
    private final String drawResult;
    private final String specialName;

    public CompletedLotterySixGameIndex(UUID gameId, long datetime, GameNumber gameNumber, WinningNumbers drawResult, String specialName) {
        this.gameId = gameId;
        this.datetime = datetime;
        this.gameNumber = gameNumber;
        this.drawResultCache = drawResult;
        this.drawResult = drawResult.toString();
        this.specialName = specialName;
    }

    @Override
    public UUID getGameId() {
        return this.gameId;
    }

    @Override
    public GameNumber getGameNumber() {
        return this.gameNumber;
    }

    @Override
    public boolean hasSpecialName() {
        return this.specialName != null && !this.specialName.isEmpty();
    }

    @Override
    public long getDatetime() {
        return this.datetime;
    }

    @Override
    public String getDataFileName(String extension) {
        return (this.gameNumber == null ? GameNumber.UNKNOWN : this.gameNumber).toString().replace("/", "_") + "_" + this.datetime + "." + extension;
    }

    public WinningNumbers getDrawResult() {
        if (this.drawResultCache != null) {
            return this.drawResultCache;
        }
        this.drawResultCache = WinningNumbers.fromString(this.drawResult);
        return this.drawResultCache;
    }

    @Override
    public String getSpecialName() {
        return this.specialName;
    }

    public boolean isDetailsComplete() {
        return this.gameId != null && this.gameNumber != null && this.drawResult != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletedLotterySixGameIndex gameIndex = (CompletedLotterySixGameIndex)o;
        return this.datetime == gameIndex.datetime && Objects.equals(this.gameId, gameIndex.gameId) && Objects.equals(this.gameNumber, gameIndex.gameNumber) && Objects.equals(this.drawResult, gameIndex.drawResult) && Objects.equals(this.specialName, gameIndex.specialName);
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.datetime, this.gameNumber, this.drawResult, this.specialName);
    }
}

