/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.loohp.lotterysix.game.lottery.CompletedLotteryGamesQuery;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.GameNumber;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LazyCompletedLotterySixGameList
implements List<CompletedLotterySixGame>,
RandomAccess {
    private final Function<CompletedLotterySixGameIndex, CompletedLotterySixGame> gameLoader;
    private final List<CompletedLotterySixGameIndex> gameIndexes;
    private final Map<UUID, CompletedLotterySixGame> cachedGames;
    private final Map<UUID, CompletedLotterySixGame> dirtyGames;
    private final Map<UUID, Object> gameLoadingLock;

    public LazyCompletedLotterySixGameList(Function<CompletedLotterySixGameIndex, CompletedLotterySixGame> gameLoader) {
        this.gameLoader = gameLoader;
        this.gameIndexes = new CopyOnWriteArrayList<CompletedLotterySixGameIndex>();
        Cache cache = CacheBuilder.newBuilder().maximumSize(20L).build();
        this.cachedGames = cache.asMap();
        this.dirtyGames = new ConcurrentHashMap<UUID, CompletedLotterySixGame>();
        Cache loadingLock = CacheBuilder.newBuilder().weakValues().build();
        this.gameLoadingLock = loadingLock.asMap();
    }

    private LazyCompletedLotterySixGameList(Function<CompletedLotterySixGameIndex, CompletedLotterySixGame> gameLoader, List<CompletedLotterySixGameIndex> gameIndexes, Map<UUID, CompletedLotterySixGame> cachedGames, Map<UUID, CompletedLotterySixGame> dirtyGames, Map<UUID, Object> gameLoadingLock) {
        this.gameLoader = gameLoader;
        this.gameIndexes = gameIndexes;
        this.cachedGames = cachedGames;
        this.dirtyGames = dirtyGames;
        this.gameLoadingLock = gameLoadingLock;
    }

    private Object getGameLoadingLock(UUID gameId) {
        return this.gameLoadingLock.computeIfAbsent(gameId, k -> new Object());
    }

    private CompletedLotterySixGame lookForCached(UUID gameId) {
        CompletedLotterySixGame game = this.dirtyGames.get(gameId);
        if (game != null) {
            return game;
        }
        return this.cachedGames.get(gameId);
    }

    public void setGameDirty(UUID gameId) {
        CompletedLotterySixGame game = this.lookForCached(gameId);
        if (game != null) {
            this.cachedGames.remove(gameId);
            this.dirtyGames.put(gameId, game);
        }
    }

    public Iterator<CompletedLotterySixGame> dirtyGamesIterator() {
        return this.dirtyGames.values().iterator();
    }

    public Iterable<CompletedLotterySixGame> dirtyGamesIterable() {
        return () -> this.dirtyGamesIterator();
    }

    public CompletedLotterySixGame getLatest() {
        if (this.gameIndexes.isEmpty()) {
            return null;
        }
        return this.get(this.gameIndexes.get(0));
    }

    @Override
    public CompletedLotterySixGame get(int index) {
        CompletedLotterySixGameIndex gameIndex = this.gameIndexes.get(index);
        if (gameIndex == null) {
            return null;
        }
        return this.get(gameIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletedLotterySixGame get(CompletedLotterySixGameIndex gameIndex) {
        UUID gameId = gameIndex.getGameId();
        Object object = this.getGameLoadingLock(gameId);
        synchronized (object) {
            CompletedLotterySixGame game = this.lookForCached(gameId);
            if (game != null) {
                return game;
            }
            game = this.gameLoader.apply(gameIndex);
            this.cachedGames.put(gameIndex.getGameId(), game);
            return game;
        }
    }

    public CompletedLotterySixGame get(GameNumber gameNumber) {
        for (CompletedLotterySixGameIndex gameIndex : this.gameIndexes) {
            GameNumber number = gameIndex.getGameNumber();
            if (!Objects.equals(number, gameNumber)) continue;
            return this.get(gameIndex);
        }
        return null;
    }

    public CompletedLotterySixGameIndex getIndex(int index) {
        return this.gameIndexes.get(index);
    }

    @Override
    public int size() {
        return this.gameIndexes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null || o instanceof CompletedLotterySixGameIndex) {
            return this.gameIndexes.contains(o);
        }
        if (o instanceof CompletedLotterySixGame) {
            return this.gameIndexes.contains(((CompletedLotterySixGame)o).toGameIndex());
        }
        return false;
    }

    public boolean contains(CompletedLotterySixGameIndex o) {
        return this.gameIndexes.contains(o);
    }

    @Override
    public CompletedLotterySixGame set(int index, CompletedLotterySixGame element) {
        CompletedLotterySixGame lastGame = this.get(index);
        this.cachedGames.remove(lastGame.getGameId());
        CompletedLotterySixGameIndex gameIndex = element.toGameIndex();
        this.gameIndexes.set(index, gameIndex);
        this.dirtyGames.put(gameIndex.getGameId(), element);
        return lastGame;
    }

    @Override
    public CompletedLotterySixGame set(int index, CompletedLotterySixGameIndex gameIndex) {
        CompletedLotterySixGame lastGame = this.get(index);
        this.cachedGames.remove(lastGame.getGameId());
        this.gameIndexes.set(index, gameIndex);
        return lastGame;
    }

    @Override
    public boolean add(CompletedLotterySixGame element) {
        CompletedLotterySixGameIndex gameIndex = element.toGameIndex();
        this.dirtyGames.put(gameIndex.getGameId(), element);
        return this.gameIndexes.add(gameIndex);
    }

    @Override
    public void add(int index, CompletedLotterySixGame element) {
        CompletedLotterySixGameIndex gameIndex = element.toGameIndex();
        this.gameIndexes.add(index, gameIndex);
        this.dirtyGames.put(gameIndex.getGameId(), element);
    }

    public boolean addUnloaded(CompletedLotterySixGameIndex gameIndex) {
        return this.gameIndexes.add(gameIndex);
    }

    public void addUnloaded(int index, CompletedLotterySixGameIndex gameIndex) {
        this.gameIndexes.add(index, gameIndex);
    }

    @Override
    public boolean remove(Object o) {
        if (o == null || o instanceof CompletedLotterySixGameIndex) {
            return this.gameIndexes.remove(o);
        }
        if (o instanceof CompletedLotterySixGame) {
            return this.gameIndexes.remove(((CompletedLotterySixGame)o).toGameIndex());
        }
        return false;
    }

    public boolean remove(CompletedLotterySixGameIndex o) {
        return this.gameIndexes.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(o -> this.contains(o));
    }

    @Override
    public boolean addAll(Collection<? extends CompletedLotterySixGame> c) {
        boolean result = false;
        for (CompletedLotterySixGame completedLotterySixGame : c) {
            result |= this.add(completedLotterySixGame);
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends CompletedLotterySixGame> c) {
        boolean result = false;
        for (CompletedLotterySixGame completedLotterySixGame : c) {
            this.add(index++, completedLotterySixGame);
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Optional<Object> optSample = c.stream().filter(o -> o != null).findAny();
        if (!optSample.isPresent()) {
            if (c.isEmpty()) {
                result = !this.isEmpty();
                this.clear();
                return result;
            }
            return this.gameIndexes.retainAll(Collections.singleton(null));
        }
        Object sample = optSample.get();
        if (sample instanceof CompletedLotterySixGameIndex) {
            for (CompletedLotterySixGameIndex gameIndex : this.gameIndexes) {
                if (c.contains(gameIndex)) continue;
                result |= this.remove(gameIndex);
            }
            return result;
        }
        if (sample instanceof CompletedLotterySixGame) {
            c = c.stream().map(g -> ((CompletedLotterySixGame)g).toGameIndex()).collect(Collectors.toSet());
            for (CompletedLotterySixGameIndex gameIndex : this.gameIndexes) {
                if (c.contains(gameIndex)) continue;
                result |= this.remove(gameIndex);
            }
            return result;
        }
        result = !this.isEmpty();
        this.clear();
        return result;
    }

    @Override
    public CompletedLotterySixGame remove(int index) {
        CompletedLotterySixGame game = this.get(index);
        CompletedLotterySixGameIndex gameIndex = this.gameIndexes.remove(index);
        this.cachedGames.remove(gameIndex.getGameId());
        return game;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || o instanceof CompletedLotterySixGameIndex) {
            return this.gameIndexes.indexOf(o);
        }
        if (o instanceof CompletedLotterySixGame) {
            return this.gameIndexes.indexOf(((CompletedLotterySixGame)o).toGameIndex());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null || o instanceof CompletedLotterySixGameIndex) {
            return this.gameIndexes.lastIndexOf(o);
        }
        if (o instanceof CompletedLotterySixGame) {
            return this.gameIndexes.lastIndexOf(((CompletedLotterySixGame)o).toGameIndex());
        }
        return -1;
    }

    @Override
    public ListIterator<CompletedLotterySixGame> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<CompletedLotterySixGame> listIterator(int index) {
        return new ListIterator<CompletedLotterySixGame>(){
            private final ListIterator<CompletedLotterySixGameIndex> itr;
            {
                this.itr = LazyCompletedLotterySixGameList.this.indexListIterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public CompletedLotterySixGame next() {
                return LazyCompletedLotterySixGameList.this.get(this.itr.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.itr.hasPrevious();
            }

            @Override
            public CompletedLotterySixGame previous() {
                return LazyCompletedLotterySixGameList.this.get(this.itr.previous());
            }

            @Override
            public int nextIndex() {
                return this.itr.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.itr.previousIndex();
            }

            @Override
            public void remove() {
                this.itr.remove();
            }

            @Override
            public void set(CompletedLotterySixGame completedLotterySixGame) {
                this.itr.set(completedLotterySixGame.toGameIndex());
            }

            @Override
            public void add(CompletedLotterySixGame completedLotterySixGame) {
                this.itr.add(completedLotterySixGame.toGameIndex());
            }
        };
    }

    public ListIterator<CompletedLotterySixGameIndex> indexListIterator() {
        return this.indexListIterator(0);
    }

    public ListIterator<CompletedLotterySixGameIndex> indexListIterator(int index) {
        return this.gameIndexes.listIterator(index);
    }

    public LazyCompletedLotterySixGameList subList(int fromIndex, int toIndex) {
        return new LazyCompletedLotterySixGameList(this.gameLoader, this.gameIndexes.subList(fromIndex, toIndex), this.cachedGames, this.dirtyGames, this.gameLoadingLock);
    }

    @Override
    public Iterator<CompletedLotterySixGame> iterator() {
        return new Iterator<CompletedLotterySixGame>(){
            private final Iterator<CompletedLotterySixGameIndex> itr;
            {
                this.itr = LazyCompletedLotterySixGameList.this.indexIterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public CompletedLotterySixGame next() {
                return LazyCompletedLotterySixGameList.this.get(this.itr.next());
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    @Override
    @Deprecated
    public Object[] toArray() {
        return this.indexStream().map(this::get).toArray();
    }

    @Override
    @Deprecated
    public <T> T[] toArray(T[] a) {
        Object[] array = this.toArray();
        if (a.length < array.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), array.length);
        }
        System.arraycopy(array, 0, a, 0, array.length);
        return a;
    }

    @Override
    public Stream<CompletedLotterySixGame> stream() {
        return this.indexStream().map(this::get);
    }

    @Override
    public Stream<CompletedLotterySixGame> parallelStream() {
        return this.indexParallelStream().map(this::get);
    }

    public Iterator<CompletedLotterySixGameIndex> indexIterator() {
        return this.gameIndexes.iterator();
    }

    public Iterable<CompletedLotterySixGameIndex> indexIterable() {
        return () -> this.indexIterator();
    }

    public Spliterator<CompletedLotterySixGameIndex> indexSpliterator() {
        return this.gameIndexes.spliterator();
    }

    public Stream<CompletedLotterySixGameIndex> indexStream() {
        return this.gameIndexes.stream();
    }

    public Stream<CompletedLotterySixGameIndex> indexParallelStream() {
        return this.gameIndexes.parallelStream();
    }

    public List<CompletedLotterySixGameIndex> query(CompletedLotteryGamesQuery query, TimeZone timeZone) {
        return this.query(query, -1, timeZone);
    }

    public List<CompletedLotterySixGameIndex> query(CompletedLotteryGamesQuery query, int numberOfGames, TimeZone timeZone) {
        Stream<CompletedLotterySixGameIndex> stream = this.queryStream(query, timeZone);
        if (numberOfGames >= 0) {
            stream = stream.limit(numberOfGames);
        }
        return stream.collect(Collectors.toList());
    }

    public Stream<CompletedLotterySixGameIndex> queryStream(CompletedLotteryGamesQuery query, TimeZone timeZone) {
        Predicate<CompletedLotterySixGameIndex> predicate = query.getQueryPredicate(this, timeZone);
        return this.indexStream().filter(predicate);
    }

    @Override
    public void clear() {
        for (CompletedLotterySixGameIndex gameIndex : this.gameIndexes) {
            this.remove(gameIndex);
        }
    }

    @Override
    @Deprecated
    public void sort(Comparator<? super CompletedLotterySixGame> comparator) {
        this.indexSort(Comparator.comparing(this::get, comparator));
    }

    public void indexSort(Comparator<? super CompletedLotterySixGameIndex> comparator) {
        this.gameIndexes.sort(comparator);
    }
}

