/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class Pair<F, S> {
    private final F first;
    private final S second;

    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public <T> T product(BiFunction<F, S, T> function) {
        return function.apply(this.first, this.second);
    }

    public void consume(BiConsumer<F, S> consumer) {
        consumer.accept(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }
}

