/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.utils.MathUtils;

public enum PrizeTier {
    FIRST("1st", new WinningCriteria(6, false), 7680, 2, true),
    SECOND("2nd", new WinningCriteria(5, true), 3840, 2, true),
    THIRD("3rd", new WinningCriteria(5, false), 1920, 2, true),
    FOURTH("4th", new WinningCriteria(4, true), 960, 15),
    FIFTH("5th", new WinningCriteria(4, false), 64, 2),
    SIXTH("6th", new WinningCriteria(3, true), 32, 8),
    SEVENTH("7th", new WinningCriteria(3, false), 4, 1);

    private final String shortHand;
    private final WinningCriteria winningCriteria;
    private int fixedPrizeMultiplier;
    private int minimumMultiplierFromLast;
    private final boolean isVariableTier;

    private PrizeTier(String shortHand, WinningCriteria winningCriteria, int fixedPrizeMultiplier, int minimumMultiplierFromLast, boolean isVariableTier) {
        this.shortHand = shortHand;
        this.winningCriteria = winningCriteria;
        this.fixedPrizeMultiplier = fixedPrizeMultiplier;
        this.minimumMultiplierFromLast = minimumMultiplierFromLast;
        this.isVariableTier = isVariableTier;
    }

    private PrizeTier(String shortHand, WinningCriteria winningCriteria, int fixedPrizeMultiplier, int minimumMultiplierFromLast) {
        this(shortHand, winningCriteria, fixedPrizeMultiplier, minimumMultiplierFromLast, false);
    }

    public String getShortHand() {
        return this.shortHand;
    }

    public WinningCriteria getWinningCriteria() {
        return this.winningCriteria;
    }

    public int getFixedPrizeMultiplier() {
        return this.fixedPrizeMultiplier;
    }

    @Deprecated
    public void setFixedPrizeMultiplier(int fixedPrizeMultiplier) {
        this.fixedPrizeMultiplier = fixedPrizeMultiplier;
    }

    public int getMinimumMultiplierFromLast() {
        return this.minimumMultiplierFromLast;
    }

    @Deprecated
    public void setMinimumMultiplierFromLast(int minimumMultiplierFromLast) {
        this.minimumMultiplierFromLast = minimumMultiplierFromLast;
    }

    public boolean isVariableTier() {
        return this.isVariableTier;
    }

    public String toString() {
        return this.getShortHand();
    }

    public static class WinningCriteria {
        private final int matchNumbers;
        private final boolean requireSpecialNumber;

        public WinningCriteria(int matchNumbers, boolean requireSpecialNumber) {
            this.matchNumbers = matchNumbers;
            this.requireSpecialNumber = requireSpecialNumber;
        }

        public boolean satisfies(int matches, boolean matchedSpecial) {
            return matches >= this.matchNumbers && (!this.requireSpecialNumber || matchedSpecial);
        }

        public double probability(int numberOfChoices) {
            int notMatched = (this.requireSpecialNumber ? 5 : 6) - this.matchNumbers;
            return MathUtils.probabilityFormula(6.0, this.matchNumbers) * MathUtils.probabilityFormula(numberOfChoices - 6 - 1, notMatched) / MathUtils.probabilityFormula(numberOfChoices, 6.0);
        }

        public double oneOverProbability(int numberOfChoices) {
            return 1.0 / this.probability(numberOfChoices);
        }

        public int getMatchNumbers() {
            return this.matchNumbers;
        }

        public boolean requireSpecialNumber() {
            return this.requireSpecialNumber;
        }
    }
}

