/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.objects.FormattedString;
import com.loohp.lotterysix.utils.ChatColorUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class WinningCombination
implements FormattedString {
    private final Set<Integer> numbers;

    public WinningCombination(Collection<Integer> numbers) {
        this.numbers = Collections.unmodifiableSet(new TreeSet<Integer>(numbers));
    }

    public Set<Integer> getNumbers() {
        return this.numbers;
    }

    public String toString() {
        return this.numbers.stream().sorted().map(each -> each.toString()).collect(Collectors.joining(" "));
    }

    @Override
    public String toFormattedString() {
        return this.numbers.stream().sorted().map(each -> ChatColorUtils.getNumberColor(each) + each.toString()).collect(Collectors.joining(" "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WinningCombination that = (WinningCombination)o;
        return this.numbers.equals(that.numbers);
    }

    public int hashCode() {
        return Objects.hash(this.numbers);
    }
}

