/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects.betnumbers;

import com.loohp.lotterysix.game.objects.Pair;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.game.objects.betnumbers.IntObjectPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class BetNumbersBuilder
implements Iterable<Integer> {
    public static final Pattern RANDOM_REP_PATTERN = Pattern.compile("^RAN/([0-9]+)(?:/([0-9]+))?(?:/([0-9]+))?$");
    protected final int minNumber;
    protected final int maxNumber;
    protected final BetNumbersType type;
    protected boolean validateCompleteOnAdd;

    public static Pair<Stream<? extends BetNumbersBuilder>, BetNumbersType> fromString(int minNumber, int maxNumber, String input) {
        int number;
        BetNumbersBuilder builder;
        Matcher matcher = RANDOM_REP_PATTERN.matcher(input);
        if (matcher.find()) {
            int selection;
            int size;
            int count;
            String group1 = matcher.group(1);
            if (group1 == null) {
                return null;
            }
            try {
                count = Integer.parseInt(group1);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (count <= 0) {
                return null;
            }
            String group2 = matcher.group(2);
            if (group2 == null) {
                try {
                    return Pair.of(BetNumbersBuilder.random(minNumber, maxNumber, count), BetNumbersType.RANDOM);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            try {
                size = Integer.parseInt(group2);
            }
            catch (NumberFormatException e) {
                return null;
            }
            String group3 = matcher.group(3);
            if (group3 == null) {
                if (size < 7) {
                    return null;
                }
                try {
                    return Pair.of(BetNumbersBuilder.multipleRandom(minNumber, maxNumber, size, count), BetNumbersType.MULTIPLE_RANDOM);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            try {
                selection = Integer.parseInt(group3);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (size > 5) {
                return null;
            }
            if (selection + size < 7) {
                return null;
            }
            try {
                return Pair.of(BetNumbersBuilder.bankerRandom(minNumber, maxNumber, size, selection, count), BetNumbersType.BANKER_RANDOM);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        String[] sections = input.split(" ");
        LinkedHashSet<Integer> bankers = null;
        LinkedHashSet<Integer> numbers = new LinkedHashSet<Integer>();
        for (String section : sections) {
            if (section.isEmpty()) continue;
            if (section.equals(">")) {
                if (numbers.isEmpty() || numbers.size() > 5) {
                    return null;
                }
                bankers = numbers;
                numbers = new LinkedHashSet();
                continue;
            }
            try {
                int number2 = Integer.parseInt(section);
                if (number2 < minNumber || number2 > maxNumber) {
                    return null;
                }
                if (numbers.add(number2)) continue;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (bankers == null) {
            if (numbers.size() < 6) {
                return null;
            }
            builder = numbers.size() == 6 ? new SingleBuilder(minNumber, maxNumber) : new MultipleBuilder(minNumber, maxNumber);
            Iterator iterator = numbers.iterator();
            while (iterator.hasNext()) {
                number = (Integer)iterator.next();
                builder.addNumber(number);
            }
            return Pair.of(Stream.of(builder), builder.getType());
        }
        if (numbers.isEmpty() || bankers.size() + numbers.size() < 7) {
            return null;
        }
        builder = new BankerBuilder(minNumber, maxNumber);
        Iterator iterator = bankers.iterator();
        while (iterator.hasNext()) {
            number = (Integer)iterator.next();
            ((BankerBuilder)builder).addNumber(number);
        }
        ((BankerBuilder)builder).finishBankers();
        iterator = numbers.iterator();
        while (iterator.hasNext()) {
            number = (Integer)iterator.next();
            if (((BankerBuilder)builder).contains(number)) {
                return null;
            }
            ((BankerBuilder)builder).addNumber(number);
        }
        return Pair.of(Stream.of(builder), builder.getType());
    }

    public static SingleBuilder single(int minNumber, int maxNumber) {
        return new SingleBuilder(minNumber, maxNumber);
    }

    public static MultipleBuilder multiple(int minNumber, int maxNumber) {
        return new MultipleBuilder(minNumber, maxNumber);
    }

    public static BankerBuilder banker(int minNumber, int maxNumber) {
        return new BankerBuilder(minNumber, maxNumber);
    }

    public static RandomBuilder random(int minNumber, int maxNumber) {
        return new RandomBuilder(minNumber, maxNumber);
    }

    public static Stream<RandomBuilder> random(int minNumber, int maxNumber, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count cannot be 0 or negative");
        }
        int perTicket = IntStream.iterate(10, i -> i - 1).limit(10L).filter(i -> count % i == 0 && count / i > 0).findFirst().orElse(1);
        int tickets = count / perTicket;
        if (tickets > 10) {
            throw new IllegalArgumentException("invalid count value, as it would result in more than 10 tickets");
        }
        return IntStream.range(0, tickets).mapToObj(i -> new RandomBuilder(minNumber, maxNumber, perTicket));
    }

    public static MultipleRandomBuilder multipleRandom(int minNumber, int maxNumber, int size) {
        return new MultipleRandomBuilder(minNumber, maxNumber, size);
    }

    public static Stream<MultipleRandomBuilder> multipleRandom(int minNumber, int maxNumber, int size, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count cannot be 0 or negative");
        }
        if (count > 10) {
            throw new IllegalArgumentException("invalid count value, as it would result in more than 10 tickets");
        }
        return IntStream.range(0, count).mapToObj(i -> new MultipleRandomBuilder(minNumber, maxNumber, size));
    }

    public static BankerRandomBuilder bankerRandom(int minNumber, int maxNumber, int bankerSize, int selectionSize) {
        return new BankerRandomBuilder(minNumber, maxNumber, bankerSize, selectionSize);
    }

    public static Stream<BankerRandomBuilder> bankerRandom(int minNumber, int maxNumber, int bankerSize, int selectionSize, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count cannot be 0 or negative");
        }
        if (count > 10) {
            throw new IllegalArgumentException("invalid count value, as it would result in more than 10 tickets");
        }
        return IntStream.range(0, count).mapToObj(i -> new BankerRandomBuilder(minNumber, maxNumber, bankerSize, selectionSize));
    }

    protected BetNumbersBuilder(int minNumber, int maxNumber, BetNumbersType type) {
        this.minNumber = minNumber;
        this.maxNumber = maxNumber;
        this.type = type;
        this.validateCompleteOnAdd = true;
    }

    protected void checkBound(int number) {
        if (number < this.minNumber || number > this.maxNumber) {
            throw new IllegalArgumentException("number out of bound");
        }
    }

    public BetNumbersType getType() {
        return this.type;
    }

    public BetNumbersBuilder setValidateCompleteOnAdd(boolean value) {
        this.validateCompleteOnAdd = value;
        return this;
    }

    public abstract BetNumbersBuilder addNumber(int var1);

    public abstract IntObjectPair<BetNumbersBuilder> addRandomNumber();

    public abstract BetNumbersBuilder removeNumber(int var1);

    public int bankerSize() {
        return 0;
    }

    public abstract int size();

    public abstract boolean contains(int var1);

    public abstract boolean canAdd();

    public int setsSize() {
        return 1;
    }

    public abstract boolean completed();

    public abstract BetNumbers build();

    public static class SingleBuilder
    extends BetNumbersBuilder {
        private final int max;
        private final List<Integer> numbers;

        private SingleBuilder(int minNumber, int maxNumber) {
            super(minNumber, maxNumber, BetNumbersType.SINGLE);
            this.max = 6;
            this.numbers = new ArrayList<Integer>(this.max);
        }

        @Override
        public synchronized SingleBuilder addNumber(int number) {
            this.checkBound(number);
            if (this.validateCompleteOnAdd && this.completed()) {
                throw new IllegalStateException("Lottery Number builder already completed!");
            }
            this.numbers.add(number);
            return this;
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            if (this.validateCompleteOnAdd && this.completed()) {
                throw new IllegalStateException("Lottery Number builder already completed!");
            }
            if (this.numbers.size() > this.maxNumber - this.minNumber) {
                throw new IllegalStateException("Cannot add more random numbers!");
            }
            int number = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).filter(i -> !this.numbers.contains(i)).findFirst().orElseThrow(() -> new RuntimeException());
            this.numbers.add(number);
            return IntObjectPair.of(number, this);
        }

        @Override
        public synchronized SingleBuilder removeNumber(int number) {
            this.numbers.remove((Object)number);
            return this;
        }

        @Override
        public int size() {
            return this.numbers.size();
        }

        @Override
        public boolean contains(int i) {
            return this.numbers.contains(i);
        }

        @Override
        public boolean completed() {
            return this.numbers.size() >= this.max;
        }

        @Override
        public boolean canAdd() {
            return !this.completed();
        }

        @Override
        public BetNumbers build() {
            if (!this.completed()) {
                throw new IllegalStateException("Lottery Number builder not yet completed!");
            }
            return new BetNumbers((Collection<Integer>)this.numbers, BetNumbersType.SINGLE);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.numbers.iterator();
        }
    }

    public static class MultipleBuilder
    extends BetNumbersBuilder {
        private final int min;
        private final List<Integer> numbers = new ArrayList<Integer>();

        private MultipleBuilder(int minNumber, int maxNumber) {
            super(minNumber, maxNumber, BetNumbersType.MULTIPLE);
            this.min = 7;
        }

        @Override
        public synchronized MultipleBuilder addNumber(int number) {
            this.checkBound(number);
            this.numbers.add(number);
            return this;
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            if (this.numbers.size() > this.maxNumber - this.minNumber) {
                throw new IllegalStateException("Cannot add more random numbers!");
            }
            int number = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).filter(i -> !this.numbers.contains(i)).findFirst().orElseThrow(() -> new RuntimeException());
            this.numbers.add(number);
            return IntObjectPair.of(number, this);
        }

        @Override
        public synchronized MultipleBuilder removeNumber(int number) {
            this.numbers.remove((Object)number);
            return this;
        }

        @Override
        public boolean canAdd() {
            return this.size() < this.maxNumber - this.minNumber + 1;
        }

        @Override
        public int size() {
            return this.numbers.size();
        }

        @Override
        public boolean contains(int i) {
            return this.numbers.contains(i);
        }

        @Override
        public boolean completed() {
            return this.numbers.size() >= this.min;
        }

        @Override
        public BetNumbers build() {
            if (!this.completed()) {
                throw new IllegalStateException("Lottery Number builder not yet completed!");
            }
            return new BetNumbers((Collection<Integer>)this.numbers, BetNumbersType.MULTIPLE);
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.numbers.iterator();
        }
    }

    public static class BankerBuilder
    extends BetNumbersBuilder {
        private final int maxBankers;
        private final List<Integer> bankers = new ArrayList<Integer>();
        private final List<Integer> selections = new ArrayList<Integer>();
        private boolean bankersComplete = false;

        private BankerBuilder(int minNumber, int maxNumber) {
            super(minNumber, maxNumber, BetNumbersType.BANKER);
            this.maxBankers = 5;
        }

        @Override
        public synchronized BankerBuilder addNumber(int number) {
            this.checkBound(number);
            if (this.bankersComplete) {
                if (!this.bankers.contains(number)) {
                    this.selections.add(number);
                }
            } else {
                if (this.validateCompleteOnAdd && this.bankerCompleted()) {
                    throw new IllegalStateException("Max numbers of bankers reached!");
                }
                this.bankers.add(number);
            }
            return this;
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            if (this.bankers.size() + this.selections.size() > this.maxNumber - this.minNumber) {
                throw new IllegalStateException("Cannot add more random numbers!");
            }
            int number = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).filter(i -> !this.contains(i)).findFirst().orElseThrow(() -> new RuntimeException());
            if (this.bankersComplete) {
                if (!this.bankers.contains(number)) {
                    this.selections.add(number);
                }
            } else {
                if (this.validateCompleteOnAdd && this.bankerCompleted()) {
                    throw new IllegalStateException("Max numbers of bankers reached!");
                }
                this.bankers.add(number);
            }
            return IntObjectPair.of(number, this);
        }

        @Override
        public synchronized BankerBuilder removeNumber(int number) {
            if (this.bankersComplete) {
                this.selections.remove((Object)number);
            } else {
                this.bankers.remove((Object)number);
            }
            return this;
        }

        @Override
        public int size() {
            return this.selections.size();
        }

        @Override
        public int bankerSize() {
            return this.bankers.size();
        }

        @Override
        public boolean canAdd() {
            return this.bankerSize() + this.size() < this.maxNumber - this.minNumber + 1;
        }

        public synchronized BankerBuilder finishBankers() {
            if (this.bankers.isEmpty()) {
                throw new IllegalStateException("At least one banker number must be chosen");
            }
            this.bankersComplete = true;
            return this;
        }

        public int getMinSelectionsNeeded() {
            return Math.max(1, 6 - this.bankers.size());
        }

        public List<Integer> getBankers() {
            return Collections.unmodifiableList(this.bankers);
        }

        public boolean inSelectionPhase() {
            return this.bankersComplete;
        }

        public boolean selectionContains(int i) {
            return this.selections.contains(i);
        }

        public boolean bankerContains(int i) {
            return this.bankers.contains(i);
        }

        @Override
        public boolean contains(int i) {
            return this.selectionContains(i) || this.bankerContains(i);
        }

        public boolean bankerCompleted() {
            return this.bankersComplete || this.bankers.size() >= this.maxBankers;
        }

        @Override
        public boolean completed() {
            return this.bankers.size() + this.selections.size() > 6;
        }

        @Override
        public BetNumbers build() {
            if (!this.completed()) {
                throw new IllegalStateException("Lottery Number builder not yet completed!");
            }
            return new BetNumbers(this.bankers, this.selections, BetNumbersType.BANKER);
        }

        @Override
        public Iterator<Integer> iterator() {
            return Stream.concat(this.bankers.stream(), this.selections.stream()).iterator();
        }
    }

    public static class RandomBuilder
    extends BetNumbersBuilder {
        private final int count;

        private RandomBuilder(int minNumber, int maxNumber) {
            this(minNumber, maxNumber, 1);
        }

        private RandomBuilder(int minNumber, int maxNumber, int count) {
            super(minNumber, maxNumber, BetNumbersType.RANDOM);
            this.count = count;
        }

        @Override
        public synchronized RandomBuilder addNumber(int number) {
            throw new UnsupportedOperationException("Cannot add number in random builder");
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            throw new UnsupportedOperationException("Cannot add number in random builder");
        }

        @Override
        public synchronized RandomBuilder removeNumber(int number) {
            throw new UnsupportedOperationException("Cannot remove number in random builder");
        }

        @Override
        public int size() {
            return 6;
        }

        @Override
        public boolean canAdd() {
            return false;
        }

        @Override
        public boolean contains(int i) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public int setsSize() {
            return this.count;
        }

        @Override
        public boolean completed() {
            return true;
        }

        @Override
        public BetNumbers build() {
            List<Collection<Integer>> numbers = IntStream.range(0, this.count).mapToObj(i -> ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).distinct().limit(6L).boxed().collect(Collectors.toList())).collect(Collectors.toList());
            return new BetNumbers(numbers, BetNumbersType.RANDOM);
        }

        @Override
        public Iterator<Integer> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class MultipleRandomBuilder
    extends BetNumbersBuilder {
        private final int size;

        private MultipleRandomBuilder(int minNumber, int maxNumber, int size) {
            super(minNumber, maxNumber, BetNumbersType.MULTIPLE_RANDOM);
            if (maxNumber + 1 - minNumber < size) {
                throw new IllegalArgumentException("not enough numbers to satisfy size");
            }
            this.size = size;
        }

        @Override
        public synchronized MultipleBuilder addNumber(int number) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public synchronized MultipleBuilder removeNumber(int number) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public boolean canAdd() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean contains(int i) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public boolean completed() {
            return true;
        }

        @Override
        public BetNumbers build() {
            List<Integer> numbers = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).distinct().limit(this.size).boxed().collect(Collectors.toList());
            return new BetNumbers((Collection<Integer>)numbers, BetNumbersType.MULTIPLE_RANDOM);
        }

        @Override
        public Iterator<Integer> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class BankerRandomBuilder
    extends BetNumbersBuilder {
        private final int bankersSize;
        private final int selectionSize;

        private BankerRandomBuilder(int minNumber, int maxNumber, int bankersSize, int selectionSize) {
            super(minNumber, maxNumber, BetNumbersType.BANKER_RANDOM);
            if (maxNumber + 1 - minNumber < bankersSize + selectionSize) {
                throw new IllegalArgumentException("not enough numbers to satisfy size");
            }
            this.bankersSize = bankersSize;
            this.selectionSize = selectionSize;
        }

        @Override
        public synchronized BankerBuilder addNumber(int number) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public IntObjectPair<BetNumbersBuilder> addRandomNumber() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public synchronized BankerBuilder removeNumber(int number) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public int size() {
            return this.selectionSize;
        }

        @Override
        public int bankerSize() {
            return this.bankersSize;
        }

        @Override
        public boolean canAdd() {
            return false;
        }

        public synchronized BankerBuilder finishBankers() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        public int getMinSelectionsNeeded() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        public List<Integer> getBankers() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        public boolean inSelectionPhase() {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        @Override
        public boolean contains(int i) {
            throw new UnsupportedOperationException("Cannot check contained numbers in random builder");
        }

        public boolean bankerCompleted() {
            return true;
        }

        @Override
        public boolean completed() {
            return true;
        }

        @Override
        public BetNumbers build() {
            List<Integer> bankers = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).distinct().limit(this.bankersSize).boxed().collect(Collectors.toList());
            List<Integer> selections = ThreadLocalRandom.current().ints(this.minNumber, this.maxNumber + 1).distinct().filter(i -> !bankers.contains(i)).limit(this.selectionSize).boxed().collect(Collectors.toList());
            return new BetNumbers(bankers, selections, BetNumbersType.BANKER_RANDOM);
        }

        @Override
        public Iterator<Integer> iterator() {
            return Collections.emptyIterator();
        }
    }
}

