/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects.betnumbers;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class IntObjectPair<S> {
    private final int first;
    private final S second;

    public static <S> IntObjectPair<S> of(int first, S second) {
        return new IntObjectPair<S>(first, second);
    }

    private IntObjectPair(int first, S second) {
        this.first = first;
        this.second = second;
    }

    public int getFirstInt() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public <T> T product(BiFunction<Integer, S, T> function) {
        return function.apply(this.first, this.second);
    }

    public void consume(BiConsumer<Integer, S> consumer) {
        consumer.accept(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntObjectPair that = (IntObjectPair)o;
        return this.first == that.first && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }
}

