/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.resolver;

import com.loohp.lotterysix.libs.xyz.tozymc.reflect.resolver.wrapper.ClassWrapper;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ClassResolver {
    private final Map<String, Class<?>> resolvedClasses = new HashMap();

    protected ClassResolver() {
    }

    @Contract(pure=true)
    @NotNull
    public static ClassResolver resolver() {
        return ClassResolverHelper.INSTANCE;
    }

    public <T> ClassWrapper<T> resolveWrapper(@NotNull String name) {
        Preconditions.checkNotNull(name, "Name cannot be null");
        return new ClassWrapper<T>(this.resolve(name));
    }

    public ClassWrapper<?> resolveWrapper(String ... names) {
        Preconditions.checkNotNull(names, "Names cannot be null");
        return new ClassWrapper(this.resolve(names));
    }

    public Class<?> resolve(String ... names) {
        Preconditions.checkNotNull(names, "Names cannot be null");
        Class clazz = null;
        for (String name : names) {
            try {
                clazz = this.resolve(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) continue;
            return clazz;
        }
        throw new RuntimeException("Cannot resolve classes " + Arrays.toString(names));
    }

    public <T> Class<T> resolve(@NotNull String name) {
        Preconditions.checkNotNull(name, "Name cannot be null");
        if (this.resolvedClasses.containsKey(name)) {
            return this.resolvedClasses.get(name);
        }
        try {
            Class<?> clazz = Class.forName(name);
            this.resolvedClasses.put(name, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot resolve class " + name);
        }
    }

    private static class ClassResolverHelper {
        private static final ClassResolver INSTANCE = new ClassResolver();

        private ClassResolverHelper() {
        }
    }
}

