/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.util;

import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.NotFoundMessages;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fields {
    private Fields() {
    }

    public static Field getField(@NotNull Class<?> clazz, @NotNull String name) {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        return Fields.getField0(clazz, name);
    }

    public static Field getField(@NotNull Object instance, @NotNull String name) {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        return Fields.getField0(instance.getClass(), name);
    }

    public static Object readField(@NotNull Class<?> clazz, @Nullable Object instance, @NotNull String name) throws IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Field field = Fields.getField0(clazz, name);
        return Preconditions.checkNotNull(field, NotFoundMessages.fieldNotFound(name)).get(instance);
    }

    public static Object readField(@NotNull Object instance, @NotNull String name) throws IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Field field = Fields.getField0(instance.getClass(), name);
        return Preconditions.checkNotNull(field, NotFoundMessages.fieldNotFound(name)).get(instance);
    }

    public static void writeField(@NotNull Class<?> clazz, @Nullable Object instance, @NotNull String name, @Nullable Object value) throws IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Field field = Fields.getField0(clazz, name);
        Preconditions.checkNotNull(field, NotFoundMessages.fieldNotFound(name)).set(instance, value);
    }

    public static void writeField(@NotNull Object instance, @NotNull String name, @Nullable Object value) throws IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Field field = Fields.getField0(instance.getClass(), name);
        Preconditions.checkNotNull(field, NotFoundMessages.fieldNotFound(name)).set(instance, value);
    }

    private static Field getField0(Class<?> clazz, String name) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getName().equals(name)).findFirst().orElse(null);
    }
}

