/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title;

import com.loohp.lotterysix.libs.xyz.tozymc.minecraft.MinecraftVersion;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.Title;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.actionbar.NmsTitleActionbarApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.actionbar.SpigotTitleActionbarApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.actionbar.TitleActionbarApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.title.BackendTitleApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.title.NmsTitleApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.backend.title.SpigotTitleApi;
import com.loohp.lotterysix.libs.xyz.tozymc.spigot.api.title.util.Ticks;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TitleApi {
    private final BackendTitleApi titleApi;
    private final TitleActionbarApi titleActionbarApi;

    private TitleApi() {
        MinecraftVersion version = MinecraftVersion.getVersion();
        this.titleApi = version.isOlderThan(MinecraftVersion.v1_11_R1) ? new NmsTitleApi() : new SpigotTitleApi();
        this.titleActionbarApi = version.isOlderThan(MinecraftVersion.v1_9_R1) ? new NmsTitleActionbarApi() : new SpigotTitleActionbarApi();
    }

    private static TitleApi getInstance() {
        return TitleApiHelper.INSTANCE;
    }

    public static void sendTitle(@NotNull Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Preconditions.checkNotNull(player, "Player cannot be null");
        TitleApi.getInstance().sendTitle0(player, title, subtitle, fadeIn, stay, fadeOut, null);
    }

    public static void sendTitle(@NotNull Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut, TimeUnit timeUnit) {
        Preconditions.checkNotNull(player, "Player cannot be null");
        TitleApi.getInstance().sendTitle0(player, title, subtitle, fadeIn, stay, fadeOut, timeUnit);
    }

    public static void sendTitle(@NotNull Player player, @NotNull Title title) {
        Preconditions.checkNotNull(player, "Player cannot be null");
        Preconditions.checkNotNull(title, "Title cannot be null");
        TitleApi.getInstance().sendTitle0(player, title.getTitle(), title.getSubtitle(), title.getFadeIn(), title.getStay(), title.getFadeOut(), title.getTimeUnit());
    }

    public static void sendActionbar(@NotNull Player player, String message) {
        Preconditions.checkNotNull(player, "Player cannot be null");
        TitleApi.getInstance().titleActionbarApi.sendActionbar(player, message);
    }

    private void sendTitle0(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut, TimeUnit timeUnit) {
        fadeIn = Ticks.convertToTick(fadeIn, timeUnit);
        stay = Ticks.convertToTick(stay, timeUnit);
        fadeOut = Ticks.convertToTick(fadeOut, timeUnit);
        this.titleApi.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut);
    }

    private static final class TitleApiHelper {
        private static final TitleApi INSTANCE = new TitleApi();

        private TitleApiHelper() {
        }
    }
}

