/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.bungee;

import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.PlayerWinnings;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.proxy.bungee.LotterySixBungee;
import com.loohp.lotterysix.utils.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class DebugBungee
implements Listener {
    @EventHandler
    public void onSwitch(ServerSwitchEvent event) {
        ProxyServer.getInstance().getScheduler().schedule((Plugin)LotterySixBungee.plugin, () -> {
            if (event.getPlayer().getName().equals("LOOHP") || event.getPlayer().getName().equals("AppLEshakE")) {
                event.getPlayer().sendMessage(ChatColor.RED + "LotterySix (Bungeecord) " + LotterySixBungee.plugin.getDescription().getVersion() + " is running!");
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    public static void debugLotteryPlayer(CommandSender sender, String name, UUID uuid, int maxPastGames) {
        int i;
        sender.sendMessage(ChatColor.AQUA + "LotterySix Player Info ----");
        sender.sendMessage(ChatColor.YELLOW + "Name: " + name);
        sender.sendMessage(ChatColor.YELLOW + "UUID: " + uuid);
        sender.sendMessage("");
        long limit = LotterySixBungee.getInstance().getPlayerBetLimit(uuid);
        sender.sendMessage(ChatColor.GREEN + "Bet Limit By Permission: " + (limit <= 0L ? "Unlimited" : Long.valueOf(limit)));
        sender.sendMessage("");
        LotteryPlayer lotteryPlayer = LotterySixBungee.getInstance().getLotteryPlayerManager().getLotteryPlayer(uuid);
        sender.sendMessage(ChatColor.AQUA + "Preferences ----");
        for (PlayerPreferenceKey playerPreferenceKey : PlayerPreferenceKey.values()) {
            sender.sendMessage(ChatColor.GREEN + playerPreferenceKey.name() + ": " + lotteryPlayer.getPreference(playerPreferenceKey, playerPreferenceKey.getValueTypeClass()));
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.AQUA + "Stats ----");
        for (Enum enum_ : PlayerStatsKey.values()) {
            sender.sendMessage(ChatColor.GREEN + enum_.name() + ": " + lotteryPlayer.getStats((PlayerStatsKey)enum_, ((PlayerStatsKey)enum_).getValueTypeClass()));
        }
        sender.sendMessage("");
        PlayableLotterySixGame currentGame = LotterySixBungee.getInstance().getCurrentGame();
        sender.sendMessage(ChatColor.AQUA + "Current Round ----");
        if (currentGame == null) {
            sender.sendMessage(ChatColor.RED + "There are no active current round");
        } else {
            sender.sendMessage(ChatColor.YELLOW + "Game ID: " + currentGame.getGameId());
            sender.sendMessage(ChatColor.YELLOW + "Game Number: " + currentGame.getGameNumber());
            sender.sendMessage(ChatColor.YELLOW + "Date: " + LotterySixBungee.getInstance().dateFormat.format(new Date(currentGame.getDatetime())));
            List<PlayerBets> bets = currentGame.getPlayerBets(uuid);
            sender.sendMessage(ChatColor.GREEN + "Total Bet Placed By Player: $" + StringUtils.formatComma(bets.stream().mapToLong(each -> each.getBet()).sum()));
            sender.sendMessage("");
            for (i = 0; i < bets.size(); ++i) {
                PlayerBets playerBets = bets.get(i);
                sender.sendMessage(i + 1 + ". " + playerBets.getChosenNumbers().toFormattedString());
                sender.sendMessage("    " + ChatColor.GOLD + "Bet ID: " + playerBets.getBetId());
                sender.sendMessage("    " + ChatColor.GOLD + "Type: " + playerBets.getChosenNumbers().getType().name());
                sender.sendMessage("    " + ChatColor.GOLD + "Price: $" + StringUtils.formatComma(playerBets.getBet()));
                if (playerBets.isMultipleDraw()) {
                    sender.sendMessage("    " + ChatColor.BLUE + "Multiple Draws: " + playerBets.getDrawsRemaining() + "/" + playerBets.getMultipleDraw());
                }
                sender.sendMessage("");
            }
        }
        if (maxPastGames > 0) {
            sender.sendMessage("");
            sender.sendMessage(ChatColor.AQUA + "Past Rounds ----");
            LazyCompletedLotterySixGameList pastGames = LotterySixBungee.getInstance().getCompletedGames();
            if (pastGames.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "There are no past games");
            } else {
                for (i = 0; i < Math.min(pastGames.size(), maxPastGames); ++i) {
                    CompletedLotterySixGame completedLotterySixGame = (CompletedLotterySixGame)pastGames.get(i);
                    sender.sendMessage(ChatColor.YELLOW + "Game ID: " + completedLotterySixGame.getGameId());
                    sender.sendMessage(ChatColor.YELLOW + "Game Number: " + completedLotterySixGame.getGameNumber());
                    sender.sendMessage(ChatColor.YELLOW + "Date: " + LotterySixBungee.getInstance().dateFormat.format(new Date(completedLotterySixGame.getDatetime())));
                    sender.sendMessage(ChatColor.YELLOW + "Result: " + completedLotterySixGame.getDrawResult().toFormattedString());
                    sender.sendMessage("");
                    List<PlayerWinnings> winningsList = completedLotterySixGame.getSortedPlayerWinnings(uuid);
                    int u = 1;
                    for (PlayerWinnings winnings : winningsList.subList(0, Math.min(50, winningsList.size()))) {
                        sender.sendMessage(u++ + ". " + winnings.getWinningBet(completedLotterySixGame).getChosenNumbers().toFormattedString());
                        if (winnings.isCombination(completedLotterySixGame)) {
                            sender.sendMessage("    (" + winnings.getWinningCombination().toFormattedString() + ")");
                        }
                        sender.sendMessage("    " + ChatColor.GOLD + winnings.getTier().getShortHand() + " $" + StringUtils.formatComma(winnings.getWinnings()));
                        sender.sendMessage("    " + ChatColor.GOLD + "Bet ID: " + winnings.getWinningBetId());
                        sender.sendMessage("    " + ChatColor.GOLD + "Type: " + winnings.getWinningBet(completedLotterySixGame).getChosenNumbers().getType().name());
                        sender.sendMessage("    " + ChatColor.GOLD + "Price: $" + StringUtils.formatComma(winnings.getWinningBet(completedLotterySixGame).getBet()));
                        if (winnings.getWinningBet(completedLotterySixGame).isMultipleDraw()) {
                            sender.sendMessage("    " + ChatColor.BLUE + "Multiple Draws: " + winnings.getWinningBet(completedLotterySixGame).getDrawsRemaining() + "/" + winnings.getWinningBet(completedLotterySixGame).getMultipleDraw());
                        }
                        sender.sendMessage("");
                    }
                    for (PlayerBets bet : completedLotterySixGame.getPlayerBets(uuid)) {
                        if (!winningsList.stream().noneMatch(each -> each.getWinningBet(game).getBetId().equals(bet.getBetId()))) continue;
                        sender.sendMessage(u++ + ". " + bet.getChosenNumbers().toFormattedString());
                        sender.sendMessage("    " + ChatColor.GOLD + "No Winnings $0");
                        sender.sendMessage("    " + ChatColor.GOLD + "Bet ID: " + bet.getBetId());
                        sender.sendMessage("    " + ChatColor.GOLD + "Type: " + bet.getChosenNumbers().getType().name());
                        sender.sendMessage("    " + ChatColor.GOLD + "Price: $" + StringUtils.formatComma(bet.getBet()));
                        if (bet.isMultipleDraw()) {
                            sender.sendMessage("    " + ChatColor.BLUE + "Multiple Draws: " + bet.getDrawsRemaining() + "/" + bet.getMultipleDraw());
                        }
                        sender.sendMessage("");
                    }
                }
            }
        }
    }
}

