/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Events;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Contract;

public class RegionsChangedEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final UUID uuid;
    private final Set<ProtectedRegion> previousRegions = new HashSet<ProtectedRegion>();
    private final Set<ProtectedRegion> currentRegions = new HashSet<ProtectedRegion>();
    private final Set<String> previousRegionsNames = new HashSet<String>();
    private final Set<String> currentRegionsNames = new HashSet<String>();

    public RegionsChangedEvent(UUID playerUUID, Set<ProtectedRegion> previous, Set<ProtectedRegion> current) {
        this.uuid = playerUUID;
        this.previousRegions.addAll(previous);
        this.currentRegions.addAll(current);
        for (ProtectedRegion r : current) {
            this.currentRegionsNames.add(r.getId());
        }
        for (ProtectedRegion r : previous) {
            this.previousRegionsNames.add(r.getId());
        }
    }

    @Contract(pure=true)
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public Set<String> getCurrentRegionsNames() {
        return this.currentRegionsNames;
    }

    public Set<String> getPreviousRegionsNames() {
        return this.previousRegionsNames;
    }

    public Set<ProtectedRegion> getCurrentRegions() {
        return this.currentRegions;
    }

    public Set<ProtectedRegion> getPreviousRegions() {
        return this.previousRegions;
    }
}

