/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Listeners;

import com.loohp.nar.NarMapPlugin;
import com.loohp.nar.Utils.BoundingBoxUtils;
import com.loohp.nar.Utils.ChatUtils;
import com.loohp.nar.Utils.ClipboardUtils;
import com.loohp.nar.Utils.NBTUtils;
import com.loohp.nar.Utils.WaitUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Events
implements Listener {
    public static Map<UUID, Block> beforeJump = new HashMap<UUID, Block>();
    public static Set<UUID> inTerminal = new HashSet<UUID>();
    public static BoundingBox areaTerminal = BoundingBox.of((Location)new Location(NarMapPlugin.plugin.mainWorld, -740.0, 255.0, -967.0), (Location)new Location(NarMapPlugin.plugin.mainWorld, -1067.0, -70.0, -1032.0));
    public static BoundingBox naBuildingTerminal = BoundingBox.of((Location)new Location(NarMapPlugin.plugin.mainWorld, -1002.0, 80.0, -1014.0), (Location)new Location(NarMapPlugin.plugin.mainWorld, -994.0, 67.0, -1008.0));
    public static Location cloudLever = new Location(NarMapPlugin.plugin.mainWorld, 68.0, 75.0, -128.0);
    public static Block spawnBlock = NarMapPlugin.plugin.mainWorld.getBlockAt(-4, 9, 17);
    public static Map<UUID, ThrownItemData> thrownItems = new HashMap<UUID, ThrownItemData>();
    public static Map<Block, Consumer<Player>> buttons = null;
    private int sleepTask = -1;

    @EventHandler
    public void onSLP(ServerListPingEvent event) {
        if (!NarMapPlugin.plugin.disableCustomSLP) {
            event.setMotd(ChatColor.YELLOW + "Nana\u7684\u65c5\u7a0b");
        }
    }

    @EventHandler
    public void onResoucePackStatus(PlayerResourcePackStatusEvent event) {
        Player player = event.getPlayer();
        if (event.getStatus().equals((Object)PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED)) {
            Location location = player.getLocation().clone();
            player.teleport(new Location(player.getWorld(), 0.0, 1000.0, 0.0));
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> player.teleport(location), 2L);
        } else if (event.getStatus().equals((Object)PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD)) {
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> NarMapPlugin.sendResourcePack(player), 2L);
        }
    }

    @EventHandler
    public void onBlockFall(EntityChangeBlockEvent event) {
        Block block = event.getBlock();
        World world = NarMapPlugin.plugin.mainWorld;
        Location location = block.getLocation();
        if (block.getWorld().equals(world) && naBuildingTerminal.contains(location.toVector()) && event.getEntityType().equals((Object)EntityType.FALLING_BLOCK) && event.getTo().equals((Object)Material.AIR)) {
            event.setCancelled(true);
            block.getState().update(false, false);
            return;
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (NarMapPlugin.plugin.disableDamage && NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(event.getEntity())) {
            event.setDamage(0.0);
        }
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item item = event.getEntity();
        if (item.getScoreboardTags().contains("item_collection")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onThrowItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.ADVENTURE) || player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            UUID key = UUID.randomUUID();
            ItemStack itemstack = event.getItemDrop().getItemStack().clone();
            thrownItems.put(key, new ThrownItemData(event.getItemDrop(), itemstack));
            TextComponent message = new TextComponent(ChatColor.AQUA + "[\u9ede\u64ca\u53d6\u56de\u6389\u843d\u7269\u54c1]");
            BaseComponent[] hoverEventComponents = new BaseComponent[]{new TextComponent(NBTUtils.getNBTCompound(itemstack, new Object[0]).toString())};
            message.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, hoverEventComponents));
            message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/nar retrieveitem " + key));
            player.spigot().sendMessage((BaseComponent)message);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDamageByEntityEvent event) {
        Player player;
        ArmorStand armorstand;
        Projectile projectile;
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() != null && projectile.getShooter() instanceof Player) {
            damager = (Entity)projectile.getShooter();
        }
        if (event.getEntity() instanceof ArmorStand && (armorstand = (ArmorStand)event.getEntity()).isInvulnerable() && damager instanceof Player && (player = (Player)damager).getGameMode().equals((Object)GameMode.CREATIVE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void itemFrameProtection(HangingBreakEvent event) {
        if (!event.getCause().equals((Object)HangingBreakEvent.RemoveCause.DEFAULT)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onConsume(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        if (item != null && item.getType().equals((Object)Material.MILK_BUCKET) && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().contains("\u73cd\u73e0\u5976\u8336")) {
            if (!NarMapPlugin.plugin.advan.checkAchievement(player, "bubble_tea")) {
                NarMapPlugin.plugin.advan.sendAchievement(player, "bubble_tea");
            }
            if (player.getGameMode().equals((Object)GameMode.ADVENTURE) || player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
                Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> {
                    if (player.getEquipment().getItemInMainHand().getType().equals((Object)Material.BUCKET)) {
                        player.getInventory().setItem(player.getInventory().getHeldItemSlot(), null);
                    } else if (player.getEquipment().getItemInOffHand().getType().equals((Object)Material.BUCKET)) {
                        player.getInventory().setItem(40, null);
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        if (!NarMapPlugin.WAIT_SWITCH.get()) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, "Please Wait!");
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getName().equalsIgnoreCase(NarMapPlugin.plugin.getConfig().getString("MainCharacter"))) {
            NarMapPlugin.plugin.mainCharater = Optional.of(player);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> NarMapPlugin.sendResourcePack(player), 10L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(player)) {
            NarMapPlugin.plugin.mainCharater = Optional.empty();
        }
        if (!player.hasPlayedBefore()) {
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> player.teleport(NarMapPlugin.plugin.menuSpawn), 10L);
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (player.getBoundingBox().overlaps(areaTerminal)) {
            if (!inTerminal.contains(player.getUniqueId())) {
                inTerminal.add(player.getUniqueId());
                player.setPlayerTime(18000L, false);
            }
        } else if (inTerminal.remove(player.getUniqueId())) {
            player.resetPlayerTime();
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Block standing = event.getFrom().clone().add(0.0, -0.1, 0.0).getBlock();
        if (standing.getBoundingBox().getWidthX() == 1.0 && standing.getBoundingBox().getWidthZ() == 1.0 && standing.getBoundingBox().getHeight() > 0.0) {
            beforeJump.put(player.getUniqueId(), standing);
        }
        if (event.getTo().getY() < -60.0) {
            String message;
            Block block = beforeJump.get(player.getUniqueId());
            if (block == null) {
                block = spawnBlock;
            }
            player.setFallDistance(0.0f);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 999999, 10));
            int ran = ThreadLocalRandom.current().nextInt(10);
            if (ran == 1) {
                message = player.getName() + " was The Imposter.";
                NarMapPlugin.plugin.advan.sendAchievement(player, "imposter");
            } else {
                message = player.getName() + " was not The Imposter.";
            }
            CompletableFuture<Void> future = ChatUtils.sendLetterByLetterTitle(player, "", message, 2, 20, 15, "minecraft:narmap.sfx.beep");
            BoundingBox box = block.getBoundingBox();
            Location loc = box.getCenter().toLocation(block.getWorld()).add(0.0, box.getHeight() / 2.0, 0.0);
            loc.setYaw(player.getLocation().getYaw());
            loc.setPitch(player.getLocation().getPitch());
            player.teleport(loc);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)NarMapPlugin.plugin, () -> {
                try {
                    future.get();
                    WaitUtils.waitTicks(25);
                    Bukkit.getScheduler().runTask((Plugin)NarMapPlugin.plugin, () -> player.removePotionEffect(PotionEffectType.SLOW));
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            });
        }
        if (player.getBoundingBox().overlaps(areaTerminal)) {
            if (!inTerminal.contains(player.getUniqueId())) {
                inTerminal.add(player.getUniqueId());
                player.setPlayerTime(18000L, false);
            }
        } else if (inTerminal.remove(player.getUniqueId())) {
            player.resetPlayerTime();
        }
        if (NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(event.getPlayer())) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (NarMapPlugin.plugin.disableMovement && (from.getX() != to.getX() || from.getY() < to.getY() || from.getZ() != to.getZ())) {
                event.setCancelled(true);
                return;
            }
            if (NarMapPlugin.plugin.disableRotation && (from.getYaw() != to.getYaw() || from.getPitch() != to.getPitch())) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public static void loadButtons() {
        World world = NarMapPlugin.plugin.mainWorld;
        buttons = new HashMap<Block, Consumer<Player>>();
        buttons.put(new Location(world, -921.0, 69.0, -1001.0).getBlock(), player -> {});
        buttons.put(new Location(world, -921.0, 69.0, -999.0).getBlock(), player -> {});
        buttons.put(new Location(world, -934.0, 69.0, -1001.0).getBlock(), player -> {});
        buttons.put(new Location(world, -934.0, 69.0, -999.0).getBlock(), player -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> {
                player.teleport(new Location(world, 4187.5, 24.0, 14181.5, 90.0f, 0.0f));
                if (NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(player)) {
                    NarMapPlugin.plugin.advan.sendProgression((Player)player, "nana_classroom");
                }
            }, 20L);
        });
        buttons.put(new Location(world, -947.0, 69.0, -1001.0).getBlock(), player -> {});
        buttons.put(new Location(world, -947.0, 69.0, -999.0).getBlock(), player -> {});
        buttons.put(new Location(world, -960.0, 69.0, -1001.0).getBlock(), player -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> {
                player.teleport(new Location(world, -2006.0, 64.0, -1998.0, 176.0f, 0.0f));
                if (NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(player)) {
                    NarMapPlugin.plugin.advan.sendProgression((Player)player, "nana_oldbase");
                }
            }, 20L);
        });
        buttons.put(new Location(world, -960.0, 69.0, -999.0).getBlock(), player -> {});
        buttons.put(new Location(world, -973.0, 69.0, -1001.0).getBlock(), player -> {
            ItemStack item = NarMapPlugin.plugin.specialitems.get("sk_sword");
            Item entity = player.getWorld().dropItem(player.getEyeLocation(), item);
            entity.setVelocity(new Vector(0, 0, 0));
        });
        buttons.put(new Location(world, -973.0, 69.0, -999.0).getBlock(), player -> {});
        buttons.put(new Location(world, -986.0, 69.0, -1001.0).getBlock(), player -> {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0));
            Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> {
                player.teleport(new Location(world, 2957.0, 63.0, 1240.5, -90.0f, 0.0f));
                if (NarMapPlugin.plugin.mainCharater.isPresent() && NarMapPlugin.plugin.mainCharater.get().equals(player)) {
                    NarMapPlugin.plugin.advan.sendProgression((Player)player, "nana_mushroom");
                }
            }, 20L);
        });
        buttons.put(new Location(world, -986.0, 69.0, -999.0).getBlock(), player -> {
            Block button = new Location(world, -986.0, 69.0, -999.0).getBlock();
            Consumer<Player> code = buttons.remove(button);
            Block top = button.getRelative(BlockFace.UP);
            Location o = top.getLocation();
            Directional directional = (Directional)button.getBlockData();
            Block block = button.getRelative(directional.getFacing().getOppositeFace());
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)NarMapPlugin.plugin, () -> {
                try {
                    List<Location> blockLoc = BoundingBoxUtils.getHollowCube(world, block.getBoundingBox().expand(0.0625), 0.1);
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    BoundingBox box = ClipboardUtils.getBuildingRegion("assignmentsigns", o).expand(1.0);
                    int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
                        for (Location loc : blockLoc) {
                            if (random.nextInt(100) >= 5) continue;
                            world.spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(Color.fromRGB((int)(random.nextInt(128) + 128), (int)(random.nextInt(128) + 128), (int)0), 1.0f));
                        }
                        for (Location loc : BoundingBoxUtils.getRandomLocation(world, box, random, 10)) {
                            world.spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(Color.fromRGB((int)(random.nextInt(128) + 128), (int)(random.nextInt(128) + 128), (int)0), 1.0f));
                        }
                    }, 0L, 5L).getTaskId();
                    TimeUnit.SECONDS.sleep(1L);
                    ClipboardUtils.placeBuilding("assignmentsigns", o, true);
                    TimeUnit.SECONDS.sleep(10L);
                    Bukkit.getScheduler().cancelTask(taskId);
                    ClipboardUtils.clearBuilding("assignmentsigns", o);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                buttons.put(button, code);
            });
        });
        buttons.put(new Location(world, -999.0, 69.0, -1001.0).getBlock(), player -> {
            Block button = new Location(world, -999.0, 69.0, -1001.0).getBlock();
            Consumer<Player> code = buttons.remove(button);
            Block top = button.getRelative(BlockFace.UP);
            Location o = top.getLocation();
            Directional directional = (Directional)button.getBlockData();
            Block block = button.getRelative(directional.getFacing().getOppositeFace());
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)NarMapPlugin.plugin, () -> {
                try {
                    int i;
                    List<Location> blockLoc = BoundingBoxUtils.getHollowCube(world, block.getBoundingBox().expand(0.0625), 0.1);
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
                        for (Location loc : blockLoc) {
                            if (random.nextInt(100) >= 5) continue;
                            world.spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(Color.fromRGB((int)0, (int)random.nextInt(256), (int)255), 1.0f));
                        }
                        for (Location loc : BoundingBoxUtils.getRandomLocation(world, naBuildingTerminal, random, 60)) {
                            world.spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)random.nextInt(256)), 1.0f));
                        }
                    }, 0L, 5L).getTaskId();
                    TimeUnit.SECONDS.sleep(1L);
                    for (i = 1; i < 13; ++i) {
                        ClipboardUtils.placeBuilding("nabuilding" + i, o, true);
                        TimeUnit.MILLISECONDS.sleep(300L);
                    }
                    TimeUnit.SECONDS.sleep(10L);
                    Bukkit.getScheduler().cancelTask(taskId);
                    for (i = 1; i < 13; ++i) {
                        ClipboardUtils.clearBuilding("nabuilding" + i, o);
                        TimeUnit.MILLISECONDS.sleep(300L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                buttons.put(button, code);
            });
        });
        buttons.put(new Location(world, -999.0, 69.0, -999.0).getBlock(), player -> {
            ItemStack item = NarMapPlugin.plugin.specialitems.get("bubble_tea");
            Item entity = player.getWorld().dropItem(player.getEyeLocation(), item);
            entity.setVelocity(new Vector(0, 0, 0));
        });
    }

    @EventHandler
    public void onInteraction(PlayerInteractEvent event) {
        Block block;
        Player player;
        if (NarMapPlugin.plugin.disableInteraction) {
            event.setCancelled(true);
            return;
        }
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && event.getClickedBlock().getType().toString().contains("DOOR")) {
            NarMapPlugin.plugin.knockedDoor = Optional.of(event.getClickedBlock());
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getClickedBlock().getType().equals((Object)Material.LEVER) && event.getClickedBlock().equals(cloudLever.getBlock()) && !NarMapPlugin.plugin.advan.checkAchievement(player = event.getPlayer(), "cloudland")) {
            NarMapPlugin.plugin.advan.sendAchievement(player, "cloudland");
        }
        player = event.getPlayer();
        if (event.getItem() != null && NarMapPlugin.plugin.specialitems.isUnplaceable(event.getItem())) {
            event.setCancelled(true);
            return;
        }
        if (buttons == null) {
            Events.loadButtons();
        }
        if ((block = event.getClickedBlock()) == null || !block.getType().equals((Object)Material.STONE_BUTTON)) {
            return;
        }
        Location location = block.getLocation();
        Consumer<Player> function = buttons.get(location.getBlock());
        if (function != null) {
            function.accept(player);
        }
    }

    @EventHandler
    public void onSleep(PlayerBedEnterEvent event) {
        Player player = event.getPlayer();
        if (NarMapPlugin.plugin.disableBeds || NarMapPlugin.plugin.disableInteraction) {
            event.setCancelled(true);
        }
        if (!NarMapPlugin.plugin.mainCharater.isPresent()) {
            return;
        }
        if (!player.equals(NarMapPlugin.plugin.mainCharater.get())) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)NarMapPlugin.plugin, () -> {
            if (player.isSleeping()) {
                NarMapPlugin.plugin.sleptTicks.set(0);
                this.sleepTask = Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> NarMapPlugin.plugin.sleptTicks.incrementAndGet(), 0L, 1L).getTaskId();
            }
        }, 1L);
    }

    @EventHandler
    public void onExitSleep(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        if (!NarMapPlugin.plugin.mainCharater.isPresent()) {
            return;
        }
        if (!player.equals(NarMapPlugin.plugin.mainCharater.get())) {
            return;
        }
        if (this.sleepTask >= 0) {
            Bukkit.getScheduler().cancelTask(this.sleepTask);
            this.sleepTask = -1;
        }
    }

    public static class ThrownItemData {
        private Item item;
        private ItemStack itemstack;

        public ThrownItemData(Item item, ItemStack itemstack) {
            this.item = item;
            this.itemstack = itemstack;
        }

        public Item getItem() {
            return this.item;
        }

        public ItemStack getItemstack() {
            return this.itemstack;
        }
    }
}

