/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.loohp.nar.Commands;
import com.loohp.nar.Listeners.Events;
import com.loohp.nar.Story.Cosmetics;
import com.loohp.nar.Story.Ending;
import com.loohp.nar.Story.ItemCollection;
import com.loohp.nar.Story.MailBox;
import com.loohp.nar.Story.MainSequence;
import com.loohp.nar.Story.Minesweeper;
import com.loohp.nar.Story.MusicManager;
import com.loohp.nar.Story.SpecialItems;
import com.loohp.nar.Story.StartMenu;
import com.loohp.nar.Story.TerminalItems;
import com.loohp.nar.Utils.AdvancementManager;
import com.loohp.nar.Utils.HashUtils;
import com.loohp.nar.Utils.SignMenuFactory;
import com.loohp.nar.WorldGuardRegionManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.SocketException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NarMapPlugin
extends JavaPlugin {
    public static final String RESOURCE_PACK_URL = "http://files.loohpjames.com/narmap/NarMapPack.zip";
    public static byte[] RESOURCE_PACK_HASH;
    public static final AtomicBoolean WAIT_SWITCH;
    private DatagramSocket socket;
    public static NarMapPlugin plugin;
    public static ProtocolManager protocolmanager;
    public Cosmetics cosmetics;
    public World mainWorld;
    public Location menuSpawn;
    public Location blackBox;
    public Location resourcePackTest;
    public AdvancementManager advan;
    public SpecialItems specialitems;
    public SignMenuFactory signMenuFactory;
    public WorldGuardRegionManager wgrm;
    public Minesweeper minesweeper;
    public Optional<Player> mainCharater = Optional.empty();
    public AtomicBoolean gameOngoing = new AtomicBoolean(false);
    public Optional<Integer> chosenOption = Optional.empty();
    public AtomicBoolean playerToggle = new AtomicBoolean(false);
    public Optional<Block> knockedDoor = Optional.empty();
    public boolean terminalStage = false;
    public boolean disableCustomSLP = false;
    public boolean disableMovement = false;
    public boolean disableRotation = false;
    public boolean disableInteraction = false;
    public boolean disableBeds = true;
    public boolean disableDamage = true;
    public double chatDelayMultiplier = 1.0;
    public AtomicInteger sleptTicks = new AtomicInteger(0);

    public void onEnable() {
        plugin = this;
        protocolmanager = ProtocolLibrary.getProtocolManager();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.reloadConfig();
        try {
            ReadableByteChannel rbc = Channels.newChannel(new URL(RESOURCE_PACK_URL).openStream());
            File zip = new File(this.getDataFolder(), "temp_pack.zip");
            FileOutputStream fos = new FileOutputStream(zip);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            RESOURCE_PACK_HASH = HashUtils.createSha1(zip);
            zip.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.chatDelayMultiplier = this.getConfig().getDouble("ChatDelayMultiplier", 1.0);
        this.mainWorld = (World)Bukkit.getWorlds().get(0);
        this.blackBox = new Location(this.mainWorld, 0.5, 1.0, 0.5);
        this.resourcePackTest = new Location(this.mainWorld, 998.5, 23.5, 988.5, 90.0f, 21.0f);
        this.menuSpawn = new Location(this.mainWorld, -3.5, 10.0, 17.5, 0.0f, 0.0f);
        this.cosmetics = new Cosmetics(this);
        this.specialitems = new SpecialItems(this);
        this.advan = new AdvancementManager(this);
        this.wgrm = new WorldGuardRegionManager(this);
        this.signMenuFactory = new SignMenuFactory((Plugin)this);
        this.minesweeper = new Minesweeper(this);
        this.getCommand("nar").setExecutor((CommandExecutor)new Commands());
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "NarMapPlugin is up and running!");
        TerminalItems.detect();
        ItemCollection._init_();
        MailBox.check();
        StartMenu.startup();
        MusicManager.setup();
        Ending.startup();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(plugin.getConfig().getString("MainCharacter"))) continue;
            NarMapPlugin.plugin.mainCharater = Optional.of(player);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> WAIT_SWITCH.set(true), 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.setFoodLevel(18);
            }
        }, 0L, 20L);
        try {
            this.socket = new DatagramSocket();
            byte[] buf = ("[MOTD]" + ChatColor.YELLOW + "Nana\u7684\u65c5\u7a0b[/MOTD][AD][/AD]").getBytes(StandardCharsets.UTF_8);
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.socket.send(new DatagramPacket(buf, buf.length, Inet4Address.getByName("224.0.2.60"), 4445));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }, 0L, 40L);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        this.cosmetics.safeShutdown();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.socket.close();
    }

    public synchronized CompletableFuture<Boolean> startStage(StartMenu.Option stage) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (this.gameOngoing.get()) {
            future.complete(false);
        } else {
            this.gameOngoing.set(true);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                try {
                    if (!(stage.equals((Object)StartMenu.Option.START_GAME) || stage.equals((Object)StartMenu.Option.STAGE_BEGIN) || stage.equals((Object)StartMenu.Option.STAGE_NIGHTMARE) || stage.equals((Object)StartMenu.Option.STAGE_REVISIT))) {
                        this.gameOngoing.set(false);
                        future.complete(false);
                    } else {
                        future.complete(true);
                        this.gameOngoing.set(true);
                        if (stage.equals((Object)StartMenu.Option.START_GAME) || stage.equals((Object)StartMenu.Option.STAGE_BEGIN)) {
                            MainSequence.stageBeginning().get();
                        }
                        if (stage.equals((Object)StartMenu.Option.START_GAME) || stage.equals((Object)StartMenu.Option.STAGE_BEGIN) || stage.equals((Object)StartMenu.Option.STAGE_NIGHTMARE)) {
                            MainSequence.stageNightmareVillage().get();
                        }
                        if (stage.equals((Object)StartMenu.Option.START_GAME) || stage.equals((Object)StartMenu.Option.STAGE_BEGIN) || stage.equals((Object)StartMenu.Option.STAGE_NIGHTMARE) || stage.equals((Object)StartMenu.Option.STAGE_REVISIT)) {
                            MainSequence.stageNightmareTerminal().get();
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                this.gameOngoing.set(false);
            });
        }
        return future;
    }

    public static void sendResourcePack(Player player) {
        player.setResourcePack(RESOURCE_PACK_URL, RESOURCE_PACK_HASH);
    }

    public void blockSLP() {
        protocolmanager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Status.Client.START}){

            public void onPacketReceiving(PacketEvent event) {
                event.setCancelled(true);
            }
        });
    }

    static {
        WAIT_SWITCH = new AtomicBoolean(false);
    }
}

