/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Story;

import com.denizenscript.denizen.npc.traits.SneakingTrait;
import com.loohp.nar.NarMapPlugin;
import com.loohp.nar.Utils.ChatUtils;
import com.loohp.nar.Utils.ChunkUtils;
import com.loohp.nar.Utils.NBTUtils;
import com.loohp.nar.Utils.RayTrace;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Cosmetics
implements Listener {
    private NarMapPlugin plugin;
    private NPC activeNPC = null;
    private Set<Integer> glowing = new HashSet<Integer>();
    private Set<Location> closetDoors = new HashSet<Location>();
    private Location closet;
    protected final Map<UUID, ClosetPlayerData> openedCloset = new ConcurrentHashMap<UUID, ClosetPlayerData>();
    private ItemStack leaveClosetItem;
    private BoundingBox closetBox;
    private BoundingBox saturnBox;
    private Map<NPC, NPC> mapping = new HashMap<NPC, NPC>();
    private NPC mirrorPlayer;
    private String usingTexture = null;
    private AtomicBoolean closetFlag = new AtomicBoolean(false);

    public Cosmetics(NarMapPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.closetDoors.add(new Location(plugin.mainWorld, 17.0, 75.0, -83.0));
        this.closetDoors.add(new Location(plugin.mainWorld, 17.0, 76.0, -83.0));
        this.closetDoors.add(new Location(plugin.mainWorld, 16.0, 75.0, -83.0));
        this.closetDoors.add(new Location(plugin.mainWorld, 16.0, 76.0, -83.0));
        this.closet = new Location(plugin.mainWorld, 998.5, 14.5, 988.5, 90.0f, 0.0f);
        ChunkUtils.setChunksAroundLoaded(this.closet.getChunk(), true);
        this.leaveClosetItem = new ItemStack(Material.BARRIER);
        ItemMeta meta = this.leaveClosetItem.getItemMeta();
        meta.setDisplayName(ChatColor.RED + "\u95dc\u9589\u8863\u6ac3");
        this.leaveClosetItem.setItemMeta(meta);
        this.leaveClosetItem = NBTUtils.set(this.leaveClosetItem, 1, "leaveClosetItem");
        this.clothesSelector();
        this.saturnIndicator();
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> this.closetMirror(), 100L);
        this.saturnBox = BoundingBox.of((Location)new Location(plugin.mainWorld, 14.99, 71.35, -87.0), (Location)new Location(plugin.mainWorld, 16.02, 71.0, -86.84));
        this.closetBox = BoundingBox.of((Block)plugin.mainWorld.getBlockAt(1002, 13, 1001), (Block)plugin.mainWorld.getBlockAt(990, 21, 975));
    }

    private void setClosetNPC() {
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(3), CitizensAPI.getNPCRegistry().getById(32));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(7), CitizensAPI.getNPCRegistry().getById(31));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(8), CitizensAPI.getNPCRegistry().getById(30));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(9), CitizensAPI.getNPCRegistry().getById(29));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(10), CitizensAPI.getNPCRegistry().getById(28));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(11), CitizensAPI.getNPCRegistry().getById(27));
        this.mapping.put(CitizensAPI.getNPCRegistry().getById(12), CitizensAPI.getNPCRegistry().getById(26));
        this.mirrorPlayer = CitizensAPI.getNPCRegistry().getById(33);
    }

    private void closetMirror() {
        this.setClosetNPC();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            if (Bukkit.getOnlinePlayers().stream().noneMatch(each -> each.getWorld().equals(this.plugin.mainWorld) && this.closetBox.contains(each.getBoundingBox()))) {
                return;
            }
            if (this.closetFlag.get()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                try {
                    for (Map.Entry<NPC, NPC> entry : this.mapping.entrySet()) {
                        NPC npc = entry.getKey();
                        NPC npc_mirror = entry.getValue();
                        if (!npc_mirror.isSpawned()) {
                            npc_mirror.spawn(npc_mirror.getStoredLocation());
                        }
                        Location mirror = npc_mirror.getEntity().getLocation();
                        if (!npc.isSpawned()) {
                            npc_mirror.spawn(npc_mirror.getStoredLocation());
                        }
                        Location real = npc.getEntity().getLocation();
                        mirror.setYaw(270.0f + (90.0f - real.getYaw()));
                        mirror.setPitch(real.getPitch());
                        npc_mirror.teleport(mirror, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        npc_mirror.data().set("glowing", npc.data().get("glowing"));
                    }
                    if (!this.plugin.mainCharater.isPresent()) {
                        return;
                    }
                    Player player = this.plugin.mainCharater.get();
                    if (player.getWorld().equals(this.plugin.mainWorld) && this.closetBox.contains(player.getBoundingBox())) {
                        Property property = (Property)((CraftPlayer)player).getProfile().getProperties().get((Object)"textures").iterator().next();
                        String name = property.getName();
                        String texture = property.getValue();
                        String signature = property.getSignature();
                        if (this.usingTexture == null || !texture.equals(this.usingTexture)) {
                            this.mirrorPlayer.data().setPersistent("player-skin-name", (Object)name);
                            this.mirrorPlayer.data().setPersistent("player-skin-textures", (Object)texture);
                            this.mirrorPlayer.data().setPersistent("player-skin-signature", (Object)signature);
                            this.usingTexture = texture;
                            if (this.mirrorPlayer.isSpawned()) {
                                Location loc = this.mirrorPlayer.getStoredLocation();
                                this.mirrorPlayer.despawn();
                                this.mirrorPlayer.spawn(loc);
                            }
                        }
                        Equipment equipment = (Equipment)this.mirrorPlayer.getTraitNullable(Equipment.class);
                        for (EquipmentSlot slot : EquipmentSlot.values()) {
                            Equipment.EquipmentSlot cSlot;
                            switch (slot) {
                                case CHEST: {
                                    cSlot = Equipment.EquipmentSlot.CHESTPLATE;
                                    break;
                                }
                                case FEET: {
                                    cSlot = Equipment.EquipmentSlot.BOOTS;
                                    break;
                                }
                                case HAND: {
                                    cSlot = Equipment.EquipmentSlot.OFF_HAND;
                                    break;
                                }
                                case HEAD: {
                                    cSlot = Equipment.EquipmentSlot.HELMET;
                                    break;
                                }
                                case LEGS: {
                                    cSlot = Equipment.EquipmentSlot.LEGGINGS;
                                    break;
                                }
                                default: {
                                    cSlot = Equipment.EquipmentSlot.HAND;
                                }
                            }
                            ItemStack item_mirror = equipment.get(cSlot);
                            ItemStack item = player.getEquipment().getItem(slot);
                            if (item_mirror == item && (item_mirror == null || item_mirror.isSimilar(item))) continue;
                            equipment.set(cSlot, item == null ? null : item.clone());
                        }
                        boolean isSneaking = player.isSneaking();
                        SneakingTrait sneakingTrait = (SneakingTrait)this.mirrorPlayer.getTraitNullable(SneakingTrait.class);
                        if (sneakingTrait == null) {
                            this.mirrorPlayer.addTrait(SneakingTrait.class);
                        }
                        if (isSneaking != sneakingTrait.isSneaking()) {
                            if (isSneaking) {
                                sneakingTrait.sneak();
                            } else {
                                sneakingTrait.stand();
                            }
                        }
                        Location mirror = this.mirrorPlayer.getEntity().getLocation();
                        Location real = player.getLocation();
                        mirror.setYaw(270.0f + (90.0f - real.getYaw()));
                        mirror.setPitch(real.getPitch());
                        double x_offset = real.getX() - 990.5;
                        mirror.setX(990.5 - x_offset);
                        mirror.setY(real.getY());
                        mirror.setZ(real.getZ());
                        this.mirrorPlayer.teleport(mirror, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.closetFlag.set(true);
                    this.setClosetNPC();
                    this.closetFlag.set(false);
                }
            });
        }, 100L, 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        Location location;
        if (this.plugin.disableInteraction) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if ((event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) && player.getEquipment().getItemInMainHand() != null && NBTUtils.contains(player.getEquipment().getItemInMainHand(), "leaveClosetItem")) {
            event.setCancelled(true);
            ClosetPlayerData data = this.openedCloset.remove(player.getUniqueId());
            if (data != null) {
                player.teleport(data.getLocation());
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
            }
            player.getInventory().clear();
            Inventory inv = data.getInventory();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                if (inv.getItem(i) == null) continue;
                player.getInventory().setItem(i, inv.getItem(i).clone());
            }
            player.resetPlayerTime();
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && this.closetDoors.contains(location = block.getLocation())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (block.getBlockData() instanceof Openable) {
                    Openable openable = (Openable)block.getBlockData();
                    openable.setOpen(false);
                    block.setBlockData((BlockData)openable);
                    block.getWorld().playSound(block.getLocation(), Sound.BLOCK_WOODEN_DOOR_CLOSE, 3.0f, 1.0f);
                }
            }, 40L);
            Inventory inv = Bukkit.createInventory(null, (int)54);
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                if (player.getInventory().getItem(i) == null) continue;
                inv.setItem(i, player.getInventory().getItem(i).clone());
            }
            player.getInventory().clear();
            this.openedCloset.put(player.getUniqueId(), new ClosetPlayerData(player.getLocation().clone(), inv));
            player.getInventory().setItem(4, this.leaveClosetItem.clone());
            player.teleport(this.closet);
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
            player.playSound(player.getLocation(), Sound.BLOCK_WOODEN_DOOR_OPEN, 3.0f, 1.0f);
            player.setPlayerTime(18000L, false);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        RayTrace rayTrace;
        ItemStack item;
        ItemFrame frame;
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame && (frame = (ItemFrame)entity).getItem() != null && (item = frame.getItem()).hasItemMeta() && item.getItemMeta().hasDisplayName() && ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).equalsIgnoreCase("\u667a\u80fd\u8863\u6ac3") && !player.getGameMode().equals((Object)GameMode.CREATIVE) && !player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            event.setCancelled(true);
            ChatUtils.sendToAllPlayers("<" + player.getName() + "> \u4eca\u5929\u7a7f\u4ec0\u9ebc\u597d\u5462\uff1f");
            return;
        }
        if (entity instanceof Painting && (rayTrace = new RayTrace(player.getEyeLocation().toVector(), player.getLocation().getDirection())).intersects(this.saturnBox, 5.0, 0.05) && !this.plugin.advan.checkAchievement(player, "saturn")) {
            this.plugin.signMenuFactory.newMenu(new ArrayList<String>(Arrays.asList("", "&2&l^^^^^^^^^^^", "&5&l\u8acb\u8f38\u5165", "&2&l============="))).response((p, lines) -> {
                if (p.equals(player) && lines[0].replace(" ", "").equalsIgnoreCase("saturn")) {
                    player.sendTitle(ChatColor.GREEN + "\u6b63\u78ba!", "", 10, 40, 15);
                    player.playSound(player.getLocation(), "minecraft:narmap.sfx.accepted", 5.0f, 1.0f);
                    this.plugin.advan.sendAchievement(player, "saturn");
                    return true;
                }
                ChatUtils.sendLetterByLetterTitle(player, ChatColor.RED + "" + ChatColor.MAGIC + "!!" + ChatColor.RED + "\u932f\u8aa4" + ChatColor.MAGIC + "!!", "", 2, 40, 15, "minecraft:narmap.sfx.beep");
                return false;
            }).open(player);
        }
    }

    private void saturnIndicator() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            RayTrace rayTrace;
            Vector pos;
            if (!this.plugin.mainCharater.isPresent()) {
                return;
            }
            Player player = this.plugin.mainCharater.get();
            if (!this.plugin.advan.checkAchievement(player, "saturn") && (pos = (rayTrace = new RayTrace(player.getEyeLocation().toVector(), player.getLocation().getDirection())).positionOfIntersection(this.saturnBox, 5.0, 0.05)) != null) {
                player.getWorld().spawnParticle(Particle.REDSTONE, pos.toLocation(player.getWorld()), 10, (Object)new Particle.DustOptions(Color.YELLOW, 1.0f));
            }
        }, 1L, 3L);
    }

    @EventHandler
    public void onAnimation(PlayerAnimationEvent event) {
        NPC npc;
        Player player;
        Entity entity;
        if (event.getAnimationType().equals((Object)PlayerAnimationType.ARM_SWING) && (entity = RayTrace.getLookingEntity((LivingEntity)(player = event.getPlayer()), 7.0, EntityType.PLAYER)) != null && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)) != null && npc.getName().startsWith("narskin")) {
            if (!npc.getName().substring(7).equals("clear")) {
                Bukkit.dispatchCommand((CommandSender)player, (String)("skin set " + npc.getName()));
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)"skin clear");
            }
        }
    }

    private void clothesSelector() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.plugin.mainCharater.isPresent()) {
                return;
            }
            Player player = this.plugin.mainCharater.get();
            if (player != null) {
                Entity entity = RayTrace.getLookingEntity((LivingEntity)player, 7.0, EntityType.PLAYER);
                if (entity != null) {
                    NPC npc = CitizensAPI.getNPCRegistry().getNPC(entity);
                    if (npc != null) {
                        if (npc.getName().startsWith("narskin")) {
                            if (this.activeNPC == null || !this.activeNPC.equals(npc)) {
                                player.playSound(player.getLocation(), "minecraft:narmap.sfx.select", 5.0f, 1.0f);
                            }
                            npc.data().set("glowing", (Object)true);
                            player.sendTitle("", ChatColor.GREEN + "\u5de6\u9375\u66f4\u63db", 0, 7, 10);
                            this.activeNPC = npc;
                            this.glowing.add(npc.getId());
                        } else {
                            this.activeNPC = null;
                        }
                    } else {
                        this.activeNPC = null;
                    }
                } else {
                    this.activeNPC = null;
                }
            }
            Iterator<Integer> itr = this.glowing.iterator();
            while (itr.hasNext()) {
                Integer npcId = itr.next();
                if (this.activeNPC != null && this.activeNPC.getId() == npcId.intValue()) continue;
                NPC npc = CitizensAPI.getNPCRegistry().getById(npcId.intValue());
                if (npc.getEntity() != null) {
                    npc.data().set("glowing", (Object)false);
                }
                itr.remove();
            }
        }, 0L, 3L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        ClosetPlayerData data = this.openedCloset.remove(player.getUniqueId());
        if (data != null) {
            player.teleport(data.getLocation());
            player.getInventory().clear();
            Inventory inv = data.getInventory();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                if (inv.getItem(i) == null) continue;
                player.getInventory().setItem(i, inv.getItem(i).clone());
            }
            player.resetPlayerTime();
        }
    }

    public void safeShutdown() {
        for (Map.Entry<UUID, ClosetPlayerData> entry : this.openedCloset.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            ClosetPlayerData data = entry.getValue();
            player.getInventory().clear();
            Inventory inv = data.getInventory();
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                if (inv.getItem(i) == null) continue;
                player.getInventory().setItem(i, inv.getItem(i).clone());
            }
            player.resetPlayerTime();
        }
    }

    public static class ClosetPlayerData {
        private final Location location;
        private final Inventory inv;

        public ClosetPlayerData(Location location, Inventory inv) {
            this.location = location;
            this.inv = inv;
        }

        public Location getLocation() {
            return this.location;
        }

        public Inventory getInventory() {
            return this.inv;
        }
    }
}

