/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Story;

import com.loohp.nar.NarMapPlugin;
import com.loohp.nar.Utils.RayTrace;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class ItemCollection
implements Listener {
    public static final String SCOREBOARD_TAG = "item_collection";
    public static final String PLACE_NOTICE = "\u53f3\u9375\u653e\u7f6e";
    public static final Status STATUS = new Status(false, false, false, false);
    public static final Set<Item> ITEMS_CREATED = new HashSet<Item>();

    public static void _init_() {
        Bukkit.getPluginManager().registerEvents((Listener)new ItemCollection(), (Plugin)NarMapPlugin.plugin);
        NarMapPlugin.plugin.mainWorld.setChunkForceLoaded(1, -6, true);
        ItemCollection.update();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace face = event.getBlockFace();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        Entity c = UUIDS.BLUE.getEntity();
        if (player.getWorld().equals(c.getWorld()) && player.getLocation().distanceSquared(c.getLocation()) > 100.0) {
            return;
        }
        block = block.getRelative(face);
        List<UUID> uuids = UUIDS.getUUIDs();
        for (Entity entity : block.getWorld().getNearbyEntities(BoundingBox.of((Block)block))) {
            if (!uuids.contains(entity.getUniqueId())) continue;
            this.onInteractEntity(new PlayerInteractAtEntityEvent(player, entity, entity.getLocation().toVector()));
            return;
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractAtEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (!UUIDS.contains(entity.getUniqueId())) {
            return;
        }
        World world = player.getWorld();
        PlayerInventory inv = player.getInventory();
        int heldSlot = inv.getHeldItemSlot();
        switch (UUIDS.fromUUID(entity.getUniqueId())) {
            case GREEN: {
                if (STATUS.getGreen()) break;
                ItemStack compare = NarMapPlugin.plugin.specialitems.get("challenge_henry");
                if (inv.getItem(heldSlot) != null && inv.getItem(heldSlot).isSimilar(compare)) {
                    inv.setItem(heldSlot, null);
                    Location placement = entity.getLocation().clone().add(0.0, 0.2, 0.0);
                    Item item = world.dropItem(placement, compare);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setGravity(false);
                    item.setPickupDelay(Short.MAX_VALUE);
                    item.addScoreboardTag(SCOREBOARD_TAG);
                    item.teleport(placement);
                    ITEMS_CREATED.add(item);
                    world.playSound(placement, Sound.BLOCK_BEACON_ACTIVATE, 5.0f, 1.0f);
                }
                STATUS.setGreen(true);
                break;
            }
            case BLUE: {
                if (STATUS.getBlue()) break;
                ItemStack compare = NarMapPlugin.plugin.specialitems.get("challenge_loohp");
                if (inv.getItem(heldSlot) != null && inv.getItem(heldSlot).isSimilar(compare)) {
                    inv.setItem(heldSlot, null);
                    Location placement = entity.getLocation().clone().add(0.0, 0.2, 0.0);
                    Item item = world.dropItem(placement, compare);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setGravity(false);
                    item.setPickupDelay(Short.MAX_VALUE);
                    item.addScoreboardTag(SCOREBOARD_TAG);
                    item.teleport(placement);
                    ITEMS_CREATED.add(item);
                    world.playSound(placement, Sound.BLOCK_BEACON_ACTIVATE, 5.0f, 1.0f);
                }
                STATUS.setBlue(true);
                break;
            }
            case RED: {
                if (STATUS.getRed()) break;
                ItemStack compare = NarMapPlugin.plugin.specialitems.get("challenge_carrr");
                if (inv.getItem(heldSlot) != null && inv.getItem(heldSlot).isSimilar(compare)) {
                    inv.setItem(heldSlot, null);
                    Location placement = entity.getLocation().clone().add(0.0, 0.2, 0.0);
                    Item item = world.dropItem(placement, compare);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setGravity(false);
                    item.setPickupDelay(Short.MAX_VALUE);
                    item.addScoreboardTag(SCOREBOARD_TAG);
                    item.teleport(placement);
                    ITEMS_CREATED.add(item);
                    world.playSound(placement, Sound.BLOCK_BEACON_ACTIVATE, 5.0f, 1.0f);
                }
                STATUS.setRed(true);
                break;
            }
            case PURPLE: {
                if (STATUS.getPurple()) break;
                ItemStack compare = NarMapPlugin.plugin.specialitems.get("challenge_biggy");
                if (inv.getItem(heldSlot) != null && inv.getItem(heldSlot).isSimilar(compare)) {
                    inv.setItem(heldSlot, null);
                    Location placement = entity.getLocation().clone().add(0.0, 0.2, 0.0);
                    Item item = world.dropItem(placement, compare);
                    item.setVelocity(new Vector(0, 0, 0));
                    item.setGravity(false);
                    item.setPickupDelay(Short.MAX_VALUE);
                    item.addScoreboardTag(SCOREBOARD_TAG);
                    item.teleport(placement);
                    ITEMS_CREATED.add(item);
                    world.playSound(placement, Sound.BLOCK_BEACON_ACTIVATE, 5.0f, 1.0f);
                }
                STATUS.setPurple(true);
            }
        }
        event.setCancelled(true);
    }

    public static void update() {
        Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
            Player player = NarMapPlugin.plugin.mainCharater.orElse(null);
            if (player == null) {
                return;
            }
            World world = NarMapPlugin.plugin.mainWorld;
            if (!player.getWorld().equals(world)) {
                return;
            }
            if (player.getLocation().distanceSquared(UUIDS.BLUE.getEntity().getLocation()) > 100.0) {
                return;
            }
            ItemStack held = player.getEquipment().getItemInMainHand();
            if (held == null) {
                return;
            }
            int looking = RayTrace.getFirstIntersectedBoundingBoxLookingAt((LivingEntity)player, 5.0, UUIDS.getSelectionBoxes().toArray(new BoundingBox[0]));
            if (NarMapPlugin.plugin.specialitems.get("challenge_biggy").isSimilar(held)) {
                world.spawnParticle(Particle.REDSTONE, UUIDS.PURPLE.getEntity().getLocation().clone().add(0.0, 0.4, 0.0), 5, 0.2, 0.2, 0.2, (Object)new Particle.DustOptions(UUIDS.PURPLE.getColor(), 1.0f));
                if (looking == UUIDS.PURPLE.ordinal()) {
                    player.sendTitle("", ChatColor.of((Color)new Color(UUIDS.PURPLE.getColor().asRGB())) + PLACE_NOTICE, 0, 7, 10);
                }
            } else if (NarMapPlugin.plugin.specialitems.get("challenge_loohp").isSimilar(held)) {
                world.spawnParticle(Particle.REDSTONE, UUIDS.BLUE.getEntity().getLocation().clone().add(0.0, 0.4, 0.0), 5, 0.2, 0.2, 0.2, (Object)new Particle.DustOptions(UUIDS.BLUE.getColor(), 1.0f));
                if (looking == UUIDS.BLUE.ordinal()) {
                    player.sendTitle("", ChatColor.of((Color)new Color(UUIDS.BLUE.getColor().asRGB())) + PLACE_NOTICE, 0, 7, 10);
                }
            } else if (NarMapPlugin.plugin.specialitems.get("challenge_henry").isSimilar(held)) {
                world.spawnParticle(Particle.REDSTONE, UUIDS.GREEN.getEntity().getLocation().clone().add(0.0, 0.4, 0.0), 5, 0.2, 0.2, 0.2, (Object)new Particle.DustOptions(UUIDS.GREEN.getColor(), 1.0f));
                if (looking == UUIDS.GREEN.ordinal()) {
                    player.sendTitle("", ChatColor.of((Color)new Color(UUIDS.GREEN.getColor().asRGB())) + PLACE_NOTICE, 0, 7, 10);
                }
            } else if (NarMapPlugin.plugin.specialitems.get("challenge_carrr").isSimilar(held)) {
                world.spawnParticle(Particle.REDSTONE, UUIDS.RED.getEntity().getLocation().clone().add(0.0, 0.4, 0.0), 5, 0.2, 0.2, 0.2, (Object)new Particle.DustOptions(UUIDS.RED.getColor(), 1.0f));
                if (looking == UUIDS.RED.ordinal()) {
                    player.sendTitle("", ChatColor.of((Color)new Color(UUIDS.RED.getColor().asRGB())) + PLACE_NOTICE, 0, 7, 10);
                }
            }
        }, 0L, 5L);
    }

    public static void clear() {
        if (Bukkit.isPrimaryThread()) {
            STATUS.setBlue(false);
            STATUS.setGreen(false);
            STATUS.setRed(false);
            STATUS.setPurple(false);
            Iterator<Item> itr = ITEMS_CREATED.iterator();
            while (itr.hasNext()) {
                Item item = itr.next();
                item.remove();
                itr.remove();
            }
            World world = NarMapPlugin.plugin.mainWorld;
            Collection items = world.getNearbyEntities(BoundingBox.of((Block)world.getBlockAt(22, 76, -87), (Block)world.getBlockAt(26, 76, -87)), each -> each instanceof Item);
            for (Entity entity : items) {
                Item item = (Item)entity;
                if (!item.getScoreboardTags().contains(SCOREBOARD_TAG)) continue;
                item.remove();
            }
        } else {
            CompletableFuture future = new CompletableFuture();
            Bukkit.getScheduler().runTask((Plugin)NarMapPlugin.plugin, () -> {
                ItemCollection.clear();
                future.complete(null);
            });
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Status {
        private boolean green;
        private boolean blue;
        private boolean red;
        private boolean purple;

        public Status(boolean green, boolean blue, boolean red, boolean purple) {
            this.green = green;
            this.blue = blue;
            this.red = red;
            this.purple = purple;
        }

        public boolean getGreen() {
            return this.green;
        }

        public void setGreen(boolean green) {
            this.green = green;
        }

        public boolean getBlue() {
            return this.blue;
        }

        public void setBlue(boolean blue) {
            this.blue = blue;
        }

        public boolean getRed() {
            return this.red;
        }

        public void setRed(boolean red) {
            this.red = red;
        }

        public boolean getPurple() {
            return this.purple;
        }

        public void setPurple(boolean purple) {
            this.purple = purple;
        }
    }

    public static enum UUIDS {
        GREEN(UUID.fromString("27a09d40-f569-46ab-94b2-dfd9c16dbf1e"), org.bukkit.Color.fromRGB((int)0, (int)200, (int)0)),
        BLUE(UUID.fromString("0da3fa0f-dad6-4e35-838a-0bf67cfb87b1"), org.bukkit.Color.fromRGB((int)0, (int)102, (int)255)),
        RED(UUID.fromString("b77afcc5-982d-47e5-ade0-7ad943d653be"), org.bukkit.Color.RED),
        PURPLE(UUID.fromString("72159c5c-3148-4e22-8b4b-0fd2a5846f53"), org.bukkit.Color.fromRGB((int)204, (int)0, (int)204));

        private UUID uuid;
        private org.bukkit.Color color;
        private BoundingBox selectionBox;
        private static List<UUID> uuids;
        private static List<BoundingBox> boxes;

        private UUIDS(UUID uuid, org.bukkit.Color color) {
            this.uuid = uuid;
            this.color = color;
            this.selectionBox = null;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public org.bukkit.Color getColor() {
            return this.color;
        }

        public Entity getEntity() {
            return Bukkit.getEntity((UUID)this.uuid);
        }

        public BoundingBox getSelectionBox() {
            BoundingBox box;
            if (this.selectionBox != null) {
                return this.selectionBox;
            }
            Block block = this.getEntity().getLocation().getBlock();
            this.selectionBox = box = new BoundingBox((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)(block.getX() + 1), (double)block.getY() + 0.1, (double)(block.getZ() + 1));
            return box;
        }

        public static UUIDS fromUUID(UUID uuid) {
            for (UUIDS uuids : UUIDS.values()) {
                if (!uuids.getUniqueId().equals(uuid)) continue;
                return uuids;
            }
            return null;
        }

        public static boolean contains(UUID uuid) {
            return UUIDS.fromUUID(uuid) != null;
        }

        public static List<UUID> getUUIDs() {
            if (uuids != null) {
                return new ArrayList<UUID>(uuids);
            }
            ArrayList<UUID> list = new ArrayList<UUID>();
            for (UUIDS each : UUIDS.values()) {
                list.add(each.getUniqueId());
            }
            uuids = list;
            return new ArrayList<UUID>(uuids);
        }

        public static List<BoundingBox> getSelectionBoxes() {
            if (boxes != null) {
                return new ArrayList<BoundingBox>(boxes);
            }
            ArrayList<BoundingBox> list = new ArrayList<BoundingBox>();
            for (UUIDS each : UUIDS.values()) {
                list.add(each.getSelectionBox());
            }
            boxes = list;
            return new ArrayList<BoundingBox>(boxes);
        }

        static {
            uuids = null;
            boxes = null;
        }
    }
}

