/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Story;

import com.loohp.nar.NarMapPlugin;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class Minesweeper
implements Listener {
    private NarMapPlugin plugin;
    private World world;
    private AtomicBoolean isWon;
    private AtomicBoolean isEnd;
    private Block loseIndiactor;
    private ProtectedRegion board;
    private ProtectedRegion area;

    public Minesweeper(NarMapPlugin plugin) {
        this.plugin = plugin;
        this.world = plugin.mainWorld;
        this.isWon = new AtomicBoolean(false);
        this.isEnd = new AtomicBoolean(false);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loseIndiactor = this.world.getBlockAt(-71, 87, -76);
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            RegionManager manager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)this.world));
            this.board = manager.getRegion("minesweeperboard");
            this.area = manager.getRegion("minesweeper");
        }, 2L);
        this.run();
    }

    public CompletableFuture<Void> reset() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.world.getBlockAt(-70, 87, -80).setType(Material.REDSTONE_BLOCK);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.world.getBlockAt(-70, 87, -80).setType(Material.WHITE_WOOL);
            this.isWon.set(false);
            this.isEnd.set(false);
            future.complete(null);
        }, 2L);
        return future;
    }

    public boolean isWon() {
        return this.isWon.get();
    }

    public boolean isEnd() {
        return this.isEnd.get();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        if (this.plugin.disableInteraction) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || !event.getHand().equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        Block block = event.getClickedBlock();
        Location location = block.getLocation();
        if (this.isEnd.get()) {
            if (block.equals(this.world.getBlockAt(-65, 93, -73))) {
                this.reset();
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.reset(), 5L);
            }
        } else {
            if (!this.board.contains(BukkitAdapter.asBlockVector((Location)location))) {
                return;
            }
            if (block.getType().equals((Object)Material.LIGHT_GRAY_CARPET)) {
                block.setType(Material.RED_CARPET);
            } else if (block.getType().equals((Object)Material.RED_CARPET)) {
                block.setType(Material.LIGHT_GRAY_CARPET);
            }
        }
    }

    private void run() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.plugin.mainCharater.isPresent() || this.isEnd.get()) {
                return;
            }
            Player player = this.plugin.mainCharater.get();
            if (!this.area.contains(BukkitAdapter.asBlockVector((Location)player.getLocation()))) {
                return;
            }
            if (this.loseIndiactor.getType().equals((Object)Material.RED_WOOL)) {
                this.isEnd.set(true);
            } else {
                BlockVector3 max = this.board.getMaximumPoint();
                BlockVector3 min = this.board.getMinimumPoint();
                ArrayList<Location> covered = new ArrayList<Location>();
                for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
                    for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                        for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                            Material material = this.world.getBlockAt(x, y, z).getType();
                            if (!material.equals((Object)Material.LIGHT_GRAY_CARPET) && !material.equals((Object)Material.RED_CARPET)) continue;
                            covered.add(new Location(this.world, (double)x, (double)(y - 1), (double)z));
                        }
                    }
                }
                this.isWon.set(covered.size() == 40 && covered.stream().allMatch(each -> each.getBlock().getType().equals((Object)Material.ANCIENT_DEBRIS)));
                if (this.isWon.get()) {
                    this.isEnd.set(true);
                }
            }
        }, 4L, 5L);
    }
}

