/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Story;

import com.loohp.nar.Events.RegionsChangedEvent;
import com.loohp.nar.NarMapPlugin;
import com.loohp.nar.Utils.WorldGuardUtils;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MusicManager
implements Listener {
    public static final String MENU = "menu";
    public static final String PUMPKIN_STREET = "pumpkin_street";
    public static final String NANA_HOUSE = "nana_house";
    public static final String BIGGY_HOUSE = "biggy_house";
    public static final String CLOSET = "closet";
    public static final String TERMINAL = "terminal";
    public static final String CLASSROOM = "classroom";
    public static final String OLDBASE = "oldbase";
    public static final String MUSHROOM = "mushroom";
    public static final String NEWBASE = "newbase";
    public static final String S3BASE = "s3base";
    public static final String ENDING = "ending";
    public static Map<String, String> mapping = new HashMap<String, String>();
    public static Map<String, Long> duration = new HashMap<String, Long>();
    public static Map<UUID, UUID> current = new HashMap<UUID, UUID>();

    public static void setup() {
        Bukkit.getPluginManager().registerEvents((Listener)new MusicManager(), (Plugin)NarMapPlugin.plugin);
        mapping.put(MENU, "minecraft:narmap.bgm.menu");
        mapping.put(NANA_HOUSE, "minecraft:narmap.bgm.nana_house");
        mapping.put(PUMPKIN_STREET, "minecraft:narmap.bgm.pumpkin_street");
        mapping.put(TERMINAL, "minecraft:narmap.bgm.terminal");
        mapping.put(CLOSET, "minecraft:narmap.bgm.closet");
        mapping.put(NEWBASE, "minecraft:narmap.bgm.newbase");
        mapping.put(BIGGY_HOUSE, "minecraft:narmap.bgm.biggy_house");
        mapping.put(CLASSROOM, "minecraft:narmap.bgm.classroom");
        mapping.put(ENDING, "minecraft:narmap.bgm.ending");
        duration.put("minecraft:narmap.bgm.menu", 126000L);
        duration.put("minecraft:narmap.bgm.nana_house", 114000L);
        duration.put("minecraft:narmap.bgm.pumpkin_street", 98000L);
        duration.put("minecraft:narmap.bgm.terminal", 210000L);
        duration.put("minecraft:narmap.bgm.closet", 187000L);
        duration.put("minecraft:narmap.bgm.newbase", 180000L);
        duration.put("minecraft:narmap.bgm.biggy_house", 583000L);
        duration.put("minecraft:narmap.bgm.classroom", 200000L);
        duration.put("minecraft:narmap.bgm.ending", 175000L);
    }

    @EventHandler
    public void onRegionChange(RegionsChangedEvent event) {
        String toPlay;
        String wasPlaying;
        final Player player = event.getPlayer();
        ProtectedRegion currentRegion = WorldGuardUtils.getHighestPriorityRegion(event.getCurrentRegions());
        ProtectedRegion previousRegion = WorldGuardUtils.getHighestPriorityRegion(event.getPreviousRegions());
        if (previousRegion != null && (wasPlaying = mapping.get(previousRegion.getId())) != null) {
            player.stopSound(wasPlaying, SoundCategory.RECORDS);
            current.remove(player.getUniqueId());
        }
        if (currentRegion != null && (toPlay = mapping.get(currentRegion.getId())) != null) {
            player.playSound(player.getLocation(), toPlay, SoundCategory.RECORDS, 200.0f, 1.0f);
            final UUID key = UUID.randomUUID();
            current.put(player.getUniqueId(), key);
            new BukkitRunnable(){

                public void run() {
                    UUID compareKey = current.get(player.getUniqueId());
                    if (compareKey != null && key.equals(compareKey)) {
                        player.playSound(player.getLocation(), toPlay, SoundCategory.RECORDS, 200.0f, 1.0f);
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NarMapPlugin.plugin, (long)Math.ceil(duration.get(toPlay) / 50L), (long)Math.ceil(duration.get(toPlay) / 50L));
        }
    }
}

