/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Story;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.loohp.nar.NarMapPlugin;
import com.loohp.nar.Utils.RayTrace;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BoundingBox;
import ru.beykerykt.lightapi.LightAPI;
import ru.beykerykt.lightapi.LightType;
import ru.beykerykt.lightapi.chunks.ChunkInfo;

public class StartMenu
implements Listener {
    public static final double CHAR_HEIGHT = 0.12;
    public static final double CHAR_WIDTH = 0.1;
    public static final String LOCKED = "\u5c1a\u672a\u89e3\u9396";
    public static World world = NarMapPlugin.plugin.mainWorld;
    public static BoundingBox area = BoundingBox.of((Block)new Location(world, -14.0, 20.0, 7.0).getBlock(), (Block)new Location(world, 6.0, 0.0, 27.0).getBlock());
    public static Set<UUID> players = new HashSet<UUID>();
    public static BiMap<Option, BoundingBox> optionsBox = HashBiMap.create();
    public static Map<UUID, Option> selectedOption = new HashMap<UUID, Option>();
    public static Map<Option, Boolean> waypointStatus = new HashMap<Option, Boolean>();
    public static Map<Option, Boolean> stageStatus = new HashMap<Option, Boolean>();

    public static void startup() {
        Bukkit.getPluginManager().registerEvents((Listener)new StartMenu(), (Plugin)NarMapPlugin.plugin);
        world.setChunkForceLoaded(0, 0, true);
        world.setChunkForceLoaded(0, 1, true);
        world.setChunkForceLoaded(-1, 1, true);
        world.setChunkForceLoaded(-1, 0, true);
        for (Option option : Option.values()) {
            Location loc = option.getEntity().getLocation().add(0.0, 0.4, 0.0);
            BoundingBox box = BoundingBox.of((Location)loc, (Location)loc).expand(0.1 * (double)(option.getAxis() == 0 ? option.getTitle().length() : 1), 0.12, 0.1 * (double)(option.getAxis() == 1 ? option.getTitle().length() : 1));
            optionsBox.put((Object)option, (Object)box);
            if (option.name().startsWith("WAYPOINT")) {
                waypointStatus.put(option, false);
                continue;
            }
            if (!option.name().startsWith("STAGE")) continue;
            stageStatus.put(option, false);
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
            Collection playersInMenu = world.getNearbyEntities(area, each -> each instanceof Player);
            if (playersInMenu.isEmpty()) {
                for (Option option : Option.values()) {
                    option.getEntity().setCustomNameVisible(false);
                }
            } else {
                for (Option option : Option.values()) {
                    option.getEntity().setCustomNameVisible(true);
                }
            }
            ArrayList otherPlayers = new ArrayList(Bukkit.getOnlinePlayers());
            otherPlayers.removeAll(playersInMenu);
            for (Entity entity : playersInMenu) {
                BoundingBox[] boxes;
                Player player = (Player)entity;
                RayTrace.TraceResult looking = RayTrace.getFirstIntersectedBoundingBoxAndLocationLookingAt((LivingEntity)player, 20.0, boxes = optionsBox.values().toArray(new BoundingBox[0]));
                int index = looking.getIndex();
                if (index >= 0) {
                    Option option = (Option)((Object)((Object)optionsBox.inverse().get((Object)boxes[index])));
                    if (option != null) {
                        Option select = selectedOption.get(player.getUniqueId());
                        if (select == null || select != null && !option.equals((Object)select)) {
                            selectedOption.put(player.getUniqueId(), option);
                            world.playSound(option.getEntity().getLocation(), "minecraft:narmap.sfx.select", 3.0f, 1.0f);
                        }
                        world.spawnParticle(Particle.REDSTONE, looking.getLocation(), 10, (Object)new Particle.DustOptions(Color.YELLOW, 1.0f));
                        continue;
                    }
                    selectedOption.remove(player.getUniqueId());
                    continue;
                }
                selectedOption.remove(player.getUniqueId());
            }
            for (Player player : otherPlayers) {
                selectedOption.remove(player.getUniqueId());
            }
            Collection<Option> selected = selectedOption.values();
            ArrayList<Option> unselected = new ArrayList<Option>(Arrays.asList(Option.values()));
            unselected.removeAll(selected);
            for (Option option : selected) {
                if (waypointStatus.getOrDefault((Object)option, true).booleanValue() && stageStatus.getOrDefault((Object)option, true).booleanValue()) {
                    option.getEntity().setCustomName(ChatColor.YELLOW + "" + ChatColor.BOLD + option.getTitle());
                    continue;
                }
                option.getEntity().setCustomName(ChatColor.GRAY + "" + ChatColor.BOLD + LOCKED);
            }
            for (Option option : unselected) {
                if (waypointStatus.getOrDefault((Object)option, true).booleanValue() && stageStatus.getOrDefault((Object)option, true).booleanValue()) {
                    option.getEntity().setCustomName(ChatColor.WHITE + option.getTitle());
                    continue;
                }
                option.getEntity().setCustomName(ChatColor.GRAY + LOCKED);
            }
            players = playersInMenu.parallelStream().map(each -> each.getUniqueId()).collect(Collectors.toSet());
        }, 0L, 1L);
        Location speedStand = new Location(world, -0.5, 11.5, 17.5);
        Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
            LinkedList<Location> locs = new LinkedList<Location>();
            for (Option option : Option.values()) {
                Location location = option.getEntity().getLocation();
                LightAPI.createLight((Location)location, (LightType)LightType.BLOCK, (int)15, (boolean)false);
                locs.add(location);
            }
            LightAPI.createLight((Location)speedStand, (LightType)LightType.BLOCK, (int)15, (boolean)false);
            locs.add(speedStand);
            HashSet infos = new HashSet();
            for (Location location : locs) {
                infos.addAll(LightAPI.collectChunks((Location)location, (LightType)LightType.BLOCK, (int)15));
            }
            for (ChunkInfo info : infos) {
                LightAPI.updateChunk((ChunkInfo)info, (LightType)LightType.BLOCK);
            }
        }, 0L, 100L);
        Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> {
            if (NarMapPlugin.plugin.mainCharater.isPresent() && Bukkit.getOnlinePlayers().contains(NarMapPlugin.plugin.mainCharater.get())) {
                Player player = NarMapPlugin.plugin.mainCharater.get();
                waypointStatus.put(Option.WAYPOINT_STREET, NarMapPlugin.plugin.advan.checkProgression(player, "begin"));
                waypointStatus.put(Option.WAYPOINT_VILLAGE, NarMapPlugin.plugin.advan.checkProgression(player, "nana_village"));
                waypointStatus.put(Option.WAYPOINT_CLASSROOM, NarMapPlugin.plugin.advan.checkProgression(player, "nana_classroom"));
                waypointStatus.put(Option.WAYPOINT_MUSHROOM, NarMapPlugin.plugin.advan.checkProgression(player, "nana_mushroom"));
                waypointStatus.put(Option.WAYPOINT_NEWBASE, NarMapPlugin.plugin.advan.checkProgression(player, "nana_newbase"));
                waypointStatus.put(Option.WAYPOINT_OLDBASE, NarMapPlugin.plugin.advan.checkProgression(player, "nana_oldbase"));
                waypointStatus.put(Option.WAYPOINT_S3BASE, NarMapPlugin.plugin.advan.checkProgression(player, "nana_s3base"));
                waypointStatus.put(Option.WAYPOINT_TERMINAL, NarMapPlugin.plugin.advan.checkProgression(player, "terminal"));
                waypointStatus.put(Option.WAYPOINT_ENDING, NarMapPlugin.plugin.advan.checkProgression(player, "complete"));
                stageStatus.put(Option.STAGE_BEGIN, NarMapPlugin.plugin.advan.checkProgression(player, "begin"));
                stageStatus.put(Option.STAGE_NIGHTMARE, NarMapPlugin.plugin.advan.checkProgression(player, "nana_village"));
                stageStatus.put(Option.STAGE_REVISIT, NarMapPlugin.plugin.advan.checkProgression(player, "terminal"));
            } else {
                for (Map.Entry<Option, Boolean> entry : waypointStatus.entrySet()) {
                    entry.setValue(true);
                }
                for (Map.Entry<Option, Boolean> entry : stageStatus.entrySet()) {
                    entry.setValue(true);
                }
            }
        }, 0L, 20L);
        Entity speed = Bukkit.getEntity((UUID)UUID.fromString("5890a515-5fef-4406-9dbb-3b3167060c60"));
        DecimalFormat format = new DecimalFormat("0.##");
        Bukkit.getScheduler().runTaskTimer((Plugin)NarMapPlugin.plugin, () -> speed.setCustomName(ChatColor.AQUA + "\u73fe\u6642\u904a\u6232\u5c0d\u8a71\u901f\u5ea6\u8a2d\u7f6e\u70ba " + format.format(Math.pow(NarMapPlugin.plugin.chatDelayMultiplier, -1.0)) + " \u500d"), 0L, 10L);
    }

    @EventHandler
    public void onAnimation(PlayerAnimationEvent event) {
        Option option;
        Player player = event.getPlayer();
        if (players.contains(player.getUniqueId()) && (option = selectedOption.get(player.getUniqueId())) != null && waypointStatus.getOrDefault((Object)option, true).booleanValue() && stageStatus.getOrDefault((Object)option, true).booleanValue()) {
            switch (option) {
                case WAYPOINT_CLASSROOM: {
                    player.teleport(new Location(world, 4187.5, 24.0, 14181.5, 90.0f, 0.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_ENDING: {
                    player.teleport(new Location(world, 10002.5, 100.0, 10002.5, 180.0f, 0.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_MUSHROOM: {
                    player.teleport(new Location(world, 2957.0, 63.0, 1240.5, -90.0f, 0.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_NEWBASE: {
                    player.teleport(new Location(world, 2536.5, 64.0, 3875.5));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_OLDBASE: {
                    player.teleport(new Location(world, -2006.0, 64.0, -1998.0, 176.0f, 0.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_S3BASE: {
                    player.teleport(new Location(world, 2159.0, 38.0, -523.0));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_STREET: {
                    player.teleport(new Location(world, 17.0, 75.5626, -87.0, 0.0f, 0.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_TERMINAL: {
                    player.teleport(new Location(world, -907.5, 68.0, -999.5, 0.0f, 90.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case WAYPOINT_VILLAGE: {
                    player.teleport(new Location(world, -3255.5, 67.5626, 561.0, 0.0f, 90.0f));
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
                    break;
                }
                case START_GAME: 
                case STAGE_BEGIN: 
                case STAGE_NIGHTMARE: 
                case STAGE_REVISIT: {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)NarMapPlugin.plugin, () -> {
                        try {
                            if (!NarMapPlugin.plugin.startStage(option).get().booleanValue()) {
                                player.sendMessage(ChatColor.RED + "\u904a\u6232\u5df2\u5728\u9032\u884c\u4e2d");
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
        }
    }

    public static enum Option {
        START_GAME("\u958b\u59cb\u904a\u6232", UUID.fromString("c1dff76f-d22a-42cf-9d1c-7877f0015cb2"), 0),
        WAYPOINT_STREET("\u5357\u74dc\u8def", UUID.fromString("44b5ac15-a36a-422b-9b32-2c9bfa1c1272"), 0),
        WAYPOINT_VILLAGE("\u5a1c\u7684\u6751\u838a", UUID.fromString("de9b7236-e019-45bc-9192-c14dacc578f2"), 0),
        WAYPOINT_CLASSROOM("\u6559\u5ba4", UUID.fromString("5c2fb76a-90d1-40b8-965f-9237c08b9b9d"), 0),
        WAYPOINT_OLDBASE("\u5a1c2017\u5e74\u672b\u7684\u5bb6\u5712", UUID.fromString("e5252012-5764-4741-ba89-ed054d1f787a"), 0),
        WAYPOINT_MUSHROOM("\u88ab\u907a\u5fd8\u7684\u8611\u83c7\u5730", UUID.fromString("535da78c-9c76-4fa1-ba7c-d1da95f6c322"), 0),
        WAYPOINT_NEWBASE("\u5e7d\u9748\u5c0f\u93ae", UUID.fromString("46d32d99-d005-41fb-96fc-7251d6b44f12"), 0),
        WAYPOINT_S3BASE("\u5a1c2017\u5e74\u590f\u5b63\u7684\u5bb6\u5712", UUID.fromString("c0fe7b00-3157-4a9f-b27f-3de83488e555"), 0),
        WAYPOINT_TERMINAL("\u7d42\u7aef\u7a7a\u9593", UUID.fromString("55c6c265-54cf-44b0-b199-e0a15613ca91"), 0),
        WAYPOINT_ENDING("\u7247\u5c3e", UUID.fromString("86e9aaa9-e90e-4148-a9f4-27c977e4a075"), 0),
        STAGE_BEGIN("\u670b\u53cb\u5011\u7684\u6311\u6230", UUID.fromString("7d21becd-f78e-4fe3-9916-9c630ec48b32"), 1),
        STAGE_NIGHTMARE("\u5a1c\u7684\u60e1\u5922", UUID.fromString("f07afd4d-cf19-4d68-9cd2-6ef7570a1244"), 1),
        STAGE_REVISIT("\u672a\u4f86\u8207\u904e\u53bb", UUID.fromString("aaede025-d312-4a9e-ae32-e16b3be00ec7"), 1);

        private String title;
        private UUID uuid;
        private int axis;

        private Option(String title, UUID uuid, int axis) {
            this.title = title;
            this.uuid = uuid;
            this.axis = axis;
        }

        public String getTitle() {
            return this.title;
        }

        public ArmorStand getEntity() {
            return (ArmorStand)Bukkit.getEntity((UUID)this.uuid);
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public int getAxis() {
            return this.axis;
        }
    }
}

