/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Utils;

import com.loohp.nar.Utils.SyncUtils;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.BoundingBox;

public class ClipboardUtils {
    public static void placeBuilding(String schematicFile, Location location, boolean ignoreAir) {
        if (!Bukkit.isPrimaryThread()) {
            try {
                SyncUtils.run(() -> ClipboardUtils.placeBuilding(schematicFile, location, ignoreAir)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        File file = new File(Bukkit.getWorldContainer() + "/plugins/WorldEdit/schematics", schematicFile.endsWith(".schem") ? schematicFile : schematicFile + ".schem");
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try {
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            Clipboard clipboard = reader.read();
            reader.close();
            EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt((World)location.getWorld())).build();
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ())).ignoreAirBlocks(ignoreAir).copyBiomes(true).copyEntities(true).build();
            Operations.complete((Operation)operation);
            editSession.close();
        }
        catch (WorldEditException | IOException e) {
            e.printStackTrace();
        }
    }

    public static void clearBuilding(String schematicFile, Location location) {
        if (!Bukkit.isPrimaryThread()) {
            try {
                SyncUtils.run(() -> ClipboardUtils.clearBuilding(schematicFile, location)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            return;
        }
        File file = new File(Bukkit.getWorldContainer() + "/plugins/WorldEdit/schematics", schematicFile.endsWith(".schem") ? schematicFile : schematicFile + ".schem");
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try {
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            Clipboard clipboard = reader.read();
            reader.close();
            Iterator itr = clipboard.getRegion().iterator();
            BlockState air = BukkitAdapter.adapt((BlockData)Bukkit.createBlockData((Material)Material.AIR));
            while (itr.hasNext()) {
                BlockVector3 blockpos = (BlockVector3)itr.next();
                clipboard.setBlock(blockpos, (BlockStateHolder)air);
            }
            EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt((World)location.getWorld())).build();
            Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ())).build();
            Operations.complete((Operation)operation);
            editSession.close();
        }
        catch (WorldEditException | IOException e) {
            e.printStackTrace();
        }
    }

    public static BoundingBox getBuildingRegion(String schematicFile, Location location) {
        if (!Bukkit.isPrimaryThread()) {
            CompletableFuture future = new CompletableFuture();
            try {
                SyncUtils.run(() -> future.complete(ClipboardUtils.getBuildingRegion(schematicFile, location)));
                return (BoundingBox)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        File file = new File(Bukkit.getWorldContainer() + "/plugins/WorldEdit/schematics", schematicFile.endsWith(".schem") ? schematicFile : schematicFile + ".schem");
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try {
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            Clipboard clipboard = reader.read();
            reader.close();
            Region region = clipboard.getRegion();
            return BoundingBox.of((Block)BukkitAdapter.adapt((World)location.getWorld(), (BlockVector3)region.getMaximumPoint()).getBlock(), (Block)BukkitAdapter.adapt((World)location.getWorld(), (BlockVector3)region.getMinimumPoint()).getBlock());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

