/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NBTUtils {
    private static final Map<String, Class<?>> classCache;
    private static final Map<String, Method> methodCache;
    private static final Map<Class<?>, Constructor<?>> constructorCache;
    private static final Map<Class<?>, Class<?>> NBTClasses;
    private static final Map<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static final String VERSION;
    private static final MinecraftVersion LOCAL_VERSION;

    private static Class<?> getNBTTag(Class<?> primitiveType) {
        if (NBTClasses.containsKey(primitiveType)) {
            return NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    private static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static Method getMethod(String name) {
        return methodCache.containsKey(name) ? methodCache.get(name) : null;
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        return constructorCache.containsKey(clazz) ? constructorCache.get(clazz) : null;
    }

    private static Class<?> getNMSClass(String name) {
        if (classCache.containsKey(name)) {
            return classCache.get(name);
        }
        try {
            return Class.forName("net.minecraft.server." + VERSION + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Object createItemStack(Object compound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
            return NBTUtils.getConstructor(NBTUtils.getNMSClass("ItemStack")).newInstance(compound);
        }
        return NBTUtils.getMethod("createStack").invoke(null, compound);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return LOCAL_VERSION;
    }

    public static ItemStack getHead(String skinURL) {
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack head = new ItemStack(material, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        Object profile = null;
        try {
            profile = NBTUtils.getConstructor(NBTUtils.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = NBTUtils.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = NBTUtils.getConstructor(NBTUtils.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes())));
            NBTUtils.getMethod("put").invoke(propertyMap, "textures", textureProperty);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        if (methodCache.containsKey("setProfile")) {
            try {
                NBTUtils.getMethod("setProfile").invoke((Object)headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            Field profileField = null;
            try {
                profileField = headMeta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static String getTexture(ItemStack head) {
        ItemMeta meta = head.getItemMeta();
        Field profileField = null;
        try {
            profileField = meta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Item is not a player skull!");
        }
        profileField.setAccessible(true);
        try {
            Object profile = profileField.get(meta);
            if (profile == null) {
                return null;
            }
            Collection properties = (Collection)NBTUtils.getMethod("values").invoke(NBTUtils.getMethod("getProperties").invoke(profile, new Object[0]), new Object[0]);
            for (Object prop : properties) {
                if (!"textures".equals(NBTUtils.getMethod("getName").invoke(prop, new Object[0]))) continue;
                String texture = new String(Base64.getDecoder().decode((String)NBTUtils.getMethod("getValue").invoke(prop, new Object[0])));
                return NBTUtils.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getItemTag(ItemStack item, Object ... keys) {
        try {
            return NBTUtils.getTag(NBTUtils.getCompound(item), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTUtils.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTUtils.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTUtils.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getItemNBTTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTUtils.getMethod("asNMSCopy").invoke(null, item);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            tag = NBTUtils.getMethod("save").invoke(stack, tag);
            return NBTUtils.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = NBTUtils.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTUtils.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTUtils.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTUtils.setTag(tag, value, keys);
            }
            NBTUtils.getMethod("setTag").invoke(stack, tag);
            return (ItemStack)NBTUtils.getMethod("asBukkitCopy").invoke(null, stack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemFromTag(NBTCompound compound) {
        if (compound == null) {
            return null;
        }
        try {
            Object tag = compound.tag;
            Object count = NBTUtils.getTag(tag, "Count");
            Object id = NBTUtils.getTag(tag, "id");
            if (count == null || id == null) {
                return null;
            }
            if (count instanceof Byte && id instanceof String) {
                return (ItemStack)NBTUtils.getMethod("asBukkitCopy").invoke(null, NBTUtils.createItemStack(tag));
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getEntityTag(Entity entity, Object ... keys) {
        try {
            return NBTUtils.getTag(NBTUtils.getCompound(entity), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Entity entity) {
        if (entity == null) {
            return entity;
        }
        try {
            Object NMSEntity = NBTUtils.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getEntityNBTTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return null;
        }
        try {
            Object NMSEntity = NBTUtils.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return NBTUtils.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setEntityTag(Entity entity, Object value, Object ... keys) {
        if (entity == null) {
            return;
        }
        try {
            Object NMSEntity = NBTUtils.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getEntityTag").invoke(NMSEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTUtils.setTag(tag, value, keys);
            }
            NBTUtils.getMethod("setEntityTag").invoke(NMSEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static Object getBlockTag(Block block, Object ... keys) {
        try {
            return NBTUtils.getTag(NBTUtils.getCompound(block), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Block block) {
        try {
            if (block == null || !NBTUtils.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTUtils.getConstructor(NBTUtils.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTUtils.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTUtils.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getTileTag").invoke(tileEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getBlockNBTTag(Block block, Object ... keys) {
        try {
            if (block == null || !NBTUtils.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTUtils.getConstructor(NBTUtils.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTUtils.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTUtils.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getTileTag").invoke(tileEntity, tag);
            return NBTUtils.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            if (block == null || !NBTUtils.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTUtils.getConstructor(NBTUtils.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTUtils.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTUtils.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            NBTUtils.getMethod("getTileTag").invoke(tileEntity, tag);
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTUtils.setTag(tag, value, keys);
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                NBTUtils.getMethod("setTileTag").invoke(tileEntity, NBTUtils.getMethod("getType").invoke(nmsWorld, blockPosition), tag);
            } else {
                NBTUtils.getMethod("setTileTag").invoke(tileEntity, tag);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void setSkullTexture(Block block, String texture) {
        try {
            Object profile = NBTUtils.getConstructor(NBTUtils.getNMSClass("GameProfile")).newInstance(UUID.randomUUID(), null);
            Object propertyMap = NBTUtils.getMethod("getProperties").invoke(profile, new Object[0]);
            Object textureProperty = NBTUtils.getConstructor(NBTUtils.getNMSClass("Property")).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes())));
            NBTUtils.getMethod("put").invoke(propertyMap, "textures", textureProperty);
            Location location = block.getLocation();
            Object blockPosition = NBTUtils.getConstructor(NBTUtils.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTUtils.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTUtils.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            NBTUtils.getMethod("setGameProfile").invoke(tileEntity, profile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Object getValue(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return NBTUtils.getItemTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTUtils.getEntityTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTUtils.getBlockTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTUtils.getTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static NBTCompound getNBTCompound(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return NBTUtils.getItemNBTTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTUtils.getEntityNBTTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTUtils.getBlockNBTTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTUtils.getNBTTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(object)) {
            try {
                return NBTUtils.getNBTTag(object, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static String getString(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof String ? (String)result : null;
    }

    public static int getInt(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Integer ? (Integer)result : 0;
    }

    public static double getDouble(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Double ? (Double)result : 0.0;
    }

    public static long getLong(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Long ? (Long)result : 0L;
    }

    public static float getFloat(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Float ? ((Float)result).floatValue() : 0.0f;
    }

    public static short getShort(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Short ? (Short)result : (short)0;
    }

    public static byte getByte(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof Byte ? (Byte)result : (byte)0;
    }

    public static boolean getBoolean(Object object, Object ... keys) {
        return NBTUtils.getByte(object, keys) == 1;
    }

    public static byte[] getByteArray(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof byte[] ? (byte[])result : null;
    }

    public static int[] getIntArray(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result instanceof int[] ? (int[])result : null;
    }

    public static boolean contains(Object object, Object ... keys) {
        Object result = NBTUtils.getValue(object, keys);
        return result != null;
    }

    public static Collection<String> getKeys(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTUtils.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = NBTUtils.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTUtils.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTUtils.getNBTTag(compound, keys);
            Object tag = nbtCompound.tag;
            if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(tag)) {
                return (Collection)NBTUtils.getMethod("getKeys").invoke(tag, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getSize(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTUtils.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = NBTUtils.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTUtils.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTUtils.getNBTTag(compound, keys);
            if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(nbtCompound.tag)) {
                return NBTUtils.getKeys(nbtCompound, new Object[0]).size();
            }
            if (NBTUtils.getNMSClass("NBTTagList").isInstance(nbtCompound.tag)) {
                return (Integer)NBTUtils.getMethod("size").invoke(nbtCompound.tag, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return 0;
        }
        throw new IllegalArgumentException("Value is not a compound or list!");
    }

    public static <T> T set(T object, Object value, Object ... keys) {
        if (object instanceof ItemStack) {
            return (T)NBTUtils.setItemTag((ItemStack)object, value, keys);
        }
        if (object instanceof Entity) {
            NBTUtils.setEntityTag((Entity)object, value, keys);
        } else if (object instanceof Block) {
            NBTUtils.setBlockTag((Block)object, value, keys);
        } else if (object instanceof NBTCompound) {
            try {
                NBTUtils.setTag(((NBTCompound)object).tag, value, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        return object;
    }

    public static NBTCompound getNBTCompound(String json) {
        return NBTCompound.fromJson(json);
    }

    public static NBTCompound getEmptyNBTCompound() {
        try {
            return new NBTCompound(NBTUtils.getNMSClass("NBTTagCompound").newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setTag(Object tag, Object value, Object ... keys) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object notCompound;
        if (value != null) {
            if (value instanceof NBTCompound) {
                notCompound = ((NBTCompound)value).tag;
            } else if (NBTUtils.getNMSClass("NBTTagList").isInstance(value) || NBTUtils.getNMSClass("NBTTagCompound").isInstance(value)) {
                notCompound = value;
            } else {
                if (value instanceof Boolean) {
                    value = (byte)((Boolean)value == true ? 1 : 0);
                }
                notCompound = NBTUtils.getConstructor(NBTUtils.getNBTTag(value.getClass())).newInstance(value);
            }
        } else {
            notCompound = null;
        }
        Object compound = tag;
        for (int index = 0; index < keys.length - 1; ++index) {
            Object key = keys[index];
            Object oldCompound = compound;
            if (key instanceof Integer) {
                compound = ((List)NBTListData.get(compound)).get((Integer)key);
            } else if (key != null) {
                compound = NBTUtils.getMethod("get").invoke(compound, (String)key);
            }
            if (compound != null && key != null) continue;
            compound = keys[index + 1] == null || keys[index + 1] instanceof Integer ? NBTUtils.getNMSClass("NBTTagList").newInstance() : NBTUtils.getNMSClass("NBTTagCompound").newInstance();
            if (oldCompound.getClass().getSimpleName().equals("NBTTagList")) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTUtils.getMethod("add").invoke(oldCompound, NBTUtils.getMethod("size").invoke(oldCompound, new Object[0]), compound);
                    continue;
                }
                NBTUtils.getMethod("add").invoke(oldCompound, compound);
                continue;
            }
            NBTUtils.getMethod("set").invoke(oldCompound, (String)key, compound);
        }
        if (keys.length > 0) {
            Object lastKey = keys[keys.length - 1];
            if (lastKey == null) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTUtils.getMethod("add").invoke(compound, NBTUtils.getMethod("size").invoke(compound, new Object[0]), notCompound);
                } else {
                    NBTUtils.getMethod("add").invoke(compound, notCompound);
                }
            } else if (lastKey instanceof Integer) {
                if (notCompound == null) {
                    NBTUtils.getMethod("listRemove").invoke(compound, (int)((Integer)lastKey));
                } else {
                    NBTUtils.getMethod("setIndex").invoke(compound, (int)((Integer)lastKey), notCompound);
                }
            } else if (notCompound == null) {
                NBTUtils.getMethod("remove").invoke(compound, (String)lastKey);
            } else {
                NBTUtils.getMethod("set").invoke(compound, (String)lastKey, notCompound);
            }
        } else if (notCompound != null) {
            // empty if block
        }
    }

    private static NBTCompound getNBTTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object compound = tag;
        for (Object key : keys) {
            if (compound == null) {
                return null;
            }
            if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(compound)) {
                compound = NBTUtils.getMethod("get").invoke(compound, (String)key);
                continue;
            }
            if (!NBTUtils.getNMSClass("NBTTagList").isInstance(compound)) continue;
            compound = ((List)NBTListData.get(compound)).get((Integer)key);
        }
        return new NBTCompound(compound);
    }

    private static Object getTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (keys.length == 0) {
            return NBTUtils.getTags(tag);
        }
        Object notCompound = tag;
        for (Object key : keys) {
            if (notCompound == null) {
                return null;
            }
            if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
                notCompound = NBTUtils.getMethod("get").invoke(notCompound, (String)key);
                continue;
            }
            if (NBTUtils.getNMSClass("NBTTagList").isInstance(notCompound)) {
                notCompound = ((List)NBTListData.get(notCompound)).get((Integer)key);
                continue;
            }
            return NBTUtils.getNBTVar(notCompound);
        }
        if (notCompound == null) {
            return null;
        }
        if (NBTUtils.getNMSClass("NBTTagList").isInstance(notCompound)) {
            return NBTUtils.getTags(notCompound);
        }
        if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
            return NBTUtils.getTags(notCompound);
        }
        return NBTUtils.getNBTVar(notCompound);
    }

    private static Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (NBTUtils.getNMSClass("NBTTagCompound").isInstance(tag)) {
                Map tagCompound = (Map)NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (NBTUtils.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(key, NBTUtils.getTag(value, new Object[0]));
                }
            } else if (NBTUtils.getNMSClass("NBTTagList").isInstance(tag)) {
                List tagList = (List)NBTListData.get(tag);
                for (int index = 0; index < tagList.size(); ++index) {
                    Object value = tagList.get(index);
                    if (NBTUtils.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(index, NBTUtils.getTag(value, new Object[0]));
                }
            } else {
                return NBTUtils.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tags;
        }
    }

    static {
        VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        LOCAL_VERSION = MinecraftVersion.get(VERSION);
        classCache = new HashMap();
        try {
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + VERSION + ".NBTBase"));
            classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + VERSION + ".NBTTagCompound"));
            classCache.put("NBTTagList", Class.forName("net.minecraft.server." + VERSION + ".NBTTagList"));
            classCache.put("MojangsonParser", Class.forName("net.minecraft.server." + VERSION + ".MojangsonParser"));
            classCache.put("ItemStack", Class.forName("net.minecraft.server." + VERSION + ".ItemStack"));
            classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftItemStack"));
            classCache.put("CraftMetaSkull", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory.CraftMetaSkull"));
            classCache.put("Entity", Class.forName("net.minecraft.server." + VERSION + ".Entity"));
            classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + VERSION + ".entity.CraftEntity"));
            classCache.put("EntityLiving", Class.forName("net.minecraft.server." + VERSION + ".EntityLiving"));
            classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + VERSION + ".CraftWorld"));
            classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + VERSION + ".block.CraftBlockState"));
            classCache.put("BlockPosition", Class.forName("net.minecraft.server." + VERSION + ".BlockPosition"));
            classCache.put("TileEntity", Class.forName("net.minecraft.server." + VERSION + ".TileEntity"));
            classCache.put("World", Class.forName("net.minecraft.server." + VERSION + ".World"));
            classCache.put("IBlockData", Class.forName("net.minecraft.server." + VERSION + ".IBlockData"));
            classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + VERSION + ".TileEntitySkull"));
            classCache.put("GameProfile", Class.forName("com.mojang.authlib.GameProfile"));
            classCache.put("Property", Class.forName("com.mojang.authlib.properties.Property"));
            classCache.put("PropertyMap", Class.forName("com.mojang.authlib.properties.PropertyMap"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBTClasses = new HashMap();
        try {
            NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
            NBTClasses.put(Boolean.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
            NBTClasses.put(String.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagString"));
            NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagDouble"));
            NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagInt"));
            NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagLong"));
            NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagShort"));
            NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagFloat"));
            NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagByteArray"));
            NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagIntArray"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        methodCache = new HashMap<String, Method>();
        try {
            methodCache.put("get", NBTUtils.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            methodCache.put("set", NBTUtils.getNMSClass("NBTTagCompound").getMethod("set", String.class, NBTUtils.getNMSClass("NBTBase")));
            methodCache.put("hasKey", NBTUtils.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            methodCache.put("setIndex", NBTUtils.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, NBTUtils.getNMSClass("NBTBase")));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                methodCache.put("getTypeId", NBTUtils.getNMSClass("NBTBase").getMethod("getTypeId", new Class[0]));
                methodCache.put("add", NBTUtils.getNMSClass("NBTTagList").getMethod("add", Integer.TYPE, NBTUtils.getNMSClass("NBTBase")));
            } else {
                methodCache.put("add", NBTUtils.getNMSClass("NBTTagList").getMethod("add", NBTUtils.getNMSClass("NBTBase")));
            }
            methodCache.put("size", NBTUtils.getNMSClass("NBTTagList").getMethod("size", new Class[0]));
            if (LOCAL_VERSION == MinecraftVersion.v1_8) {
                methodCache.put("listRemove", NBTUtils.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE));
            } else {
                methodCache.put("listRemove", NBTUtils.getNMSClass("NBTTagList").getMethod("remove", Integer.TYPE));
            }
            methodCache.put("remove", NBTUtils.getNMSClass("NBTTagCompound").getMethod("remove", String.class));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("getKeys", NBTUtils.getNMSClass("NBTTagCompound").getMethod("getKeys", new Class[0]));
            } else {
                methodCache.put("getKeys", NBTUtils.getNMSClass("NBTTagCompound").getMethod("c", new Class[0]));
            }
            methodCache.put("hasTag", NBTUtils.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            methodCache.put("getTag", NBTUtils.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            methodCache.put("setTag", NBTUtils.getNMSClass("ItemStack").getMethod("setTag", NBTUtils.getNMSClass("NBTTagCompound")));
            methodCache.put("asNMSCopy", NBTUtils.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            methodCache.put("asBukkitCopy", NBTUtils.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", NBTUtils.getNMSClass("ItemStack")));
            methodCache.put("getEntityHandle", NBTUtils.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("getEntityTag", NBTUtils.getNMSClass("Entity").getMethod("save", NBTUtils.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTUtils.getNMSClass("Entity").getMethod("load", NBTUtils.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("getEntityTag", NBTUtils.getNMSClass("Entity").getMethod("c", NBTUtils.getNMSClass("NBTTagCompound")));
                methodCache.put("setEntityTag", NBTUtils.getNMSClass("Entity").getMethod("f", NBTUtils.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("save", NBTUtils.getNMSClass("ItemStack").getMethod("save", NBTUtils.getNMSClass("NBTTagCompound")));
            if (LOCAL_VERSION.lessThanOrEqualTo(MinecraftVersion.v1_10)) {
                methodCache.put("createStack", NBTUtils.getNMSClass("ItemStack").getMethod("createStack", NBTUtils.getNMSClass("NBTTagCompound")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
                methodCache.put("createStack", NBTUtils.getNMSClass("ItemStack").getMethod("a", NBTUtils.getNMSClass("NBTTagCompound")));
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_16)) {
                methodCache.put("setTileTag", NBTUtils.getNMSClass("TileEntity").getMethod("load", NBTUtils.getNMSClass("IBlockData"), NBTUtils.getNMSClass("NBTTagCompound")));
                methodCache.put("getType", NBTUtils.getNMSClass("World").getMethod("getType", NBTUtils.getNMSClass("BlockPosition")));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_12)) {
                methodCache.put("setTileTag", NBTUtils.getNMSClass("TileEntity").getMethod("load", NBTUtils.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("setTileTag", NBTUtils.getNMSClass("TileEntity").getMethod("a", NBTUtils.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("getTileEntity", NBTUtils.getNMSClass("World").getMethod("getTileEntity", NBTUtils.getNMSClass("BlockPosition")));
            methodCache.put("getWorldHandle", NBTUtils.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            methodCache.put("setGameProfile", NBTUtils.getNMSClass("TileEntitySkull").getMethod("setGameProfile", NBTUtils.getNMSClass("GameProfile")));
            methodCache.put("getProperties", NBTUtils.getNMSClass("GameProfile").getMethod("getProperties", new Class[0]));
            methodCache.put("getName", NBTUtils.getNMSClass("Property").getMethod("getName", new Class[0]));
            methodCache.put("getValue", NBTUtils.getNMSClass("Property").getMethod("getValue", new Class[0]));
            methodCache.put("values", NBTUtils.getNMSClass("PropertyMap").getMethod("values", new Class[0]));
            methodCache.put("put", NBTUtils.getNMSClass("PropertyMap").getMethod("put", Object.class, Object.class));
            methodCache.put("loadNBTTagCompound", NBTUtils.getNMSClass("MojangsonParser").getMethod("parse", String.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            methodCache.put("getTileTag", NBTUtils.getNMSClass("TileEntity").getMethod("save", NBTUtils.getNMSClass("NBTTagCompound")));
        }
        catch (NoSuchMethodException exception) {
            try {
                methodCache.put("getTileTag", NBTUtils.getNMSClass("TileEntity").getMethod("b", NBTUtils.getNMSClass("NBTTagCompound")));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            methodCache.put("setProfile", NBTUtils.getNMSClass("CraftMetaSkull").getDeclaredMethod("setProfile", NBTUtils.getNMSClass("GameProfile")));
            methodCache.get("setProfile").setAccessible(true);
        }
        catch (NoSuchMethodException exception) {
            // empty catch block
        }
        constructorCache = new HashMap();
        try {
            constructorCache.put(NBTUtils.getNBTTag(Byte.class), NBTUtils.getNBTTag(Byte.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Boolean.class), NBTUtils.getNBTTag(Boolean.class).getDeclaredConstructor(Byte.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(String.class), NBTUtils.getNBTTag(String.class).getDeclaredConstructor(String.class));
            constructorCache.put(NBTUtils.getNBTTag(Double.class), NBTUtils.getNBTTag(Double.class).getDeclaredConstructor(Double.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Integer.class), NBTUtils.getNBTTag(Integer.class).getDeclaredConstructor(Integer.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Long.class), NBTUtils.getNBTTag(Long.class).getDeclaredConstructor(Long.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Float.class), NBTUtils.getNBTTag(Float.class).getDeclaredConstructor(Float.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Short.class), NBTUtils.getNBTTag(Short.class).getDeclaredConstructor(Short.TYPE));
            constructorCache.put(NBTUtils.getNBTTag(Class.forName("[B")), NBTUtils.getNBTTag(Class.forName("[B")).getDeclaredConstructor(Class.forName("[B")));
            constructorCache.put(NBTUtils.getNBTTag(Class.forName("[I")), NBTUtils.getNBTTag(Class.forName("[I")).getDeclaredConstructor(Class.forName("[I")));
            for (Constructor<?> cons : constructorCache.values()) {
                cons.setAccessible(true);
            }
            constructorCache.put(NBTUtils.getNMSClass("BlockPosition"), NBTUtils.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
            constructorCache.put(NBTUtils.getNMSClass("GameProfile"), NBTUtils.getNMSClass("GameProfile").getConstructor(UUID.class, String.class));
            constructorCache.put(NBTUtils.getNMSClass("Property"), NBTUtils.getNMSClass("Property").getConstructor(String.class, String.class));
            if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
                constructorCache.put(NBTUtils.getNMSClass("ItemStack"), NBTUtils.getNMSClass("ItemStack").getConstructor(NBTUtils.getNMSClass("NBTTagCompound")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            for (Class<?> clazz : NBTClasses.values()) {
                Field data = clazz.getDeclaredField("data");
                data.setAccessible(true);
                NBTTagFieldCache.put(clazz, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NBTListData = NBTUtils.getNMSClass("NBTTagList").getDeclaredField("list");
            NBTListData.setAccessible(true);
            NBTCompoundMap = NBTUtils.getNMSClass("NBTTagCompound").getDeclaredField("map");
            NBTCompoundMap.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum MinecraftVersion {
        v1_8("1_8", 0),
        v1_9("1_9", 1),
        v1_10("1_10", 2),
        v1_11("1_11", 3),
        v1_12("1_12", 4),
        v1_13("1_13", 5),
        v1_14("1_14", 6),
        v1_15("1_15", 7),
        v1_16("1_16", 8),
        v1_17("1_17", 9),
        v1_18("1_18", 10),
        v1_19("1_19", 11);

        private int order;
        private String key;

        private MinecraftVersion(String key, int v) {
            this.key = key;
            this.order = v;
        }

        public boolean greaterThanOrEqualTo(MinecraftVersion other) {
            return this.order >= other.order;
        }

        public boolean lessThanOrEqualTo(MinecraftVersion other) {
            return this.order <= other.order;
        }

        public static MinecraftVersion get(String v) {
            for (MinecraftVersion k : MinecraftVersion.values()) {
                if (!v.contains(k.key)) continue;
                return k;
            }
            return null;
        }
    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(@Nonnull Object tag) {
            this.tag = tag;
        }

        public void set(Object value, Object ... keys) {
            try {
                NBTUtils.setTag(this.tag, value, keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toJson() {
            return this.tag.toString();
        }

        public static NBTCompound fromJson(String json) {
            try {
                return new NBTCompound(NBTUtils.getMethod("loadNBTTagCompound").invoke(null, json));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.tag.toString();
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NBTCompound other = (NBTCompound)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

