/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar.Utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class RayTrace {
    private Vector origin;
    private Vector direction;

    public static Entity getLookingEntity(LivingEntity entity, double range, EntityType type) {
        RayTrace ray = new RayTrace(entity.getEyeLocation().toVector(), entity.getEyeLocation().getDirection());
        List entities = entity.getNearbyEntities(range, range, range);
        Entity closest = null;
        double distanceSquared = range * range + 1.0;
        for (Entity each : entities) {
            double dis;
            Vector intersect;
            if (!each.getType().equals((Object)type) || (intersect = ray.positionOfIntersection(each.getBoundingBox(), range, 0.01)) == null || !((dis = entity.getEyeLocation().distanceSquared(intersect.toLocation(each.getWorld()))) < distanceSquared)) continue;
            closest = each;
            distanceSquared = dis;
        }
        return closest;
    }

    public static int getFirstIntersectedBoundingBoxLookingAt(LivingEntity entity, double range, BoundingBox ... boxes) {
        RayTrace ray = new RayTrace(entity.getEyeLocation().toVector(), entity.getEyeLocation().getDirection());
        int closest = -1;
        double distanceSquared = range * range + 1.0;
        for (int i = 0; i < boxes.length; ++i) {
            double dis;
            BoundingBox box = boxes[i];
            Vector intersect = ray.positionOfIntersection(box, range, 0.01);
            if (intersect == null || !((dis = entity.getEyeLocation().distanceSquared(intersect.toLocation(entity.getWorld()))) < distanceSquared)) continue;
            closest = i;
            distanceSquared = dis;
        }
        return closest;
    }

    public static TraceResult getFirstIntersectedBoundingBoxAndLocationLookingAt(LivingEntity entity, double range, BoundingBox ... boxes) {
        RayTrace ray = new RayTrace(entity.getEyeLocation().toVector(), entity.getEyeLocation().getDirection());
        int closest = -1;
        Vector closesIntersect = null;
        double distanceSquared = range * range + 1.0;
        for (int i = 0; i < boxes.length; ++i) {
            double dis;
            BoundingBox box = boxes[i];
            Vector intersect = ray.positionOfIntersection(box, range, 0.01);
            if (intersect == null || !((dis = entity.getEyeLocation().distanceSquared(intersect.toLocation(entity.getWorld()))) < distanceSquared)) continue;
            closest = i;
            closesIntersect = intersect;
            distanceSquared = dis;
        }
        return new TraceResult(closest, closesIntersect == null ? null : closesIntersect.toLocation(entity.getWorld()));
    }

    public RayTrace(Vector origin, Vector direction) {
        this.origin = origin;
        this.direction = direction;
    }

    public Vector getPostion(double blocksAway) {
        return this.origin.clone().add(this.direction.clone().multiply(blocksAway));
    }

    public boolean isOnLine(Vector position) {
        double t = (position.getX() - this.origin.getX()) / this.direction.getX();
        return (double)position.getBlockY() == this.origin.getY() + t * this.direction.getY() && (double)position.getBlockZ() == this.origin.getZ() + t * this.direction.getZ();
    }

    public List<Vector> traverse(double blocksAway, double accuracy) {
        ArrayList<Vector> positions = new ArrayList<Vector>();
        for (double d = 0.0; d <= blocksAway; d += accuracy) {
            positions.add(this.getPostion(d));
        }
        return positions;
    }

    public Vector positionOfIntersection(Vector min, Vector max, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return position;
        }
        return null;
    }

    public boolean intersects(Vector min, Vector max, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return true;
        }
        return false;
    }

    public Vector positionOfIntersection(BoundingBox boundingBox, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, boundingBox.getMin(), boundingBox.getMax())) continue;
            return position;
        }
        return null;
    }

    public boolean intersects(BoundingBox boundingBox, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, boundingBox.getMin(), boundingBox.getMax())) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(Vector position, Vector min, Vector max) {
        if (position.getX() < min.getX() || position.getX() > max.getX()) {
            return false;
        }
        if (position.getY() < min.getY() || position.getY() > max.getY()) {
            return false;
        }
        return !(position.getZ() < min.getZ()) && !(position.getZ() > max.getZ());
    }

    public void highlight(World world, double blocksAway, double accuracy) {
        for (Vector position : this.traverse(blocksAway, accuracy)) {
            world.spawnParticle(Particle.REDSTONE, position.toLocation(world), 1, (Object)new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.0f));
        }
    }

    public static class TraceResult {
        private int index;
        private Location location;

        public TraceResult(int index, Location location) {
            this.index = index;
            this.location = location;
        }

        public int getIndex() {
            return this.index;
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

