/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.nar;

import com.loohp.nar.Events.RegionsChangedEvent;
import com.loohp.nar.NarMapPlugin;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class WorldGuardRegionManager
implements Listener {
    private NarMapPlugin plugin;
    private Map<Player, Set<ProtectedRegion>> current = new HashMap<Player, Set<ProtectedRegion>>();

    public WorldGuardRegionManager(NarMapPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.run();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.current.put(player, new HashSet());
        }
    }

    private void run() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : this.current.keySet()) {
                com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)player.getLocation().clone());
                RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
                RegionQuery query = container.createQuery();
                Set set = query.getApplicableRegions(loc).getRegions();
                Set<ProtectedRegion> previous = this.current.get(player);
                if (!previous.containsAll(set) || !set.containsAll(previous)) {
                    Bukkit.getPluginManager().callEvent((Event)new RegionsChangedEvent(player.getUniqueId(), new HashSet<ProtectedRegion>(previous), new HashSet<ProtectedRegion>(set)));
                }
                this.current.put(player, set);
            }
        }, 0L, 1L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.current.put(event.getPlayer(), new HashSet());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        this.current.remove(event.getPlayer());
    }
}

