/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.Rewards;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.trigger.LocationTrigger;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.JsonBuilder;
import hu.trigary.advancementcreator.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Advancement {
    private final NamespacedKey id;
    private final ItemObject icon;
    private final TextComponent title;
    private final TextComponent description;
    private final Map<String, Trigger> triggers = new HashMap<String, Trigger>();
    private Set<String[]> requirements;
    private NamespacedKey parent;
    private String background;
    private Rewards rewards;
    private Frame frame = Frame.TASK;
    private boolean toast = true;
    private boolean announce = true;
    private boolean hidden;

    public Advancement(@NotNull NamespacedKey id, @NotNull ItemObject icon, @NotNull TextComponent title, @NotNull TextComponent description) {
        Validate.notNull((Object)id);
        Validate.notNull((Object)icon);
        Validate.notNull((Object)title);
        Validate.notNull((Object)description);
        this.id = id;
        this.icon = icon;
        this.title = title;
        this.description = description;
    }

    @NotNull
    @Contract(pure=true)
    public NamespacedKey getId() {
        return this.id;
    }

    @NotNull
    @Contract(pure=true)
    public ItemObject getIcon() {
        return this.icon;
    }

    @NotNull
    @Contract(pure=true)
    public TextComponent getTitle() {
        return this.title;
    }

    @NotNull
    @Contract(pure=true)
    public TextComponent getDescription() {
        return this.description;
    }

    @NotNull
    @Contract(pure=true)
    public Set<Map.Entry<String, Trigger>> getTriggers() {
        return Collections.unmodifiableSet(this.triggers.entrySet());
    }

    @NotNull
    @Contract(pure=true)
    public Set<String[]> getRequirements() {
        return this.requirements == null ? Collections.emptySet() : Collections.unmodifiableSet(this.requirements);
    }

    @Nullable
    @Contract(pure=true)
    public NamespacedKey getParent() {
        return this.parent;
    }

    @Nullable
    @Contract(pure=true)
    public String getBackground() {
        return this.background;
    }

    @Nullable
    @Contract(pure=true)
    public Rewards getRewards() {
        return this.rewards;
    }

    @NotNull
    @Contract(pure=true)
    public Frame getFrame() {
        return this.frame;
    }

    @Contract(pure=true)
    public boolean isToast() {
        return this.toast;
    }

    @Contract(pure=true)
    public boolean isAnnounce() {
        return this.announce;
    }

    @Contract(pure=true)
    public boolean isHidden() {
        return this.hidden;
    }

    @NotNull
    public Advancement addTrigger(@NotNull String id, @NotNull Trigger trigger) {
        Validate.notNull((Object)id);
        Validate.notNull((Object)trigger);
        this.triggers.put(id, trigger);
        return this;
    }

    @NotNull
    public Advancement removeTrigger(@NotNull String id) {
        Validate.notNull((Object)id);
        this.triggers.remove(id);
        return this;
    }

    @NotNull
    public Advancement addRequirement(String ... requirement) {
        Validate.notNull((Object)requirement);
        if (this.requirements == null) {
            this.requirements = new HashSet<String[]>();
        }
        this.requirements.add(requirement);
        return this;
    }

    @NotNull
    public Advancement removeRequirement(String ... requirement) {
        Validate.notNull((Object)requirement);
        if (this.requirements == null) {
            return this;
        }
        Iterator<String[]> iterator = this.requirements.iterator();
        while (iterator.hasNext()) {
            if (!Arrays.equals(iterator.next(), requirement)) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    @NotNull
    public Advancement setRewards(@Nullable Rewards rewards) {
        this.rewards = rewards;
        return this;
    }

    @NotNull
    public Advancement setFrame(@NotNull Frame frame) {
        Validate.notNull((Object)((Object)frame));
        this.frame = frame;
        return this;
    }

    @NotNull
    public Advancement setToast(boolean toast) {
        this.toast = toast;
        return this;
    }

    @NotNull
    public Advancement setAnnounce(boolean announce) {
        this.announce = announce;
        return this;
    }

    @NotNull
    public Advancement setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Advancement makeRoot(String background, boolean autoUnlock) {
        Validator.texture(background);
        this.parent = null;
        this.background = "minecraft:textures/" + background + ".png";
        if (autoUnlock) {
            this.triggers.put("auto", new LocationTrigger());
            this.announce = false;
            this.toast = false;
        }
        return this;
    }

    public Advancement makeChild(NamespacedKey parent) {
        Validate.notNull((Object)parent);
        this.parent = parent;
        this.background = null;
        return this;
    }

    public static boolean activate(boolean reload, NamespacedKey id, String json) {
        File file = new File(((World)Bukkit.getWorlds().get(0)).getWorldFolder(), String.join((CharSequence)File.separator, "data", "advancements", id.getNamespace(), id.getKey()) + ".json");
        if (!file.exists()) {
            try {
                return Bukkit.getUnsafe().loadAdvancement(id, json) != null;
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.SEVERE, "Error activating advancement: " + id, e);
                return false;
            }
        }
        try {
            Files.write((CharSequence)json, (File)file, (Charset)Charsets.UTF_8);
            if (reload) {
                Bukkit.reloadData();
                return Bukkit.getAdvancement((NamespacedKey)id) != null;
            }
            return true;
        }
        catch (IOException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Error activating advancement: " + id, e);
            return false;
        }
    }

    public boolean activate(boolean reload) {
        return Advancement.activate(reload, this.id, this.toJson());
    }

    public String toJson() {
        JsonObject json = new JsonObject();
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        Validate.notNull((Object)this.icon.getItem());
        json.add("display", (JsonElement)new JsonBuilder().add("icon", (JsonElement)this.icon.toJson()).add("title", this.title).add("description", this.description).add("background", this.background).add("frame", this.frame.getValue()).addFalse("show_toast", this.toast).addFalse("announce_to_chat", this.announce).addTrue("hidden", this.hidden).build());
        Validate.notEmpty(this.triggers, (String)"All advancements must contain at least one trigger.");
        JsonObject criteria = new JsonObject();
        for (Map.Entry<String, Trigger> entry : this.triggers.entrySet()) {
            criteria.add(entry.getKey(), (JsonElement)entry.getValue().toJson());
        }
        json.add("criteria", (JsonElement)criteria);
        if (this.requirements != null && !this.requirements.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String[] array : this.requirements) {
                JsonArray temp = new JsonArray();
                for (String string : array) {
                    Validate.isTrue((boolean)this.triggers.containsKey(string), (String)("The " + string + " trigger doesn't exist in advancement: "), (Object)this.id);
                    temp.add(string);
                }
                jsonArray.add((JsonElement)temp);
            }
            json.add("requirements", (JsonElement)jsonArray);
        }
        if (this.rewards != null) {
            json.add("rewards", (JsonElement)this.rewards.toJson());
        }
        return JsonBuilder.GSON.toJson((JsonElement)json);
    }

    public String toString() {
        return "Advancement@" + this.id;
    }

    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.icon, this.title, this.description, this.triggers, this.requirements, this.parent, this.background, this.rewards, this.frame, this.toast, this.announce, this.hidden});
    }

    @Contract(pure=true, value="null -> false")
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Advancement)) {
            return false;
        }
        Advancement adv = (Advancement)object;
        if (!(adv.id.equals((Object)this.id) && adv.icon.equals(this.icon) && adv.title.toLegacyText().equals(this.title.toLegacyText()) && adv.description.toLegacyText().equals(this.description.toLegacyText()) && adv.triggers.equals(this.triggers) && Objects.equals(adv.parent, this.parent) && Objects.equals(adv.background, this.background) && Objects.equals(adv.rewards, this.rewards) && adv.frame == this.frame && adv.toast == this.toast && adv.announce == this.announce && adv.hidden == this.hidden)) {
            return false;
        }
        if (this.requirements == null) {
            return adv.requirements == null;
        }
        if (adv.requirements == null) {
            return false;
        }
        if (this.requirements.size() != adv.requirements.size()) {
            return false;
        }
        HashSet<String[]> clone = new HashSet<String[]>(this.requirements);
        for (Object[] objectArray : adv.requirements) {
            boolean removed = false;
            Iterator iterator = clone.iterator();
            while (iterator.hasNext()) {
                if (!Arrays.equals((Object[])iterator.next(), objectArray)) continue;
                iterator.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            return false;
        }
        return true;
    }

    public static enum Frame {
        TASK,
        CHALLENGE,
        GOAL;


        public String getValue() {
            return this.name().toLowerCase();
        }
    }
}

