/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator;

import hu.trigary.advancementcreator.Advancement;
import hu.trigary.advancementcreator.shared.BlockObject;
import hu.trigary.advancementcreator.shared.DeathObject;
import hu.trigary.advancementcreator.shared.EntityObject;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.shared.RangeObject;
import hu.trigary.advancementcreator.trigger.ImpossibleTrigger;
import hu.trigary.advancementcreator.trigger.InventoryChangedTrigger;
import hu.trigary.advancementcreator.trigger.LocationTrigger;
import hu.trigary.advancementcreator.trigger.PlacedBlockTrigger;
import hu.trigary.advancementcreator.trigger.PlayerKilledEntityTrigger;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.Validator;
import java.util.Arrays;
import java.util.function.Function;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class AdvancementFactory {
    private final Plugin plugin;
    private final boolean autoActivate;
    private final boolean autoReload;

    public AdvancementFactory(Plugin plugin, boolean autoActivate, boolean autoReload) {
        Validate.isTrue((autoActivate || !autoReload ? 1 : 0) != 0, (String)"Auto reload doesn't't work without auto activation.");
        this.plugin = plugin;
        this.autoActivate = autoActivate;
        this.autoReload = autoReload;
    }

    public Advancement getSimple(String id, @Nullable Advancement parent, String title, String description, Material icon, String triggerId, Trigger trigger) {
        AdvancementFactory.validate(id, title, description, icon);
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description)).addTrigger(triggerId, trigger);
        this.finalize(advancement, parent);
        return advancement;
    }

    public <T> Advancement getAll(String id, @Nullable Advancement parent, String title, String description, Material icon, T[] contents, Function<T, Trigger> triggerCreator) {
        AdvancementFactory.validate(id, title, description, icon);
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description));
        for (int i = 0; i < contents.length; ++i) {
            advancement.addTrigger(String.valueOf(i), triggerCreator.apply(contents[i]));
        }
        this.finalize(advancement, parent);
        return advancement;
    }

    public <T> Advancement getAny(String id, @Nullable Advancement parent, String title, String description, Material icon, T[] contents, Function<T, Trigger> triggerCreator) {
        AdvancementFactory.validate(id, title, description, icon);
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description));
        String[] requirements = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            String index;
            requirements[i] = index = String.valueOf(i);
            advancement.addTrigger(index, triggerCreator.apply(contents[i]));
        }
        advancement.addRequirement(requirements);
        this.finalize(advancement, parent);
        return advancement;
    }

    public Advancement getRoot(String id, String title, String description, Material icon, String background) {
        AdvancementFactory.validate(id, title, description, icon);
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description)).makeRoot(background, true);
        this.finalize(advancement, null);
        return advancement;
    }

    public Advancement getEmpty(String id, @Nullable Advancement parent, String title, String description, Material icon) {
        AdvancementFactory.validate(id, title, description, icon);
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description)).addTrigger("auto", new LocationTrigger()).setAnnounce(false).setToast(false);
        this.finalize(advancement, parent);
        return advancement;
    }

    public Advancement getImpossible(String id, @Nullable Advancement parent, String title, String description, Material icon, String ... triggers) {
        AdvancementFactory.validate(id, title, description, icon);
        Validate.notNull((Object)triggers);
        Validate.isTrue((triggers.length > 0 ? 1 : 0) != 0, (String)"At least one trigger must be specified.");
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description));
        for (String trigger : triggers) {
            advancement.addTrigger(trigger, new ImpossibleTrigger());
        }
        this.finalize(advancement, parent);
        return advancement;
    }

    public Advancement getImpossible(String id, @Nullable Advancement parent, String title, String description, Material icon) {
        return this.getImpossible(id, parent, title, description, icon, "0");
    }

    public Advancement getCountedImpossible(String id, @Nullable Advancement parent, String title, String description, Material icon, int triggerCount) {
        AdvancementFactory.validate(id, title, description, icon);
        Validate.isTrue((triggerCount > 0 ? 1 : 0) != 0, (String)"There must be at least one trigger.");
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), new ItemObject().setItem(icon), new TextComponent(title), new TextComponent(description));
        for (int i = 0; i < triggerCount; ++i) {
            advancement.addTrigger(String.valueOf(i), new ImpossibleTrigger());
        }
        this.finalize(advancement, parent);
        return advancement;
    }

    public Advancement getItem(String id, @Nullable Advancement parent, String title, String description, Material item, Integer minCount) {
        return this.getSimple(id, parent, title, description, item, "item", new InventoryChangedTrigger().addItem(new ItemObject().setItem(item).setCount(new RangeObject().setMin(minCount))));
    }

    public Advancement getItem(String id, @Nullable Advancement parent, String title, String description, Material item) {
        return this.getItem(id, parent, title, description, item, null);
    }

    public Advancement getAllItems(String id, @Nullable Advancement parent, String title, String description, ItemObject ... items) {
        AdvancementFactory.validate(items);
        return this.getAll(id, parent, title, description, items[0].getItem(), items, item -> new InventoryChangedTrigger().addItem((ItemObject)item));
    }

    public Advancement getAllItems(String id, @Nullable Advancement parent, String title, String description, Material ... items) {
        return this.getAllItems(id, parent, title, description, AdvancementFactory.toItemObjects(items));
    }

    public Advancement getAllItemsOnce(String id, @Nullable Advancement parent, String title, String description, ItemObject ... items) {
        AdvancementFactory.validate(items);
        AdvancementFactory.validate(id, title, description, items[0].getItem());
        Advancement advancement = new Advancement(new NamespacedKey(this.plugin, id), items[0], new TextComponent(title), new TextComponent(description));
        InventoryChangedTrigger trigger = new InventoryChangedTrigger();
        for (ItemObject item : items) {
            Validate.notNull((Object)item);
            trigger.addItem(item);
        }
        advancement.addTrigger("items", trigger);
        this.finalize(advancement, parent);
        return advancement;
    }

    public Advancement getAllItemsOnce(String id, @Nullable Advancement parent, String title, String description, Material ... items) {
        return this.getAllItemsOnce(id, parent, title, description, AdvancementFactory.toItemObjects(items));
    }

    public Advancement getAnyItem(String id, @Nullable Advancement parent, String title, String description, ItemObject ... items) {
        AdvancementFactory.validate(items);
        return this.getAny(id, parent, title, description, items[0].getItem(), items, item -> new InventoryChangedTrigger().addItem((ItemObject)item));
    }

    public Advancement getAnyItem(String id, @Nullable Advancement parent, String title, String description, Material ... items) {
        return this.getAnyItem(id, parent, title, description, AdvancementFactory.toItemObjects(items));
    }

    public Advancement getPlacedBlock(String id, @Nullable Advancement parent, String title, String description, Material icon, Material block) {
        return this.getSimple(id, parent, title, description, icon, "place", new PlacedBlockTrigger().setBlock(new BlockObject(block)));
    }

    public Advancement getPlacedBlock(String id, @Nullable Advancement parent, String title, String description, Material block) {
        return this.getPlacedBlock(id, parent, title, description, block, block);
    }

    public Advancement getPlaceAnyBlock(String id, @Nullable Advancement parent, String title, String description, Material icon, Material ... blocks) {
        AdvancementFactory.validate(blocks);
        return this.getAny(id, parent, title, description, icon, blocks, block -> new PlacedBlockTrigger().setBlock(new BlockObject((Material)block)));
    }

    public Advancement getPlaceAnyBlock(String id, @Nullable Advancement parent, String title, String description, Material ... blocks) {
        AdvancementFactory.validate(blocks);
        return this.getPlaceAnyBlock(id, parent, title, description, blocks[0], blocks);
    }

    public Advancement getPlaceItem(String id, @Nullable Advancement parent, String title, String description, Material item) {
        return this.getSimple(id, parent, title, description, item, "place", new PlacedBlockTrigger().setItem(new ItemObject().setItem(item)));
    }

    public Advancement getPlaceAllItems(String id, @Nullable Advancement parent, String title, String description, ItemObject ... items) {
        AdvancementFactory.validate(items);
        return this.getAll(id, parent, title, description, items[0].getItem(), items, item -> new PlacedBlockTrigger().setItem((ItemObject)item));
    }

    public Advancement getPlaceAllItems(String id, @Nullable Advancement parent, String title, String description, Material ... items) {
        return this.getPlaceAllItems(id, parent, title, description, AdvancementFactory.toItemObjects(items));
    }

    public Advancement getPlaceAnyItem(String id, @Nullable Advancement parent, String title, String description, ItemObject ... items) {
        AdvancementFactory.validate(items);
        return this.getAny(id, parent, title, description, items[0].getItem(), items, item -> new PlacedBlockTrigger().setItem((ItemObject)item));
    }

    public Advancement getPlaceAnyItem(String id, @Nullable Advancement parent, String title, String description, Material ... items) {
        return this.getPlaceAnyItem(id, parent, title, description, AdvancementFactory.toItemObjects(items));
    }

    public Advancement getKill(String id, @Nullable Advancement parent, String title, String description, Material icon, EntityType mob) {
        Validate.notNull((Object)mob);
        return this.getSimple(id, parent, title, description, icon, "kill", new PlayerKilledEntityTrigger().setDeath(new DeathObject().setEntity(new EntityObject().setType(mob))));
    }

    public Advancement getAllKills(String id, @Nullable Advancement parent, String title, String description, Material icon, EntityType ... mobs) {
        AdvancementFactory.validate(mobs);
        return this.getAll(id, parent, title, description, icon, mobs, mob -> new PlayerKilledEntityTrigger().setDeath(new DeathObject().setEntity(new EntityObject().setType((EntityType)mob))));
    }

    public Advancement getAnyKill(String id, @Nullable Advancement parent, String title, String description, Material icon, EntityType ... mobs) {
        AdvancementFactory.validate(mobs);
        return this.getAny(id, parent, title, description, icon, mobs, mob -> new PlayerKilledEntityTrigger().setDeath(new DeathObject().setEntity(new EntityObject().setType((EntityType)mob))));
    }

    private static void validate(String id, String title, String description, Material icon) {
        Validator.noNamespace(id);
        Validate.notNull((Object)title);
        Validate.notNull((Object)description);
        Validate.notNull((Object)icon);
    }

    private static void validate(Object[] array) {
        Validate.notNull((Object)array);
        Validate.isTrue((array.length > 0 ? 1 : 0) != 0, (String)"You must specify at least one element.");
    }

    private static ItemObject[] toItemObjects(Material[] materials) {
        AdvancementFactory.validate(materials);
        return (ItemObject[])Arrays.stream(materials).map(material -> new ItemObject().setItem((Material)material)).toArray(ItemObject[]::new);
    }

    private void finalize(Advancement advancement, @Nullable Advancement parent) {
        if (parent != null) {
            advancement.makeChild(parent.getId());
        }
        if (this.autoActivate) {
            advancement.activate(this.autoReload);
        }
    }
}

