/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hu.trigary.advancementcreator.util.JsonBuilder;
import hu.trigary.advancementcreator.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rewards {
    private Set<NamespacedKey> recipes;
    private Set<NamespacedKey> loots;
    private int experience = 0;
    private NamespacedKey function;

    @NotNull
    @Contract(pure=true)
    public Set<NamespacedKey> getRecipes() {
        return this.recipes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.recipes);
    }

    @NotNull
    @Contract(pure=true)
    public Set<NamespacedKey> getLoots() {
        return this.loots == null ? Collections.emptySet() : Collections.unmodifiableSet(this.loots);
    }

    @Contract(pure=true)
    public int getExperience() {
        return this.experience;
    }

    @Nullable
    @Contract(pure=true)
    public NamespacedKey getFunction() {
        return this.function;
    }

    @NotNull
    public Rewards addRecipe(@NotNull NamespacedKey recipe) {
        Validate.notNull((Object)recipe);
        if (this.recipes == null) {
            this.recipes = new HashSet<NamespacedKey>();
        }
        this.recipes.add(recipe);
        return this;
    }

    @NotNull
    public Rewards removeRecipe(@NotNull NamespacedKey recipe) {
        Validate.notNull((Object)recipe);
        if (this.recipes != null) {
            this.recipes.remove(recipe);
        }
        return this;
    }

    @NotNull
    public Rewards addLoot(@NotNull NamespacedKey loot) {
        Validate.notNull((Object)loot);
        if (this.loots == null) {
            this.loots = new HashSet<NamespacedKey>();
        }
        this.loots.add(loot);
        return this;
    }

    @NotNull
    public Rewards removeLoot(@NotNull NamespacedKey loot) {
        Validate.notNull((Object)loot);
        if (this.loots != null) {
            this.loots.remove(loot);
        }
        return this;
    }

    @NotNull
    public Rewards setExperience(int experience) {
        Validator.zeroToDisable(experience);
        this.experience = experience;
        return this;
    }

    @NotNull
    public Rewards setFunction(@Nullable NamespacedKey function) {
        this.function = function;
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        return new JsonBuilder().add("recipes", this.recipes, v -> new JsonPrimitive(v.toString())).add("loot", this.loots, v -> new JsonPrimitive(v.toString())).addPositive("experience", this.experience).add("function", this.function).build();
    }

    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.recipes, this.loots, this.experience, this.function);
    }

    @Contract(pure=true, value="null -> false")
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Rewards)) {
            return false;
        }
        Rewards other = (Rewards)object;
        return Objects.equals(other.recipes, this.recipes) && Objects.equals(other.loots, this.loots) && Objects.equals(other.experience, this.experience) && Objects.equals(other.function, this.function);
    }
}

