/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.shared;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockObject
extends SharedObject {
    private final Material block;
    private Map<String, String> states;

    public BlockObject(@NotNull Material block) {
        Validate.notNull((Object)block);
        this.block = block;
    }

    @NotNull
    @Contract(pure=true)
    public Material getBlock() {
        return this.block;
    }

    @NotNull
    @Contract(pure=true)
    public Map<String, String> getStates() {
        return this.states == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.states);
    }

    @NotNull
    public BlockObject setState(@NotNull String state, @Nullable String value) {
        Validate.notNull((Object)state);
        if (value == null) {
            if (this.states != null) {
                this.states.remove(state);
            }
        } else {
            if (this.states == null) {
                this.states = new HashMap<String, String>();
            }
            this.states.put(state, value);
        }
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("block", this.block.getKey().toString());
        if (this.states != null && !this.states.isEmpty()) {
            JsonObject state = new JsonObject();
            this.states.forEach((arg_0, arg_1) -> ((JsonObject)state).addProperty(arg_0, arg_1));
            json.add("state", (JsonElement)state);
        }
        return json;
    }
}

