/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.shared;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.DistanceObject;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.shared.LocationObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import hu.trigary.advancementcreator.shared.StatusEffectsObject;
import hu.trigary.advancementcreator.util.JsonBuilder;
import hu.trigary.advancementcreator.util.Validator;
import org.bukkit.Keyed;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityObject
extends SharedObject {
    private EntityType type;
    private DistanceObject distance;
    private LocationObject location;
    private StatusEffectsObject effects;
    private String nbt;
    private Boolean onFire;
    private Boolean sneaking;
    private Boolean sprinting;
    private Boolean swimming;
    private Boolean baby;
    private ItemObject head;
    private ItemObject chest;
    private ItemObject legs;
    private ItemObject feet;
    private ItemObject mainHand;
    private ItemObject offHand;
    private Cat.Type catType;

    @Nullable
    @Contract(pure=true)
    public EntityType getType() {
        return this.type;
    }

    @Nullable
    @Contract(pure=true)
    public DistanceObject getDistance() {
        return this.distance;
    }

    @Nullable
    @Contract(pure=true)
    public LocationObject getLocation() {
        return this.location;
    }

    @Nullable
    @Contract(pure=true)
    public StatusEffectsObject getEffects() {
        return this.effects;
    }

    @Nullable
    @Contract(pure=true)
    public String getNbt() {
        return this.nbt;
    }

    @Nullable
    @Contract(pure=true)
    public Boolean isOnFire() {
        return this.onFire;
    }

    @Nullable
    @Contract(pure=true)
    public Boolean isSneaking() {
        return this.sneaking;
    }

    @Nullable
    @Contract(pure=true)
    public Boolean isSprinting() {
        return this.sprinting;
    }

    @Nullable
    @Contract(pure=true)
    public Boolean isSwimming() {
        return this.swimming;
    }

    @Nullable
    @Contract(pure=true)
    public Boolean isBaby() {
        return this.baby;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getHead() {
        return this.head;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getChest() {
        return this.chest;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getLegs() {
        return this.legs;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getFeet() {
        return this.feet;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getMainHand() {
        return this.mainHand;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getOffHand() {
        return this.offHand;
    }

    @Nullable
    @Contract(pure=true)
    public Cat.Type getCatType() {
        return this.catType;
    }

    @NotNull
    public EntityObject setType(@Nullable EntityType type) {
        this.type = type;
        return this;
    }

    @NotNull
    public EntityObject setDistance(@Nullable DistanceObject distance) {
        this.distance = distance;
        return this;
    }

    @NotNull
    public EntityObject setLocation(@Nullable LocationObject location) {
        this.location = location;
        return this;
    }

    @NotNull
    public EntityObject setEffects(@Nullable StatusEffectsObject effects) {
        this.effects = effects;
        return this;
    }

    @NotNull
    public EntityObject setNbt(@Nullable String nbt) {
        Validator.nbt(nbt);
        this.nbt = nbt;
        return this;
    }

    @NotNull
    public EntityObject setOnFire(@Nullable Boolean onFire) {
        this.onFire = onFire;
        return this;
    }

    @NotNull
    public EntityObject setSneaking(@Nullable Boolean sneaking) {
        this.sneaking = sneaking;
        return this;
    }

    @NotNull
    public EntityObject setSprinting(@Nullable Boolean sprinting) {
        this.sprinting = sprinting;
        return this;
    }

    @NotNull
    public EntityObject setSwimming(@Nullable Boolean swimming) {
        this.swimming = swimming;
        return this;
    }

    @NotNull
    public EntityObject setBaby(@Nullable Boolean baby) {
        this.baby = baby;
        return this;
    }

    @NotNull
    public EntityObject setHead(@Nullable ItemObject head) {
        this.head = head;
        return this;
    }

    @NotNull
    public EntityObject setChest(@Nullable ItemObject chest) {
        this.chest = chest;
        return this;
    }

    @NotNull
    public EntityObject setLegs(@Nullable ItemObject legs) {
        this.legs = legs;
        return this;
    }

    @NotNull
    public EntityObject setFeet(@Nullable ItemObject feet) {
        this.feet = feet;
        return this;
    }

    @NotNull
    public EntityObject setMainHand(@Nullable ItemObject mainHand) {
        this.mainHand = mainHand;
        return this;
    }

    @NotNull
    public EntityObject setOffHand(@Nullable ItemObject offHand) {
        this.offHand = offHand;
        return this;
    }

    @NotNull
    public EntityObject setCatType(@Nullable Cat.Type catType) {
        this.catType = catType;
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        JsonBuilder builder = new JsonBuilder().add("type", (Keyed)this.type).add("distance", this.distance).add("location", this.location).add("effects", this.effects).add("nbt", this.nbt);
        if (this.onFire != null || this.sneaking != null || this.sprinting != null || this.swimming != null || this.baby != null) {
            builder.add("flags", (JsonElement)new JsonBuilder().add("is_on_fire", this.onFire).add("is_sneaking", this.sneaking).add("is_sprinting", this.sprinting).add("is_swimming", this.swimming).add("is_baby", this.baby).build());
        }
        if (this.head != null || this.chest != null || this.legs != null || this.feet != null || this.mainHand != null || this.offHand != null) {
            builder.add("equipment", (JsonElement)new JsonBuilder().add("head", this.head).add("chest", this.chest).add("legs", this.legs).add("feet", this.feet).add("mainhand", this.mainHand).add("offhand", this.offHand).build());
        }
        if (this.catType != null) {
            builder.add("catType", "minecraft:textures/entity/cat/" + this.catType.name().toLowerCase() + ".png");
        }
        return builder.build();
    }
}

