/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.shared;

import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.EnchantObject;
import hu.trigary.advancementcreator.shared.Potion;
import hu.trigary.advancementcreator.shared.RangeObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import hu.trigary.advancementcreator.util.JsonBuilder;
import hu.trigary.advancementcreator.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemObject
extends SharedObject {
    private Material item;
    private RangeObject durability;
    private RangeObject count;
    private Potion potion;
    private Set<EnchantObject> enchants;
    private String nbt;

    @Nullable
    @Contract(pure=true)
    public Material getItem() {
        return this.item;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getDurability() {
        return this.durability;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getCount() {
        return this.count;
    }

    @Nullable
    @Contract(pure=true)
    public Potion getPotion() {
        return this.potion;
    }

    @NotNull
    @Contract(pure=true)
    public Set<EnchantObject> getEnchants() {
        return this.enchants == null ? Collections.emptySet() : Collections.unmodifiableSet(this.enchants);
    }

    @Nullable
    @Contract(pure=true)
    public String getNbt() {
        return this.nbt;
    }

    @NotNull
    public ItemObject setItem(@Nullable Material item) {
        this.item = item;
        return this;
    }

    @NotNull
    public ItemObject setDurability(@Nullable RangeObject durability) {
        this.durability = durability;
        return this;
    }

    @NotNull
    public ItemObject setCount(@Nullable RangeObject count) {
        this.count = count;
        return this;
    }

    @NotNull
    public ItemObject setPotion(@Nullable Potion potion) {
        this.potion = potion;
        return this;
    }

    @NotNull
    public ItemObject addEnchant(@NotNull EnchantObject enchant) {
        Validate.notNull((Object)enchant);
        if (this.enchants == null) {
            this.enchants = new HashSet<EnchantObject>();
        }
        this.enchants.add(enchant);
        return this;
    }

    @NotNull
    public ItemObject removeEnchant(@NotNull EnchantObject enchant) {
        Validate.notNull((Object)enchant);
        if (this.enchants != null) {
            this.enchants.remove(enchant);
        }
        return this;
    }

    @NotNull
    public ItemObject setNbt(@Nullable String nbt) {
        Validator.nbt(nbt);
        this.nbt = nbt;
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        return new JsonBuilder().add("item", (Keyed)this.item).add("durability", this.durability).add("count", this.count).add("nbt", this.nbt).add("potion", this.potion).add("enchantments", this.enchants, SharedObject::toJson).build();
    }
}

