/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.shared;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.Dimension;
import hu.trigary.advancementcreator.shared.RangeObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import hu.trigary.advancementcreator.util.JsonBuilder;
import org.bukkit.Keyed;
import org.bukkit.StructureType;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationObject
extends SharedObject {
    private RangeObject x;
    private RangeObject y;
    private RangeObject z;
    private Biome biome;
    private StructureType feature;
    private Dimension dimension;

    @Nullable
    @Contract(pure=true)
    public RangeObject getX() {
        return this.x;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getY() {
        return this.y;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getZ() {
        return this.z;
    }

    @Nullable
    @Contract(pure=true)
    public Biome getBiome() {
        return this.biome;
    }

    @Nullable
    @Contract(pure=true)
    public StructureType getFeature() {
        return this.feature;
    }

    @Nullable
    @Contract(pure=true)
    public Dimension getDimension() {
        return this.dimension;
    }

    @NotNull
    public LocationObject setX(@Nullable RangeObject x) {
        this.x = x;
        return this;
    }

    @NotNull
    public LocationObject setY(@Nullable RangeObject y) {
        this.y = y;
        return this;
    }

    @NotNull
    public LocationObject setZ(@Nullable RangeObject z) {
        this.z = z;
        return this;
    }

    @NotNull
    public LocationObject setBiome(@Nullable Biome biome) {
        this.biome = biome;
        return this;
    }

    @NotNull
    public LocationObject setFeature(@Nullable StructureType feature) {
        this.feature = feature;
        return this;
    }

    @NotNull
    public LocationObject setDimension(@Nullable Dimension dimension) {
        this.dimension = dimension;
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        JsonBuilder builder = new JsonBuilder();
        if (this.x != null || this.y != null || this.z != null) {
            builder.add("position", (JsonElement)new JsonBuilder().add("x", this.x).add("y", this.y).add("z", this.z).build());
        }
        if (this.feature != null) {
            builder.add("feature", "minecraft:" + this.feature.getName());
        }
        return builder.add("biome", (Keyed)this.biome).add("dimension", this.dimension).build();
    }
}

