/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.shared;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.Effect;
import hu.trigary.advancementcreator.shared.EffectObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusEffectsObject
extends SharedObject {
    private final Map<Effect, EffectObject> effects = new HashMap<Effect, EffectObject>();

    @NotNull
    @Contract(pure=true)
    public Map<Effect, EffectObject> getEffects() {
        return Collections.unmodifiableMap(this.effects);
    }

    @NotNull
    public StatusEffectsObject setEffect(@NotNull Effect effect, @Nullable EffectObject properties) {
        Validate.notNull((Object)effect);
        if (properties == null) {
            this.effects.remove(effect);
        } else {
            this.effects.put(effect, properties);
        }
        return this;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.effects.forEach((effect, properties) -> json.add(effect.getValue(), (JsonElement)properties.toJson()));
        return json;
    }
}

