/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.shared.RangeObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.JsonBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryChangedTrigger
extends Trigger {
    private RangeObject occupied;
    private RangeObject full;
    private RangeObject empty;
    private Set<ItemObject> items;

    public InventoryChangedTrigger() {
        super(Trigger.Type.INVENTORY_CHANGED);
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getOccupied() {
        return this.occupied;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getFull() {
        return this.full;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getEmpty() {
        return this.empty;
    }

    @NotNull
    @Contract(pure=true)
    public Set<ItemObject> getItems() {
        return this.items == null ? Collections.emptySet() : Collections.unmodifiableSet(this.items);
    }

    @NotNull
    public InventoryChangedTrigger setOccupied(@Nullable RangeObject occupied) {
        this.occupied = occupied;
        return this;
    }

    @NotNull
    public InventoryChangedTrigger setFull(@Nullable RangeObject full) {
        this.full = full;
        return this;
    }

    @NotNull
    public InventoryChangedTrigger setEmpty(@Nullable RangeObject empty) {
        this.empty = empty;
        return this;
    }

    @NotNull
    public InventoryChangedTrigger addItem(@NotNull ItemObject item) {
        Validate.notNull((Object)item);
        if (this.items == null) {
            this.items = new HashSet<ItemObject>();
        }
        this.items.add(item);
        return this;
    }

    @NotNull
    public InventoryChangedTrigger removeItem(@NotNull ItemObject item) {
        Validate.notNull((Object)item);
        if (this.items != null) {
            this.items.remove(item);
        }
        return this;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    protected JsonObject getConditions() {
        JsonBuilder json = new JsonBuilder();
        if (this.occupied != null || this.full != null || this.empty != null) {
            json.add("slots", (JsonElement)new JsonBuilder().add("occupied", this.occupied).add("full", this.full).add("empty", this.empty).build());
        }
        return json.add("items", this.items, SharedObject::toJson).build();
    }
}

