/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.trigger;

import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.shared.RangeObject;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.JsonBuilder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDurabilityChangedTrigger
extends Trigger {
    private ItemObject item;
    private RangeObject durability;
    private RangeObject delta;

    public ItemDurabilityChangedTrigger() {
        super(Trigger.Type.ITEM_DURABILITY_CHANGED);
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getItem() {
        return this.item;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getDurability() {
        return this.durability;
    }

    @Nullable
    @Contract(pure=true)
    public RangeObject getDelta() {
        return this.delta;
    }

    @NotNull
    public ItemDurabilityChangedTrigger setItem(@Nullable ItemObject item) {
        this.item = item;
        return this;
    }

    @NotNull
    public ItemDurabilityChangedTrigger setDurability(@Nullable RangeObject durability) {
        this.durability = durability;
        return this;
    }

    @NotNull
    public ItemDurabilityChangedTrigger setDelta(@Nullable RangeObject delta) {
        this.delta = delta;
        return this;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    protected JsonObject getConditions() {
        return new JsonBuilder().add("item", this.item).add("durability", this.durability).add("delta", this.delta).build();
    }
}

