/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.trigger;

import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.EntityObject;
import hu.trigary.advancementcreator.shared.SharedObject;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.JsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KilledByCrossbowTrigger
extends Trigger {
    private Integer uniqueEntityTypes;
    private List<EntityObject> victims;

    public KilledByCrossbowTrigger() {
        super(Trigger.Type.KILLED_BY_CROSSBOW);
    }

    @Nullable
    @Contract(pure=true)
    public Integer getUniqueEntityTypes() {
        return this.uniqueEntityTypes;
    }

    @NotNull
    @Contract(pure=true)
    public List<EntityObject> getVictims() {
        return this.victims == null ? Collections.emptyList() : Collections.unmodifiableList(this.victims);
    }

    @NotNull
    public KilledByCrossbowTrigger setUniqueEntityTypes(@Nullable Integer uniqueEntityTypes) {
        this.uniqueEntityTypes = uniqueEntityTypes;
        return this;
    }

    @NotNull
    public KilledByCrossbowTrigger addVictim(@NotNull EntityObject victim) {
        Validate.notNull((Object)victim);
        if (this.victims == null) {
            this.victims = new ArrayList<EntityObject>();
        }
        this.victims.add(victim);
        return this;
    }

    @NotNull
    public KilledByCrossbowTrigger removeVictim(@NotNull EntityObject victim) {
        Validate.notNull((Object)victim);
        if (this.victims != null) {
            this.victims.remove(victim);
        }
        return this;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    protected JsonObject getConditions() {
        return new JsonBuilder().add("unique_entity_types", this.uniqueEntityTypes).add("victims", this.victims, SharedObject::toJson).build();
    }
}

