/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.trigger;

import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.BlockObject;
import hu.trigary.advancementcreator.shared.ItemObject;
import hu.trigary.advancementcreator.shared.LocationObject;
import hu.trigary.advancementcreator.trigger.Trigger;
import hu.trigary.advancementcreator.util.JsonBuilder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlacedBlockTrigger
extends Trigger {
    private BlockObject block;
    private ItemObject item;
    private LocationObject location;

    public PlacedBlockTrigger() {
        super(Trigger.Type.PLACED_BLOCK);
    }

    @Nullable
    @Contract(pure=true)
    public BlockObject getBlock() {
        return this.block;
    }

    @Nullable
    @Contract(pure=true)
    public ItemObject getItem() {
        return this.item;
    }

    @Nullable
    @Contract(pure=true)
    public LocationObject getLocation() {
        return this.location;
    }

    @NotNull
    public PlacedBlockTrigger setBlock(@Nullable BlockObject block) {
        this.block = block;
        return this;
    }

    @NotNull
    public PlacedBlockTrigger setLocation(@Nullable LocationObject location) {
        this.location = location;
        return this;
    }

    @NotNull
    public PlacedBlockTrigger setItem(@Nullable ItemObject item) {
        this.item = item;
        return this;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    protected JsonObject getConditions() {
        return (this.block == null ? new JsonBuilder() : new JsonBuilder(this.block.toJson())).add("item", this.item).add("location", this.location).build();
    }
}

