/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.SharedEnum;
import hu.trigary.advancementcreator.util.JsonBuilder;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Trigger {
    private final Type type;

    protected Trigger(@NotNull Type type) {
        Validate.notNull((Object)type);
        this.type = type;
    }

    @NotNull
    @Contract(pure=true)
    public Type getType() {
        return this.type;
    }

    @NotNull
    @Contract(pure=true)
    public final JsonObject toJson() {
        return new JsonBuilder().add("trigger", this.type.getValue()).add("conditions", (JsonElement)this.getConditions()).build();
    }

    @NotNull
    @Contract(pure=true)
    protected abstract JsonObject getConditions();

    @Contract(pure=true)
    public int hashCode() {
        return Objects.hash(this.type, this.getConditions());
    }

    @Contract(pure=true, value="null -> false")
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Trigger)) {
            return false;
        }
        Trigger trigger = (Trigger)object;
        return trigger.type == this.type && Objects.equals(trigger.getConditions(), this.getConditions());
    }

    public static enum Type implements SharedEnum
    {
        BRED_ANIMALS,
        BREWED_POTION,
        CHANGED_DIMENSION,
        CHANNELED_LIGHTNING,
        CONSTRUCT_BEACON,
        CONSUME_ITEM,
        CURED_ZOMBIE_VILLAGER,
        EFFECTS_CHANGED,
        ENCHANTED_ITEM,
        ENTER_BLOCK,
        ENTITY_HURT_PLAYER,
        ENTITY_KILLED_PLAYER,
        FILLED_BUCKET,
        FISHING_ROD_HOOKED,
        HERO_OF_THE_VILLAGE,
        IMPOSSIBLE,
        INVENTORY_CHANGED,
        ITEM_DURABILITY_CHANGED,
        KILLED_BY_CROSSBOW,
        LEVITATION,
        LOCATION,
        NETHER_TRAVEL,
        PLACED_BLOCK,
        PLAYER_HURT_ENTITY,
        PLAYER_KILLED_ENTITY,
        RECIPE_UNLOCKED,
        SHOT_CROSSBOW,
        SLEPT_IN_BED,
        SUMMONED_ENTITY,
        TAME_ANIMAL,
        TICK,
        USED_ENDER_EYE,
        USED_TOTEM,
        VILLAGER_TRADE,
        VOLUNTARY_EXILE;


        @Override
        @NotNull
        @Contract(pure=true)
        public String getValue() {
            return "minecraft:" + this.name().toLowerCase();
        }
    }
}

