/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hu.trigary.advancementcreator.shared.SharedEnum;
import hu.trigary.advancementcreator.shared.SharedObject;
import java.util.Collection;
import java.util.function.Function;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBuilder {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final JsonObject json;

    public JsonBuilder() {
        this(new JsonObject());
    }

    public JsonBuilder(@NotNull JsonObject source) {
        this.json = source;
    }

    @NotNull
    @Contract(pure=true)
    public JsonObject build() {
        return this.json;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable String value) {
        if (value != null) {
            this.json.addProperty(key, value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable Number value) {
        if (value != null) {
            this.json.addProperty(key, value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable Boolean value) {
        if (value != null) {
            this.json.addProperty(key, value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable JsonElement value) {
        if (value != null) {
            this.json.add(key, value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder addNonNegative(@NotNull String key, int value) {
        if (value >= 0) {
            this.json.addProperty(key, (Number)value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder addPositive(@NotNull String key, int value) {
        if (value > 0) {
            this.json.addProperty(key, (Number)value);
        }
        return this;
    }

    @NotNull
    public JsonBuilder addTrue(@NotNull String key, boolean value) {
        if (value) {
            this.json.addProperty(key, Boolean.valueOf(true));
        }
        return this;
    }

    @NotNull
    public JsonBuilder addFalse(@NotNull String key, boolean value) {
        if (!value) {
            this.json.addProperty(key, Boolean.valueOf(false));
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable SharedObject value) {
        if (value != null) {
            this.json.add(key, value.toJson());
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable SharedEnum value) {
        if (value != null) {
            this.json.addProperty(key, value.getValue());
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable NamespacedKey value) {
        if (value != null) {
            this.json.addProperty(key, value.toString());
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable Keyed value) {
        if (value != null) {
            this.json.addProperty(key, value.getKey().toString());
        }
        return this;
    }

    @NotNull
    public JsonBuilder add(@NotNull String key, @Nullable TextComponent value) {
        if (value != null) {
            this.json.add(key, (JsonElement)GSON.fromJson(ComponentSerializer.toString((BaseComponent)value), JsonElement.class));
        }
        return this;
    }

    @NotNull
    public <T> JsonBuilder add(@NotNull String key, @Nullable Collection<T> value, Function<T, JsonElement> mapper) {
        if (value != null && !value.isEmpty()) {
            JsonArray array = new JsonArray();
            value.stream().map(mapper).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            this.json.add(key, (JsonElement)array);
        }
        return this;
    }
}

