/*
 * Decompiled with CFR 0.152.
 */
package hu.trigary.advancementcreator.util;

import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Validator {
    public static void noNamespace(@NotNull String id) {
        Validate.notNull((Object)id);
        Validate.isTrue((!id.contains(":") ? 1 : 0) != 0, (String)"The id parameter must not contain namespaces: ", (Object)id);
        Validate.isTrue((!id.contains(" ") ? 1 : 0) != 0, (String)"The id parameter must not contain spaces: ", (Object)id);
    }

    public static void texture(@NotNull String texture) {
        Validate.notNull((Object)texture);
        Validate.isTrue((!texture.contains(":") ? 1 : 0) != 0, (String)"Texture parameter must not contain namespace: ", (Object)texture);
        Validate.isTrue((!texture.startsWith("textures/") ? 1 : 0) != 0, (String)"Texture parameter must not include root directory (/textures): ", (Object)texture);
        Validate.isTrue((!texture.contains(".") ? 1 : 0) != 0, (String)"Texture parameter must not specify file extension: ", (Object)texture);
        Validate.isTrue((boolean)texture.contains("/"), (String)"Texture parameter must specify subdirectory using slash (/): ", (Object)texture);
        Validate.isTrue((!texture.endsWith("/") ? 1 : 0) != 0, (String)"Texture parameter must specify a file in the directory: ", (Object)texture);
    }

    public static void nbt(@Nullable String nbt) {
        if (nbt != null) {
            Validate.isTrue((nbt.startsWith("{") && nbt.endsWith("}") ? 1 : 0) != 0, (String)"NBT string must start and end with curly braces: ", (Object)nbt);
        }
    }

    public static void minusToDisable(int value) {
        Validate.isTrue((value >= -1 ? 1 : 0) != 0, (String)"Set to -1 to disable.");
    }

    public static void zeroToDisable(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Set to 0 to disable.");
    }
}

