/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class KickedFromServerEvent
implements ResultedEvent<ServerKickResult> {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable Component originalReason;
    private final boolean duringServerConnect;
    private ServerKickResult result;

    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, ServerKickResult result) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.originalReason = originalReason;
        this.duringServerConnect = duringServerConnect;
        this.result = (ServerKickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    @Override
    public @NonNull ServerKickResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull ServerKickResult result) {
        this.result = (ServerKickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public @NonNull Player getPlayer() {
        return this.player;
    }

    public @NonNull RegisteredServer getServer() {
        return this.server;
    }

    public Optional<Component> getServerKickReason() {
        return Optional.ofNullable(this.originalReason);
    }

    public boolean kickedDuringServerConnect() {
        return this.duringServerConnect;
    }

    @Deprecated
    public boolean kickedDuringLogin() {
        return this.duringServerConnect;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ServerKickResult
    extends ResultedEvent.Result {
    }

    public static final class Notify
    implements ServerKickResult {
        private final Component message;

        private Notify(Component message) {
            this.message = (Component)Preconditions.checkNotNull((Object)message, (Object)"message");
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public Component getMessageComponent() {
            return this.message;
        }

        public static Notify create(@NonNull Component message) {
            return new Notify(message);
        }

        public String toString() {
            return "KickedFromServerEvent#Notify{isAllowed=%s,message=%s}".formatted(this.isAllowed(), this.message);
        }
    }

    public static final class RedirectPlayer
    implements ServerKickResult {
        private final Component message;
        private final RegisteredServer server;

        private RedirectPlayer(RegisteredServer server, @Nullable Component message) {
            this.server = (RegisteredServer)Preconditions.checkNotNull((Object)server, (Object)"server");
            this.message = message;
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public @NonNull RegisteredServer getServer() {
            return this.server;
        }

        public @Nullable Component getMessageComponent() {
            return this.message;
        }

        public static RedirectPlayer create(@NonNull RegisteredServer server, Component message) {
            return new RedirectPlayer(server, message);
        }

        public static ServerKickResult create(RegisteredServer server) {
            return new RedirectPlayer(server, null);
        }

        public String toString() {
            return "KickedFromServerEvent#RedirectPlayer{isAllowed=%s,message=%s,server=%s}".formatted(this.isAllowed(), this.message, this.server);
        }
    }

    public static final class DisconnectPlayer
    implements ServerKickResult {
        private final Component component;

        private DisconnectPlayer(Component component) {
            this.component = (Component)Preconditions.checkNotNull((Object)component, (Object)"component");
        }

        @Override
        public boolean isAllowed() {
            return true;
        }

        public Component getReasonComponent() {
            return this.component;
        }

        public static DisconnectPlayer create(Component reason) {
            return new DisconnectPlayer(reason);
        }

        public String toString() {
            return "KickedFromServerEvent#DisconnectPlayer{isAllowed=%s,component=%s}".formatted(this.isAllowed(), this.component);
        }
    }
}

