/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.player;

import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.crypto.KeyIdentifiable;
import com.velocitypowered.api.proxy.player.ChatSession;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.util.GameProfile;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TabListEntry
extends KeyIdentifiable {
    public @Nullable ChatSession getChatSession();

    @Override
    default public IdentifiedKey getIdentifiedKey() {
        ChatSession session = this.getChatSession();
        if (session == null) {
            return null;
        }
        return this.getChatSession().getIdentifiedKey();
    }

    public TabList getTabList();

    public GameProfile getProfile();

    public Optional<Component> getDisplayNameComponent();

    public TabListEntry setDisplayName(@Nullable Component var1);

    public int getLatency();

    public TabListEntry setLatency(int var1);

    public int getGameMode();

    public TabListEntry setGameMode(int var1);

    default public boolean isListed() {
        return true;
    }

    default public TabListEntry setListed(boolean listed) {
        return this;
    }

    default public int getListOrder() {
        return 0;
    }

    default public TabListEntry setListOrder(int order) {
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable TabList tabList;
        private @Nullable GameProfile profile;
        private @Nullable Component displayName;
        private int latency = 0;
        private int gameMode = 0;
        private boolean listed = true;
        private int listOrder = 0;
        private @Nullable ChatSession chatSession;

        private Builder() {
        }

        public Builder tabList(TabList tabList) {
            this.tabList = tabList;
            return this;
        }

        public Builder profile(GameProfile profile) {
            this.profile = profile;
            return this;
        }

        public Builder chatSession(ChatSession chatSession) {
            this.chatSession = chatSession;
            return this;
        }

        public Builder displayName(@Nullable Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder latency(int latency) {
            this.latency = latency;
            return this;
        }

        public Builder gameMode(int gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public Builder listed(boolean listed) {
            this.listed = listed;
            return this;
        }

        public Builder listOrder(int order) {
            this.listOrder = order;
            return this;
        }

        public TabListEntry build() {
            if (this.tabList == null) {
                throw new IllegalStateException("The Tablist must be set when building a TabListEntry");
            }
            if (this.profile == null) {
                throw new IllegalStateException("The GameProfile must be set when building a TabListEntry");
            }
            return this.tabList.buildEntry(this.profile, this.displayName, this.latency, this.gameMode, this.chatSession, this.listed, this.listOrder);
        }
    }
}

