/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class QueryResponse {
    private final String hostname;
    private final String gameVersion;
    private final String map;
    private final int currentPlayers;
    private final int maxPlayers;
    private final String proxyHost;
    private final int proxyPort;
    private final ImmutableCollection<String> players;
    private final String proxyVersion;
    private final ImmutableCollection<PluginInformation> plugins;

    @VisibleForTesting
    QueryResponse(String hostname, String gameVersion, String map, int currentPlayers, int maxPlayers, String proxyHost, int proxyPort, ImmutableCollection<String> players, String proxyVersion, ImmutableCollection<PluginInformation> plugins) {
        this.hostname = hostname;
        this.gameVersion = gameVersion;
        this.map = map;
        this.currentPlayers = currentPlayers;
        this.maxPlayers = maxPlayers;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.players = players;
        this.proxyVersion = proxyVersion;
        this.plugins = plugins;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public String getMap() {
        return this.map;
    }

    public int getCurrentPlayers() {
        return this.currentPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public Collection<String> getPlayers() {
        return this.players;
    }

    public String getProxyVersion() {
        return this.proxyVersion;
    }

    public Collection<PluginInformation> getPlugins() {
        return this.plugins;
    }

    public Builder toBuilder() {
        return QueryResponse.builder().hostname(this.getHostname()).gameVersion(this.getGameVersion()).map(this.getMap()).currentPlayers(this.getCurrentPlayers()).maxPlayers(this.getMaxPlayers()).proxyHost(this.getProxyHost()).proxyPort(this.getProxyPort()).players(this.getPlayers()).proxyVersion(this.getProxyVersion()).plugins(this.getPlugins());
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResponse response = (QueryResponse)o;
        return this.currentPlayers == response.currentPlayers && this.maxPlayers == response.maxPlayers && this.proxyPort == response.proxyPort && this.hostname.equals(response.hostname) && this.gameVersion.equals(response.gameVersion) && this.map.equals(response.map) && this.proxyHost.equals(response.proxyHost) && this.players.equals(response.players) && this.proxyVersion.equals(response.proxyVersion) && this.plugins.equals(response.plugins);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.gameVersion, this.map, this.currentPlayers, this.maxPlayers, this.proxyHost, this.proxyPort, this.players, this.proxyVersion, this.plugins);
    }

    public String toString() {
        return "QueryResponse{hostname='" + this.hostname + "', gameVersion='" + this.gameVersion + "', map='" + this.map + "', currentPlayers=" + this.currentPlayers + ", maxPlayers=" + this.maxPlayers + ", proxyHost='" + this.proxyHost + "', proxyPort=" + this.proxyPort + ", players=" + String.valueOf(this.players) + ", proxyVersion='" + this.proxyVersion + "', plugins=" + String.valueOf(this.plugins) + "}";
    }

    public static final class Builder {
        private @MonotonicNonNull String hostname;
        private @MonotonicNonNull String gameVersion;
        private @MonotonicNonNull String map;
        private @MonotonicNonNull String proxyHost;
        private @MonotonicNonNull String proxyVersion;
        private int currentPlayers;
        private int maxPlayers;
        private int proxyPort;
        private List<String> players = new ArrayList<String>();
        private List<PluginInformation> plugins = new ArrayList<PluginInformation>();

        private Builder() {
        }

        public Builder hostname(String hostname) {
            this.hostname = (String)Preconditions.checkNotNull((Object)hostname, (Object)"hostname");
            return this;
        }

        public Builder gameVersion(String gameVersion) {
            this.gameVersion = (String)Preconditions.checkNotNull((Object)gameVersion, (Object)"gameVersion");
            return this;
        }

        public Builder map(String map) {
            this.map = (String)Preconditions.checkNotNull((Object)map, (Object)"map");
            return this;
        }

        public Builder currentPlayers(int currentPlayers) {
            Preconditions.checkArgument((currentPlayers >= 0 ? 1 : 0) != 0, (Object)"currentPlayers cannot be negative");
            this.currentPlayers = currentPlayers;
            return this;
        }

        public Builder maxPlayers(int maxPlayers) {
            Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers cannot be negative");
            this.maxPlayers = maxPlayers;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = (String)Preconditions.checkNotNull((Object)proxyHost, (Object)"proxyHost");
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            Preconditions.checkArgument((proxyPort >= 1 && proxyPort <= 65535 ? 1 : 0) != 0, (Object)"proxyPort must be between 1-65535");
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder players(Collection<String> players) {
            this.players.addAll((Collection)Preconditions.checkNotNull(players, (Object)"players"));
            return this;
        }

        public Builder players(String ... players) {
            this.players.addAll(Arrays.asList((String[])Preconditions.checkNotNull((Object)players, (Object)"players")));
            return this;
        }

        public Builder clearPlayers() {
            this.players.clear();
            return this;
        }

        public Builder proxyVersion(String proxyVersion) {
            this.proxyVersion = (String)Preconditions.checkNotNull((Object)proxyVersion, (Object)"proxyVersion");
            return this;
        }

        public Builder plugins(Collection<PluginInformation> plugins) {
            this.plugins.addAll((Collection)Preconditions.checkNotNull(plugins, (Object)"plugins"));
            return this;
        }

        public Builder plugins(PluginInformation ... plugins) {
            this.plugins.addAll(Arrays.asList(plugins));
            return this;
        }

        public Builder clearPlugins() {
            this.plugins.clear();
            return this;
        }

        public QueryResponse build() {
            return new QueryResponse((String)Preconditions.checkNotNull((Object)this.hostname, (Object)"hostname"), (String)Preconditions.checkNotNull((Object)this.gameVersion, (Object)"gameVersion"), (String)Preconditions.checkNotNull((Object)this.map, (Object)"map"), this.currentPlayers, this.maxPlayers, (String)Preconditions.checkNotNull((Object)this.proxyHost, (Object)"proxyHost"), this.proxyPort, (ImmutableCollection<String>)ImmutableList.copyOf(this.players), (String)Preconditions.checkNotNull((Object)this.proxyVersion, (Object)"proxyVersion"), (ImmutableCollection<PluginInformation>)ImmutableList.copyOf(this.plugins));
        }
    }

    public static final class PluginInformation {
        private final String name;
        private final @Nullable String version;

        PluginInformation(String name, @Nullable String version) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getVersion() {
            return Optional.ofNullable(this.version);
        }

        public static PluginInformation of(String name, @Nullable String version) {
            return new PluginInformation(name, version);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInformation that = (PluginInformation)o;
            return this.name.equals(that.name) && Objects.equals(this.version, that.version);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.version);
        }
    }
}

