/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.Arrays;
import net.kyori.adventure.key.Key;

@AwaitingEvent
public final class CookieStoreEvent
implements ResultedEvent<ForwardResult> {
    private final Player player;
    private final Key originalKey;
    private final byte[] originalData;
    private ForwardResult result;

    public CookieStoreEvent(Player player, Key key, byte[] data) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.originalKey = (Key)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.originalData = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data");
        this.result = ForwardResult.forward();
    }

    @Override
    public ForwardResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(ForwardResult result) {
        this.result = (ForwardResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public Player getPlayer() {
        return this.player;
    }

    public Key getOriginalKey() {
        return this.originalKey;
    }

    public byte[] getOriginalData() {
        return this.originalData;
    }

    public String toString() {
        return "CookieStoreEvent{, originalKey=" + String.valueOf(this.originalKey) + ", originalData=" + Arrays.toString(this.originalData) + ", result=" + String.valueOf(this.result) + "}";
    }

    public static final class ForwardResult
    implements ResultedEvent.Result {
        private static final ForwardResult ALLOWED = new ForwardResult(true, null, null);
        private static final ForwardResult DENIED = new ForwardResult(false, null, null);
        private final boolean status;
        private final Key key;
        private final byte[] data;

        private ForwardResult(boolean status, Key key, byte[] data) {
            this.status = status;
            this.key = key;
            this.data = data;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public Key getKey() {
            return this.key;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.status ? "forward to client" : "handled by proxy";
        }

        public static ForwardResult forward() {
            return ALLOWED;
        }

        public static ForwardResult handled() {
            return DENIED;
        }

        public static ForwardResult key(Key key) {
            Preconditions.checkNotNull((Object)key, (Object)"key");
            return new ForwardResult(true, key, null);
        }

        public static ForwardResult data(byte[] data) {
            Preconditions.checkNotNull((Object)data, (Object)"data");
            return new ForwardResult(true, null, data);
        }
    }
}

