/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.dialog.template;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class StringTemplate {
    private static final int MAX_LENGTH = 2000000;
    private final List<String> segments;
    private final List<String> variables;

    public static StringTemplate parse(String input) {
        ArrayList<String> segments = new ArrayList<String>();
        ArrayList<String> variables = new ArrayList<String>();
        int length = input.length();
        int current = 0;
        int variableStart = input.indexOf(36);
        while (variableStart != -1) {
            if (variableStart != length - 1 && input.charAt(variableStart + 1) == '(') {
                segments.add(input.substring(current, variableStart));
                int variableEnd = input.indexOf(41, variableStart + 1);
                if (variableEnd == -1) {
                    throw new IllegalArgumentException("Unterminated macro variable");
                }
                String variable = input.substring(variableStart + 2, variableEnd);
                if (StringTemplate.isValidVariableName(variable)) {
                    throw new IllegalArgumentException("Invalid macro variable name: " + variable);
                }
                variables.add(variable);
                current = variableEnd + 1;
                variableStart = input.indexOf(36, current);
                continue;
            }
            variableStart = input.indexOf(36, variableStart + 1);
        }
        if (current == 0) {
            throw new IllegalArgumentException("No variables in macro");
        }
        if (current != length) {
            segments.add(input.substring(current));
        }
        return new StringTemplate(segments, variables);
    }

    public static boolean isValidVariableName(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public String substitute(List<String> input) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.variables.size(); ++i) {
            out.append(this.segments.get(i)).append(input.get(i));
            if (out.length() <= 2000000) continue;
            throw new IllegalArgumentException("Output too long (> 2000000)");
        }
        if (this.segments.size() > this.variables.size()) {
            out.append(this.segments.get(this.segments.size() - 1));
            if (out.length() > 2000000) {
                throw new IllegalArgumentException("Output too long (> 2000000)");
            }
        }
        return out.toString();
    }

    @Generated
    public StringTemplate(List<String> segments, List<String> variables) {
        this.segments = segments;
        this.variables = variables;
    }

    @Generated
    public List<String> getSegments() {
        return this.segments;
    }

    @Generated
    public List<String> getVariables() {
        return this.variables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringTemplate)) {
            return false;
        }
        StringTemplate other = (StringTemplate)o;
        List<String> this$segments = this.getSegments();
        List<String> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        List<String> this$variables = this.getVariables();
        List<String> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        List<String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StringTemplate(segments=" + this.getSegments() + ", variables=" + this.getVariables() + ")";
    }
}

