/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.registry;

import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Result;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.registry.Registry;
import lombok.Generated;

public class RegistryTag {
    private final Registry registry;
    private final Identifier tag;

    public static Codec<RegistryTag> codec(Registry registry) {
        return Codec.STRING.verified(s -> s.startsWith("#") ? null : Result.error((String)"Tag needs to start with #")).flatMap(identifier -> Result.success((Object)("#" + identifier.get())), s -> {
            Identifier id = Identifier.tryOf((String)s.substring(1));
            if (id == null) {
                return Result.error((String)"Tag is not a valid identifier");
            }
            return Result.success((Object)id);
        }).flatMap(registryTag -> Result.success((Object)registryTag.getTag()), identifier -> {
            RegistryTag tag = registry.getTag((Identifier)identifier);
            if (tag == null) {
                return Result.error((String)("Registry " + registry.getName() + " doesn't contain tag " + identifier));
            }
            return Result.success((Object)tag);
        });
    }

    public RegistryTag(Registry registry, Identifier tag) {
        this.registry = registry;
        this.tag = tag;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Identifier getTag() {
        return this.tag;
    }

    public String toString() {
        return ToString.of((Object)this).add("registry", (Object)this.registry.getName()).add("tag", (Object)this.tag).toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryTag)) {
            return false;
        }
        RegistryTag other = (RegistryTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Registry this$registry = this.getRegistry();
        Registry other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry)) {
            return false;
        }
        Identifier this$tag = this.getTag();
        Identifier other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegistryTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Registry $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        Identifier $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }
}

