/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.registry;

import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Either;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.registry.Registry;
import com.viaversion.viaversion.libs.mcstructs.registry.RegistryEntry;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;

public class Holder<T> {
    private final RegistryEntry entry;
    private final T value;

    public static <T> Codec<Holder<T>> fileCodec(Registry registry, Codec<T> codec) {
        return Codec.either(codec, registry.entryCodec()).map(Either::swap, Either::swap).map(Holder::either, Holder::new);
    }

    public static <T> Codec<Holder<T>> fixedCodec(Registry registry) {
        return Codec.either((Codec)Codec.failing((String)("Can't encode/decode value in fixed codec for registry " + registry.getName())), registry.entryCodec()).map(Either::swap, Either::swap).map(Holder::either, Holder::new);
    }

    public Holder(Either<RegistryEntry, T> either) {
        if (either.isLeft()) {
            this.entry = (RegistryEntry)either.getLeft();
            this.value = null;
        } else {
            this.entry = null;
            this.value = either.getRight();
        }
    }

    public Holder(@Nonnull RegistryEntry entry) {
        this.entry = entry;
        this.value = null;
    }

    public Holder(@Nonnull T value) {
        this.entry = null;
        this.value = value;
    }

    public boolean isEntry() {
        return this.entry != null;
    }

    public RegistryEntry getEntry() {
        if (this.entry == null) {
            throw new IllegalStateException("Either is not an entry");
        }
        return this.entry;
    }

    public boolean isValue() {
        return this.value != null;
    }

    public T getValue() {
        if (this.value == null) {
            throw new IllegalStateException("Either is not a value");
        }
        return this.value;
    }

    public Either<RegistryEntry, T> either() {
        if (this.entry != null) {
            return Either.left((Object)this.entry);
        }
        return Either.right(this.value);
    }

    public String toString() {
        return ToString.of((Object)this).add("entry", (Object)this.entry, Objects::nonNull).add("value", this.value, Objects::nonNull).toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Holder)) {
            return false;
        }
        Holder other = (Holder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegistryEntry this$entry = this.entry;
        RegistryEntry other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !((Object)this$entry).equals(other$entry)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Holder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistryEntry $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : ((Object)$entry).hashCode());
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

