/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.registry;

import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.registry.Registry;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RegistryEntry {
    private final Registry registry;
    private Identifier id;
    private Integer networkId;
    private final int cachedHashCode;

    public RegistryEntry(@Nonnull Registry registry, Identifier id) {
        this.registry = registry;
        this.id = id;
        this.cachedHashCode = id.hashCode();
    }

    public RegistryEntry(Registry registry, int networkId) {
        this.registry = registry;
        this.networkId = networkId;
        this.cachedHashCode = this.networkId.hashCode();
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Identifier getId() {
        if (this.id == null) {
            this.id = this.registry.getId(this.networkId);
            if (this.id == null) {
                throw new IllegalStateException("Network ID " + this.networkId + " not found in registry " + this.registry.getName());
            }
        }
        return this.id;
    }

    public int getNetworkId() {
        if (this.networkId == null) {
            this.networkId = this.registry.getNetworkId(this.id);
            if (this.networkId == null) {
                throw new IllegalStateException("ID " + this.id + " not found in registry " + this.registry.getName());
            }
        }
        return this.networkId;
    }

    public String toString() {
        return ToString.of((Object)this).add("registry", (Object)this.registry.getName()).add("id", (Object)this.id, Objects::nonNull).add("networkId", (Object)this.networkId, Objects::nonNull).toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryEntry that = (RegistryEntry)o;
        return Objects.equals(this.registry, that.registry) && (Objects.equals(this.id, that.id) || Objects.equals(this.networkId, that.networkId));
    }

    public int hashCode() {
        return this.cachedHashCode;
    }
}

